<?php
/**
 * Core - Email Setupp
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
 

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ Test Email Message Dialog ~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-emailtest-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_EmailSetupAdminController" data-button-submit-id="btn-test-dialog-ok" data-action="action=testemail" form-method="post"  data-button-cancel-id="btn-test-dialog-cancel" header-label="<?= ___("Send test email"); ?>">
    
    <x-ui:csrf />
    
    <x-ui:row>
        <!-- col -->
        <x-ui:column md="6">
            
            <!-- field -->
            <x-ui:textbox id="test_email_from" label="<?= ___('From') ?>" fonticon="fas fa-envelope-o" value="<?= ___h(SCHLIX_MAIL_DEFAULT_EMAIL) ?>" readonly="readonly" />

            <!-- field -->
            <x-ui:textbox id="test_email_to" name="msg_to" type="email" fonticon="fa fa-envelope" label="<?= ___('To') ?>" required="required" value="<?= ___h(fsession_string('test_email_to')) ?>" />

            <!-- field -->

            <x-ui:textbox name="msg_subject" maxlength="191" id="msg_subject" label="<?= ___('Subject') ?>" fonticon="fas fa-comment" placeholder="<?= ___('Subject') ?>" value="TEST <?= mt_rand(1000, 65535) ?>" />
            <!-- field -->
            <x-ui:textarea name="msg_message" rows="3" id="msg_comment" label="<?= ___('Comment') ?>" 
                           fonticon="fas fa-comment" placeholder="<?= ___('Type your message') ?>">TEST EMAIL</x-ui:textarea>
            
            
        </x-ui:column>
        <!-- col -->
        <x-ui:column md="6">
            <div id="testemail_send_result" class="mail-debug"><?= ___('Press SEND to begin testing') ?></div>
        </x-ui:column>
    </x-ui:row>
    <!-- form -->
    
    <x-ui:clearboth />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-test-dialog-ok" fonticon="fa fa-envelope" label="<?= ___('Send') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-test-dialog-cancel" fonticon="fa fa-times" label="<?= ___('Close') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>