<?php
/**
 * Core - Emailtemplate - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

$all_wysiwyg_profiles = \App\Core_EditorManager::getAllWysiwygProfiles();

?>
<x-ui:schlix-explorer-sub-application-header />
<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.Core_EmailtemplateAdminController" type="config">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>">     
                            <schlix-config:dropdownlist   config-key="int_wysiwyg_profile_id" label="<?=  ___('Use this WYSIWYG Editor profile') ?>">
                            <?php foreach ($all_wysiwyg_profiles as $profile): ?>
                                <schlix-config:option value="<?= $profile['id'] ?>"><?= ___h('#'.$profile['id'].' '.$profile['editor_name'].': '.$profile['title'].' ('.$profile['virtual_filename'].')') ?> </schlix-config:option>
                            <?php endforeach ?>
                            </schlix-config:dropdownlist>                    

                            <schlix-config:dropdownlist   config-key="int_master_wysiwyg_profile_id" label="<?=  ___('WYSIWYG Editor profile for editing the master template') ?>">
                            <?php foreach ($all_wysiwyg_profiles as $profile): ?>
                                <schlix-config:option value="<?= $profile['id'] ?>"><?= ___h('#'.$profile['id'].' '.$profile['editor_name'].': '.$profile['title'].' ('.$profile['virtual_filename'].')') ?> </schlix-config:option>
                            <?php endforeach ?>
                            </schlix-config:dropdownlist>                    

                </x-ui:schlix-tab>                
                
                <!-- tab -->
               <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>      
