<?php
namespace App;
/**
 * Core: HttpError - Main Class
 * 
 * Core - HttpError
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_HttpError extends \SCHLIX\cmsApplication_List {

    /**
     * Constructor
     */
    
    public function __construct() {
		parent::__construct('HTTP Error', 'gk_httperror_items');
                $this->disable_frontend_runtime = true;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Loads the item and display it with view.item.template.php
     * @param int $id
     * @param bool $from_cache
     */
    public function viewItemByID($id = 1, $from_cache = false)
    {
        $item = $this->getItemByID($id, $from_cache);
        if ($item == NULL)
        {
            //display_http_error(404);            
            die('Unresolved error');
        } else
        {
            $itemopt = isset($item['options']) ? $item['options'] : null;
            $item_meta_options = $this->translateMetaOptions($itemopt);        
            $this->setPageTitle($item['title']);
            if ($this->itemColumnExists('meta_description'))
                $this->setPageMetaDescription($item['meta_description']);
            if ($this->itemColumnExists('meta_key'))
                $this->setPageMetaKeywords ($item['meta_key']);
            $this->getBreadCrumbsByItemID($item['id']);
            if ($this->itemColumnExists('date_modified') && $item['date_modified'] != NULL_DATE && !empty($item['date_modified']))
                $this->declarePageLastModified($item['date_modified']);

            $this->processDataOutputWithMacro($item, __FUNCTION__, array('item_meta_options'=>$item_meta_options));        
            $this->loadTemplateFile('view.item', array('item' => $item, 'item_meta_options' => $item_meta_options));
            $this->increaseItemPageView($item[$this->field_id]);
        }
    }
    
    //_______________________________________________________________________________________________________________//
    public function viewMainPage() {
        $this->viewItemByID('404');

    }

//_______________________________________________________________________________________________________________//
    public function Run($command)
    {

        switch ($command['action'])
        {
            case 'viewitem':
                $this->viewItemByID(intval($command[$this->field_id]), $this->cache);
                return (fget_int('ajax') == 1) ? false : true;

            default:
                return parent::Run($command);
                break;
        }
        return true;
    }



}
            