<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php
$package_info = get_system_or_user_file("/macros/{$item['title']}/packageinfo.inc.php", false); // SCHLIX_SITE_PATH . "/admin;

if (file_exists($package_info))
    include($package_info);

$class_file_info = $this->getCustomizableComponentInfo($item['title']);
$icon_exists = \__HTML::I('', ['class' => 'fas fa-check text-green']);

?>
<div class="content">
    <x-ui:row>
        <!-- Left Column -->
        <x-ui:column xs="12">
            <div  class="text-center">
                <h1><?= isset($name) ? ___h($name) : ___h($item['title']) ?></h1>
                <?php if (isset($version)): ?><p>v<?= $version ?></p><?php endif; ?>
                <?php if (isset($author) && isset($email)): ?><p><?= ___('Author') ?>: <a href="mailto:<?= $email ?>"><?= $author ?></a></p><?php endif; ?>
                <?php if (isset($url)): ?><p><?= ___('Web') ?>: <a href="<?= $url ?>"><?= $url ?></a></p><?php endif; ?>
                <?php if (!$this->isSystem($item['title'])): ?>
                <p><a href="<?= $this->createFriendlyAdminURL('action=uninstall&name=' . convert_into_sef_friendly_title($item['title'])); ?>"><i class="fa fa-times-circle"></i> <?= ___('Uninstall') ?></a></p>
                <?php endif ?>
            </div>
        </x-ui:column>         
    </x-ui:row>
    
<?php /*
    <h3><?= ___('Customizable file(s)') ?></h3>
    <table class="table table-condensed">
    <tr>
        <td><?= $class_file_info['main_file']['text'] ?> </td>
    </tr>
    </table> */ ?>
    <?php if (___c($class_file_info['view_files']) > 0): ?>
    <?php 
        $total_in_system = 0;
        $total_in_subsite = 0;
        foreach ($class_file_info['view_files'] as $vf)
        {
            $total_in_system += (int) $vf['is_in_system'];
            $total_in_subsite += (int) $vf['is_in_web'];
        }
        $relative_dir = "macros/{$item['title']}";
    ?>
    <h3><?= ___('Customizable view file(s)') ?></h3>
    <p><?= ___('The following is a list of view template files currently in use in sub-directory').': '.'/'.$relative_dir ?></p>
    <table class="table table-condensed">
        <th><?= ___('File') ?></th>
        <?php if ($total_in_system > 0): ?>
        <th><?= SCHLIX_SYSTEM_URL_PATH.'/'.$relative_dir ?></th>
        <?php endif ?>
        <?php if ($total_in_subsite > 0): ?>
        <th><?= CURRENT_SUBSITE_URL_PATH.'/'.$relative_dir ?></th>
        <?php endif ?>
        <th><?= CURRENT_THEME_URL_PATH.'/'.$relative_dir ?></th>
    <?php foreach ($class_file_info['view_files'] as $vf): ?>
    <tr>
        <td><?= ___h($vf['filename']) ?> </td>
        <?php if ($total_in_system > 0): ?>
        <td><?= $vf['is_in_system'] && !$vf['is_in_web'] && !$vf['is_in_theme'] ? $icon_exists : null ?> </td>
        <?php endif ?>
        <?php if ($total_in_subsite > 0): ?>
        <td><?= $vf['is_in_web'] && !$vf['is_in_theme']? $icon_exists : null ?> </td>
        <?php endif ?>
        <td><?= $vf['is_in_theme'] ? $icon_exists : null ?> </td>
    </tr>
    <?php endforeach ?>
    </table>
    <?php endif ?>           
</div>    