<?php
namespace App;
/**
 * Core: Media Header - Main Class
 * 
 * Core - Media Header
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_MediaHeader extends \SCHLIX\cmsApplication_List {
    
    protected $valid_extensions = ['png','jpg','jpeg','mp4'];


    protected $data_directories = array(
      'media_original' => '/data/private/header/original', // original
      'media_processed' => '/media/header', // original
    );    
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct("Custom Media Header", 'gk_media_header_items');
        // you can modify these to suit your needs
        $this->disable_frontend_runtime = true;
        $this->hook_priority = 9700;
        $this->has_versioning = true;
    }
    
    /**
     * Validates save item. If there's an error, it will return an array
     * with one or more error string, otherwise it will return a boolean true
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return bool|array String array
     */
    public function getValidationErrorListBeforeSaveItem($datavalues)
    {
        $parent_error_list = parent::getValidationErrorListBeforeSaveItem($datavalues);
        $error_list = array();
        // You can put custom item save validation here
        // e.g. 
        // if (str_contains($datavalues['title'],'a'))
        // $error_list[] = ___('Title may not contain letter a');
        return array_merge($parent_error_list, $error_list);
    }

    /**
     * Before save item
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        // You can customize the data values before it's saved here
        // e.g.
        // $datavalues['title'] = real_strip_tags($datavalues['title']);
        //
        return $datavalues;
    }
    
    /**
     * Do something after save item
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_item
     * @param array $retval
     */
    protected function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval)
    {
        parent::onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval);
    }

    /**
     * Run Command
     * @param array $command
     * @return boolean
     */
    public function Run($command) {
        //$this->insertTest();
        switch ($command['action']) {
            case 'main': $this->viewMainPage($command['pg']);
                return true;
                break;
            default: return parent::Run($command);
        }
    }

    
    /**
     * Save custom header for object
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param \SCHLIX\cmsApplication_List $app
     * @param string $guid
     * @param array $datavalues
     * @param int $id
     */
    public function saveCustomHeaderForObject($app, $guid, $original_datavalues, $datavalues, $id)
    {
        global $SystemDB, $CurrentUser;
        
        $id = (int) $id;
        $int_width = $this->getConfig('int_width',1920);
        $int_height = $this->getConfig('int_height',600);
        $int_image_quality = $this->getConfig('int_image_quality',70);
        
        $this->initializeDataDirectories();
        $current_year_and_month = date('Y-m');
        if ($app && (___c($datavalues) > 0)  && is_valid_guid($guid))
        {
            $current_user_id = $CurrentUser->getCurrentUserID();
            $selection = isset($original_datavalues['cmh_media_selection']) ? $original_datavalues['cmh_media_selection'] : null;
            $value = '';
            switch ($selection)
            {
                case 'path': 
                    // prevent phar injection
                    $insecure = str_contains($original_datavalues['cmh_media_path'], '://');
                    if (!$insecure)
                        $value = $original_datavalues['cmh_media_path'];break;
                case 'url': 
                    // prevent phar injection
                    $insecure = !str_starts_with($original_datavalues['cmh_media_url'], 'https://') &&
                         !str_starts_with($original_datavalues['cmh_media_url'], 'http://');
                    if (!$insecure)                    
                        $value = $original_datavalues['cmh_media_url'];break;
                case 'upload':
                    
                    $uploaded_file = $_FILES['cmh_media_upload'];
                    $new_image_filename = pathinfo($uploaded_file['name'], PATHINFO_BASENAME);
                    $original_image_fullpath = $this->getDataFileFullPath('media_original', $current_year_and_month.'/'. $new_image_filename);
                    $new_image_fullpath = $this->getDataFileFullPath('media_processed', $current_year_and_month.'/'. $new_image_filename);
                    create_directory_if_not_exists(pathinfo($original_image_fullpath, PATHINFO_DIRNAME), true);
                    create_directory_if_not_exists(pathinfo($new_image_fullpath, PATHINFO_DIRNAME), true);
                    $is_uploaded = is_uploaded_file($uploaded_file['tmp_name']);
                    $upload_ok = $uploaded_file['error'] == UPLOAD_ERR_OK;
                    $valid_image = is_valid_uploaded_image_file($uploaded_file['tmp_name'], $new_image_filename);
                    if ($is_uploaded && $upload_ok)
                    {
                        $move_result = move_uploaded_file($uploaded_file['tmp_name'], $original_image_fullpath);
                        if ($move_result)
                        {
                            $resize_result = create_image_thumbnail($original_image_fullpath, $new_image_fullpath, $int_width, $int_height, true, $int_image_quality);
                            $value = $new_image_filename;
                            $size = $uploaded_file['size'];
                            $type = $uploaded_file['type'];
                            
                        }
                    } else return; // if there's no new upload then don't change it
                    break;
                default: // none, clear values
                    break;
                    
            }
           
           $app_name = strtolower(get_class($app));
           $existing_header_image = $this->getHeaderImage($app_name, $guid);
           if ($existing_header_image)
           {

               $cmh_row = ['url_file_media' => $value, 'date_modified' => get_current_datetime(), 'modified_by_id' => $current_user_id];
               if ($selection == 'upload')
                   $cmh_row['parent_dir'] =  $current_year_and_month;
               $sanitized_guid = sanitize_string($guid);
               $sanitized_app_class =sanitize_string($app_name);
               $this->table_items->quickUpdate($cmh_row, "app_class = {$sanitized_app_class} AND guid = {$sanitized_guid}");
           } else
           {
               $cmh_row = ['app_class' => $app_name, 'guid' => $guid, 'url_file_media' => $value, 'date_created' => get_current_datetime(), 'created_by_id' => $current_user_id];
               $cmh_row['parent_dir'] =  ($selection == 'upload') ? $current_year_and_month : '';
               $this->table_items->quickInsert($cmh_row);
           }
           //print_r($original_datavalues);
        }
    }
    
    /**
     * Returns the header image for a class by its GUID data
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $class
     * @param string $guid
     * @return array
     */
    public function getHeaderImage($class, $guid)
    {
        global $SystemDB;
        
        $class = strtolower($class);
        return $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_items} WHERE app_class = :app_class AND guid = :guid", ['app_class' => $class, 'guid' => $guid]);
    }
    
    /**
     * Returns the header image for a class by its GUID data. If none specified,l it will return the app's default header image
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $class
     * @param string $guid
     * @return array
     */
    public function getHeaderImageWithDefault($class, $guid)
    {
        global $SystemDB;
        
        $class = strtolower($class);
        $row = $SystemDB->getQueryResultArray("SELECT * FROM {$this->table_items} WHERE app_class = :app_class AND (guid = :guid OR guid = :blank_guid) AND (url_file_media IS NOT NULL AND url_file_media <> '') ORDER BY guid DESC", ['app_class' => $class, 'guid' => $guid, 'blank_guid' => BLANK_GUID]);
        return $row ? $row[0] : null;
    }
    
    /**
     * Do something after save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_item
     * @param array $retval
     */
    public function hook_onAfterSaveItem($obj, $datavalues, $original_datavalues, $previous_item, $retval)
    {
        if (!empty($previous_item['guid'])) {
            $save_result = $this->saveCustomHeaderForObject($obj, $previous_item['guid'], $original_datavalues, $datavalues, $retval['id']);
        }
    }
    
    /**
     * Do something after save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_category
     * @param array $retval
     */
    public function hook_onAfterSaveCategory ($obj, $datavalues, $original_datavalues, $previous_category, $retval)
    {
        if (!empty($previous_category['guid'])) {
            $save_result = $this->saveCustomHeaderForObject($obj, $previous_category['guid'], $original_datavalues, $datavalues, $retval['id']);
        }
    }
    
    public static function getDefaultCustomHeader($obj)
    {                                    
        return self::getCustomHeaderByGUID($obj, BLANK_GUID);
    }
    
    
    public static function getCustomHeaderByGUID($obj, $guid)
    {                            
        $self = new \App\Core_MediaHeader();
        if ($obj && $guid)
        {
            $header_image = $self->getHeaderImageWithDefault(get_class($obj), $guid);
            
            if ($header_image)
            {
                $value = $header_image['url_file_media'];
                $fn = $header_image['parent_dir'].'/'.$value;            
                if (str_starts_with($value, 'https://') || str_starts_with($value, 'http://')  )                
                    $data_absolute_url = $value;
                else if (str_starts_with($value, '/'))
                    $data_absolute_url = $value;
                else
                    $data_absolute_url = $self->getDataFileURLPathWithHash('media_processed', $fn);
                return $data_absolute_url;
            } 
        }
        return '';
    }
    
    public function hook_getItemByIDWithExtraData($obj, array $item)
    {
        if ($obj && isset($item['guid']))
        {
            $header_image = $this->getHeaderImage(get_class($obj), $item['guid']);
            $item['cmh_media'] = !empty($header_image['url_file_media']) ? $header_image['url_file_media'] : '';
            $item['cmh_parent_dir'] = !empty($header_image['parent_dir']) ? $header_image['parent_dir'] : '';
        }
        
        return $item;
    }

    public function hook_getCategoryByIDWithExtraData($obj,array $category)
    {
        if ($obj && isset($category['guid']))
        {
            $header_image = $this->getHeaderImage(get_class($obj), $category['guid']);
            $category['cmh_media'] = isset($header_image['url_file_media']) ? $header_image['url_file_media'] : '';
            $category['cmh_parent_dir'] = isset($header_image['parent_dir']) ? $header_image['parent_dir'] : '';
        }
        
        return $category;
    }
    
    private function validateFilePath($path)
    {
        $error_list = [];
        $pi = mb_pathinfo($path);
        if (!in_array($pi['extension'], $this->valid_extensions))
            $error_list[] = ___('Invalid file extension');
        if (strpos('..', $path) > 0)
            $error_list[] = ___('Invalid file name. No double dots are allowed.');
        if (str_starts_with('.', $pi['filename']))
            $error_list[] = ___('Invalid file name, cannot start with dot.');
        if (str_contains($path, '://')) // prevent phar
            $error_list[] = ___('External file is not allowed.');
    }
    
    public function hook_getValidationErrorListBeforeSaveItem($app, $datavalues)
    {        
        return $this->validateSaveItemCategoryConfig($app, $datavalues, 'item');
    }
    
    public function hook_getValidationErrorListBeforeSaveCategory($app, $datavalues)
    {        
        return $this->validateSaveItemCategoryConfig($app, $datavalues, 'category');
    }
    
    public function hook_getSaveConfigValidationErrorList($app, $datavalues)
    {        
        return $this->validateSaveItemCategoryConfig($app, $datavalues, 'config');
    }
    
    public function validateSaveItemCategoryConfig($app, $datavalues, $type)
    {        
        $error_list = [];
        $var_selection = 'cmh_media_selection';
        $var_media_path = 'cmh_media_path';
        $var_media_url = 'cmh_media_url';
        $var_media_upload = 'cmh_media_upload';
        $data_valid = $app && (___c($datavalues) > 0);
        if ($type === 'config')
        {
            $var_selection = 'str_'.$var_selection;
            $var_media_path = 'str_'.$var_media_path;
            $var_media_url = 'str_'.$var_media_url;
            $var_media_upload = 'str_'.$var_media_upload;            
            
        } else 
        {
            $guid = isset($datavalues['guid']) ? $datavalues['guid'] : '';
            $data_valid &= is_valid_guid($guid);
        }
        
        
        if ($data_valid)
        {
            $selection = isset($datavalues[$var_selection]) ? $datavalues[$var_selection] : null;
            switch ($selection)
            {
                case 'path': 
                    $path = $datavalues[$var_media_path];
                    $error_list = $this->validateFilePath($path);
                    $real_fn = realpath(remove_multiple_slashes(SCHLIX_SERVER_ROOT_PATH .$path));
                    if (!file_exists($real_fn))
                        $error_list[] = sprintf( ___('File does not exist: %s'), $real_fn );
                    break;
                case 'url': 
                    $url = $datavalues[$var_media_url];                    
                    $pu = parse_url($url);
                    $path = $pu['path'];
                    $error_list = $this->validateFilePath($path);
                    // prevent phar://, etc
                    if ($pu['scheme'] != 'https' && $pu['scheme'] != 'http') 
                        $error_list[] = ___('Must start with either http or https');
                    break;
                case 'upload':
                    $uploaded_file = $_FILES[$var_media_upload];
                    if (is_uploaded_file($uploaded_file['tmp_name']))
                    {
                        $pi = mb_pathinfo($uploaded_file['name']);
                        $new_image_filename = $pi['basename'];
                        $current_year_and_month = date('Y-m');
                        $rname = $current_year_and_month.'/'. $new_image_filename;
                        $path = $this->getDataFileFullPath('media_original', $rname);

                        $error_list = $this->validateFilePath($path);

                        if (!is_valid_uploaded_image_file($uploaded_file['tmp_name'], $path))
                        {if ($pi['extension'] != 'mp4')
                            $error_list[] = ___('Invalid image').' '.$new_image_filename;
                        }
                    }
                    break;
                default: // none, clear values
                    break;
            }
        }
        return $error_list;
    }
    
        
}