/**
 * Core: Media Manager - Javascript admin controller class
 * 
 * Core - Media Manager 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

/**
 * Element class
 */
SCHLIX.CMS.DataExplorerFileManager = class extends SCHLIX.CMS.DataExplorerHierarchicalTreeList  {  
    /**
     * Constructor
     */
    constructor (el, options)
    {
        super(el, options);
    };


    /**
     * Display current breadcrumb
     */
    displayBreadcrumbPathForCurrentCategory()
    {
        if (this.__first_time_load)
        {
            var saved_category = this.getLocalStorageCacheItem('currentCategory'); // SCHLIX.LocalStorage.getItem(this.app_name + "_currentCategory"); 

            //// parseInt(SCHLIX.LocalStorage.getItem(this.app_name + "_currentCategory"));
            //console.warn('saved_category = ' + this.app_name + '_currentCategory'  + ' ' + saved_category);
            if (saved_category !== null)
            {
                this.currentCategory = saved_category;
            }
            this.__first_time_load = false;
        }
        this.displayBreadcrumbPath(this.currentCategory);
        
    }; // end func
    
    restorePreviousDataTableQueryAction()
    {
        this.currentCategory = this.getLocalStorageCacheItem('currentCategory'); 
        this.setDataTableQueryAction(this.getCustomCommand('action=getitemsbycategory&id=') + this.currentCategory);
    }
    
    /**
     * Restore the state of tree_expanded_nodes from HTML5 Local Storage
     */
    restoreExpandedTreeNodesFromCache()
    {
        
        try
        {
            var expanded_tree_nodes = this.getLocalStorageCacheItem("tree_expanded_nodes");            
            if (SCHLIX.Util.isString(expanded_tree_nodes))
            {
                expanded_tree_nodes = expanded_tree_nodes.split(',');
                if (expanded_tree_nodes.length > 0)
                {
                    for (var i = 0;i < expanded_tree_nodes.length;i++)
                    {
                        this.tree_expanded_nodes[i] = expanded_tree_nodes[i];
                    } 

                }

            }   
            this.tree_expanded_nodes = this.sortArrayUnique(this.tree_expanded_nodes);
        } 
        catch (exc)
        {
            SCHLIX.Alert.error('Error while restoring tree cache: ' + exc);
            this.setLocalStorageCacheItem("tree_expanded_nodes",'');
        }
    }    
};

SCHLIX.CMS.registerComponent('schlix-file-manager', SCHLIX.CMS.DataExplorerFileManager);

/******************************************************************/

/**
 * View Controller class
 */
SCHLIX.CMS.MediaManager = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.mediamanager");
    };


    /**
     * Datatable row format: selection check boxes
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    static formatDataTableCell_SelectItem (elCell, oRecord, oColumn, oData) {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        theID = app_name + '-select-id' + oRecord.getData("full_file_path");
        theValue = oRecord.getData("full_file_path");
        //console.log(oRecord.getData("type"));
        if (oRecord.getData("type") == 'file')
            elCell.innerHTML = '<input type="radio" class="schlix-select-item" name="' + app_name + '-radio_selection" id="' + theID + '"  value="' + theValue + '" />';
        else
            elCell.innerHTML = '';
    };
    /**
     * Datatable row format: selection check boxes
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        theID = app_name + '-select-id' + oRecord.getData("full_file_path");
        theValue = oRecord.getData("full_file_path");
        elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    };

    /**
     * Datatable row format: selection check boxes
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    static formatDataTableCell_FileSize (elCell, oRecord, oColumn, oData) {

        var size = oData;
        var result = '';
        var o_cid = oRecord.getData("cid");
        if (o_cid)
        {
            result = '';
        } else
        {
            result = format_file_size(size);
            
        }
        elCell.innerHTML = result;
    };
 

    static getFileExtension (fname)
    {
        var pos = fname.lastIndexOf(".");
        var strlen = fname.length;
        if (pos != -1 && strlen != pos + 1) {
            var ext = fname.split(".");
            var len = ext.length;
            var extension = ext[len - 1].toLowerCase();
        } else {
            extension = "No extension found";
        }
        return extension;
    }
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_Filename (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var odata_ext = oRecord.getData("extension");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = '';
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';

        var app_name = this.parentControl.app_name;
        var folder_name = oRecord.getData("cid");
        if (SCHLIX.Util.isString(folder_name))
        {
            var the_id = oRecord.getData("cid");
            var theValue = 'c' + the_id;
            var icon = "<i class =\"fas fa-folder fa-2x\"></i>";

            if (itemTitle === '')
                itemTitle = '(Untitled)';

            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=editcategory&id=' + oRecord.getData("cid");
            elCell.innerHTML = '<div style="float:left" >' + '<a  title="Click here to go into this category" class="datatable-folder dragdrop" href="#"  data-category-id="' + the_id + '" data-dragdrop-id="' + theValue + '" id="' + app_name + "-lnk-" + theValue + '">' + " " + icon + " " + itemTitle + '</a>' +
                '</div> ';
        } else
        {
            var is_image = false;
            var the_id = md5_string(oRecord.getData('full_url_path'));//  oRecord.getData("id");
            var file_type = oRecord.getData("extension");
            var theValue = 'i' + the_id;
            var file_type_icon;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            switch (file_type)
            {
                case 'bmp':
                case 'jpg':
                case 'jpeg':
                case 'gif':
                case 'png':
                    is_image = true;
                    file_type_icon = "fa-file-image-o";
                    break;
                case 'aiff':
                case 'wav':
                case 'mp3':
                    file_type_icon = "fa-file-audio-o";
                    break;
                case 'docx':
                case 'doc':
                case 'odt':
                    file_type_icon = "fa-file-word-o";
                    break;
                case 'xlsx':
                case 'odf':
                case 'xls':
                    file_type_icon = "fa-file-excel-o";
                    break;
                case 'md':
                case 'js':
                case 'rtf':
                case 'txt':
                    file_type_icon = "fa-file-text-o";
                    break;
                case 'wmv':
                case 'mpg':
                case 'mp4':
                    file_type_icon = "fa-file-video-o";
                    break;
                default:
                    file_type_icon = "fa-file-o";
                    break;
            }
            var icon = "<i class =\"fa " + file_type_icon + " fa-2x\"></i>";
            // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
            itemLink = oRecord.getData('full_url_path'); //this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            
            if (is_image)
            {
                var path = SCHLIX.Util.escapeHTML(oRecord.getData('relative_subsite_url_path'));
                icon = '<img data-file-link="' + itemLink + '" src="' + schlix_cache_path + path + '" alt="' + path + '" title="' + path + '"  />' ;
            }
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            
            elCell.innerHTML = '<a class="dragdrop filelink" href="javascript:void(0)" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" data-file-link="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>';
        }
    };

    static formatAction (elCell, oRecord, oColumn, oData)
    {
        var id = oRecord.getData("id");
        var cid = oRecord.getData("cid");
        var title = ___h(oRecord.getData("title"));
        var action_copy_url_to_clipboard = '';
        var old_name = ___h(oRecord.getData('full_url_path'));
        var parent_path = ___h(oRecord.getData('cid'));
        var filetype = 'file';
        if (cid > 0)
        {
            id = cid;
            filetype = 'folder';
        }

        var icon = '<i class="far fa-edit"></i> ';
        elCell.innerHTML = '<a class="rename" data-oldname="' + old_name + '" data-filetype="' + filetype + '" data-filenameonly="' + title + '">' + icon + ' Rename</a>';
    };
 
    onShowNewFolderDialog ()
    {
        var currentCategory = this.cms_control.currentCategory;
        
        if (/*currentCategory === 'c0' || currentCategory === 0 || */ currentCategory === null )
        {
            SCHLIX.Alert.warning('Cannot create a subfolder in this directory, please navigate to a subdirectory before creating a new one');
        } else
        {
            
            var obj = SCHLIX.CMS.getObject('schlix-cms-new-folder-dialog');
            var tgt_newfolderstartpath = SCHLIX.Dom.get('text-newfolderstartpath');
            var tgt_input_newfolderstartpath = SCHLIX.Dom.get('input-newfolderstartpath');
            
            var parent_path = (currentCategory === 'c0' || currentCategory === 0 ) ?  '/media' : currentCategory;
            tgt_input_newfolderstartpath.value = tgt_newfolderstartpath.innerHTML = parent_path;
            obj.show();
        }
    }; // end func
    onSubmitImageUploadDialog (event)
    {
        var prefix_file_size = SCHLIX.Dom.get('filelist-prefix-totalsize');
        var upload_form = SCHLIX.Dom.get('frm_upload_file');
        var btn_upload = SCHLIX.Dom.get('btn-media-upload');
        var btn_cancel = SCHLIX.Dom.get('btn-media-cancel');
        var total_file_size = parseInt(SCHLIX.Dom.get('__total_file_size').value, 10);
        var max_file_size = parseInt(SCHLIX.Dom.get('__max_file_size').value, 10);
        if (total_file_size > 0)
        {
            if (total_file_size > max_file_size)
            {
                SCHLIX.Alert.error('Total file size (' + this.formatFileSize(total_file_size) + ') is too large for this server. Max = ' + this.formatFileSize(max_file_size));
                event.preventDefault();
                event.stopPropagation();
                
                return false;
            }
            btn_upload.disabled = true;
            prefix_file_size.innerHTML = '<i class="fa fa-spinner fa-spin fa-2x fa-fw"></i>Uploading';
            btn_cancel.style.display = 'none';
        }
    };    
    
    onShowImageUploadDialog ()
    {
        
        var currentCategory = this.cms_control.currentCategory;
        if (currentCategory === 'c0' || currentCategory === 0 || currentCategory === null)
        {
            SCHLIX.Alert.warning('Please navigate to a subdirectory before trying to upload a file');
        } else
        {
            /*var btn_upload = SCHLIX.Dom.get('btn-upload-ok');
            var btn_cancel = SCHLIX.Dom.get('btn-upload-cancel');
            var prefix_file_size = SCHLIX.Dom.get('filelist-prefix-totalsize');*/
            
            var obj = SCHLIX.CMS.getObject('schlix-cms-upload-image-dialog');
            var tgt_newfolderstartpath = SCHLIX.Dom.get('text-uploadstartpath');
            
            var hdr_newfolderstartpath = SCHLIX.Dom.get('header-uploadstartpath');
            tgt_newfolderstartpath.value = hdr_newfolderstartpath.innerHTML = currentCategory;
            /*btn_upload.disabled = false;
            prefix_file_size.innerHTML = '';
            btn_cancel.style.display = 'inline-block';
            */
            obj.show();
        }
        
    }; // end func 
    

    getQueryString()
    {
        var a = window.location.search.substr(1).split('&');
        if (a == "") return {};
        var b = {};
        for (var i = 0; i < a.length; ++i)
        {
            var p=a[i].split('=', 2);
            if (p.length == 1)
                b[p[0]] = "";
            else
                b[p[0]] = decodeURIComponent(p[1].replace(/\+/g, " "));
        }
        return b;        
    }
    /**
     * Insert URL
     * @param {Event} e
     */
    insertURL (e)
    {
        
        var el = SCHLIX.Dom.get(e.target.id);
        var tgt_url = el.getAttribute('data-file-link');
        var qs = this.getQueryString();        
        if (qs['frame'] == '1')
            SCHLIX.CMS.WysiwygHelper.insertURL(tgt_url);
        else (qs['frame'] == '2')
        {
            SCHLIX.CMS.FileURLPicker.insertURL(tgt_url, qs['el']);
        }
        // Stop the event's default behavior
        
        e.preventDefault();
        // Stop the event from bubbling up the DOM tree
        e.stopPropagation();

        console.log ('Insert URL = ' + tgt_url);
        return false;

    }; // end func
    onShowRenameDialog (e)
    {
        var el = SCHLIX.Dom.get(e.target.id);
        var tgt_oldname = el.getAttribute('data-oldname');
        var tgt_filenameonly = el.getAttribute('data-filenameonly');
        var tgt_filetype = el.getAttribute('data-filetype');


        var obj = SCHLIX.CMS.getObject('schlix-cms-rename-dialog');
        var text_filetype = SCHLIX.Dom.get('text-filetype');
        text_filetype.value = tgt_filetype;


        var text_oldname = SCHLIX.Dom.get('text-oldname');
        text_oldname.value = tgt_oldname;
        var text_oldfilenameonly = SCHLIX.Dom.get('text-oldfilenameonly');
        text_oldfilenameonly.value = tgt_filenameonly;

        var text_newfilenameonly = SCHLIX.Dom.get('text-newfilenameonly');
        text_newfilenameonly.value = tgt_filenameonly;
        obj.show();
    }; // end func
    onDOMReady (event)
    {
        SCHLIX.Event.delegate('media-manager', 'click', this.onShowRenameDialog, 'a.rename', this, true);
        //SCHLIX.Event.on('filedata', 'change', this.updateFileListToUpload, this, true);
        if (typeof is_wysiwyg_mode != 'undefined')
        {
            if (is_wysiwyg_mode)
            {
                SCHLIX.Event.delegate('media-manager', 'click', this.insertURL, 'a.filelink', this, true);
                //SCHLIX.Event.delegate('media-manager', 'click', this.insertURL, 'a.filelink img', this, true);
            }
        }
        SCHLIX.Event.on('btn-media-upload','click', this.onSubmitImageUploadDialog, this, true);
    }; // end func
    // 
        
    formatFileSize(size)
    {
        var result = size;
        if (size >= 1024 && size <= 1024*1024)
        {
            result = Math.round(size / 1024.0, 2) + ' Kb';
        } 
        else if (size > 1024*1024 && size <= 1024*1024*1024)
        {
            result = Math.round(size / (1024.0 * 1024.0), 2) + ' Mb';
        }
        else if (size > 1024*1024*1024)
        {
            result = Math.round(size / (1024.0*1024.0*1024.0), 2) + ' Gb';
        }
        return result;
    };
// 

    runCommand (command, evt)
    {
        switch (command)
        {

            case 'new-folder':
                this.onShowNewFolderDialog();
                break;
            case 'form-submit-ok':
                this.cms_control.refreshControls();
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                break;
            case 'upload':
                this.onShowImageUploadDialog();
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                break;
             case "form-submit-failed":
                SCHLIX.Alert.info ('Form submit failed');
                return true;
                break;                 
            default:
                //return RESOLVE_TO_PARENT;
                return super.runCommand(command, evt);
                break;
        }

    }
}; 