/**
 * Core: Menu - Javascript admin controller class
 * 
 * Core - Menu 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
/////////////////////////////////

/**
 * class for menu block
 */
SCHLIX.CMS.DataExplorerDoubleTree = class extends SCHLIX.CMS.DataExplorerCategorizedList {  
    /**
     * Constructor
     */
    constructor (el, options)
    {
        super(el, options);
        this.field_category_id = 'cid';
        this.field_category_title = 'title';
    };


    // --------------------------------- VARIABLES ------------------------------- //
    initDataTablePaginator ()
    {
    }; // end func
    /**
     * Draw the thing
     * @param {type} x
     * @param {type} level
     * @return {String}
     */
    drawMenuBlock (x)
    {
        var tree_item = this.tree_items_array[x];
        var id = tree_item['cid'];
        var menu_item_title = tree_item['title'];
        var app_name = this.app_name;
        var checkbox_id = app_name + '-select-cid-' + id;
        var checkbox_value = 'c' + id;
        var checkbox = '<input type="checkbox" class="' + this.app_name + '-chkselections menu-item-checkbox" name="' + app_name + '-chkselections[]" id="' + checkbox_id + '"  value="' + checkbox_value + '" />';
        var status_icon_class = (status === 1) ? "check-circle" : "times-circle";

        var status_icon = "<i class=\"fa fa-" + status_icon_class + "\"></i>";
        var active_checkbox = '<a class="admin-menu-list-item status_checkbox" href="javascript:void(0)" data-menu-id="' + id + '" data-status="'+ status + '">' + status_icon + '</a>';

        var edit_category_link = 'href="javascript:void(0)" class="dlg-edit-category" data-cid="' + id + '" data-title="' + menu_item_title + '"';
        var menu_item_edit_link = '<div style="float:right"><a ' + edit_category_link + '>' + "<i class='fas fa-pencil-alt'></i> " + '</a></div>';
        //var menu_item_link = '<a href="' + site_httpbase + '/admin/app/menus/?action=editcategory&id=' + id + '">' + menu_item_title + '</a>';
        var menu_item_link = '<a  title="Edit category" class="datatable-folder dragdrop" href="javascript:void(0)"  data-category-id="' + checkbox_value + '" data-dragdrop-id="' + checkbox_value + '" id="' + app_name + "-lnk-" + checkbox_value + '">' + "<i class='far fa-folder '></i> " + menu_item_title + '</a>';

        var div = "<div class='schlix-tree-label level-block'>" + checkbox + menu_item_link + menu_item_edit_link + "</div>";
        var menu_item = "<div class='schlix-tree-item'>" + div + "</div>";
        return menu_item;
    }; // end func
    /**
     * Draw the thing
     * @param {type} x
     * @param {type} level
     * @return {String}
     */
    drawMenuItemTreeNode (x, level)
    {
        var tree_item = this.tree_items_array[x];
        var id = tree_item['id'];
        var menu_item_title = SCHLIX.Util.escapeHTML(tree_item['title']);
        
        var menu_icon = SCHLIX.Util.escapeHTML(tree_item['font_icon']);
        if (menu_icon)
            menu_item_title = ___$HTML.I('',{'class': 'fas fa-' + menu_icon }) + ' ' +menu_item_title;
        var status = tree_item['status'];
        var app_name = this.app_name;
        var checkbox_id = app_name + '-select-id-' + id;
        var checkbox_value = 'i' + id;
        var checkbox = ___$INPUT.CHECKBOX(app_name + '-chkselections[]', checkbox_value, false, { 'class' : this.app_name + '-chkselections menu-item-checkbox',  'id' :checkbox_id });

        var status_icon_class = (status === 1) ? "check-circle" : "times-circle";
        var status_icon_color = (status === 1) ? "limegreen" : "red";
        
        var status_icon = ___$HTML.I('',{'class': 'fas fa-' + status_icon_class + ' text-' + status_icon_color});
        
        var active_checkbox = ___$HTML.A(status_icon, 'javascript:void(0)', {'class': 'admin-menu-list-item status_checkbox', 'data-menu-id' : id, 'data-status': status});
        
        var preview_link = '&nbsp;&nbsp;&nbsp;' + ___$HTML.A(___$HTML.I('',{'class' : 'fas fa-eye text-white'}), tree_item['sefurl'] ,  { 'target' : '_blank', 'title' : tree_item['sefurl'], 'class' : 'admin-menu-list-item preview_link', 'data-menu-id' : id});
        
        
        var menu_item_link = ___$HTML.A(menu_item_title, tree_item['edit_link'] , {'title' : 'Click to edit this item'});
        var div = ___$HTML.DIV_start({'class' : 'schlix-tree-label level-' + level, 'id' : "menu-dragel-" + id, 'data-dragdrop-id' : "menu_" + id }) + checkbox + ' ' +
                ___$HTML.I('',{'class': 'fas fa-bars menu-pointer'}) + ' ' + menu_item_link + active_checkbox + preview_link +
                ___$HTML.DIV_end();
        var dd_div_top = ___$HTML.DIV_start({'class' : 'menu-dragdrop top', 'data-level' : level, 'id' : "menu-target-top-" + id, 'data-dragdrop-id' : "menutop_" + id }) +  ___$HTML.DIV_end() ; //
        var dd_div_bottom = ___$HTML.DIV_start({'class' : 'menu-dragdrop bottom', 'data-level' : level, 'id' : "menu-target-bottom-" + id, 'data-dragdrop-id' : "menubottom_" + id }) +  ___$HTML.DIV_end() ; //
        var dd_div_right = '';
        var menu_item = ___$HTML.DIV_start({'class' : 'schlix-tree-item'}) + dd_div_top + div + dd_div_bottom + ___$HTML.DIV_end() + dd_div_right;
        return menu_item;
    }; // end func
    /**
     * Return the treenode with item id #
     * @param {int} id
     * @return {Treenode}
     */
    getNodeByDataID (id)
    {
        if (id == 0)
        {
            return this.itemsTree.getRoot();
        }
        for (var i = 0; i < this.categoryNodes.length; i++)
        {
            if (typeof this.categoryNodes[i] == "undefined")
            {
                //alert('getNodeByDataID(' + i + ') is undefined');
            } else
            if (this.categoryNodes[i].data.id == id)
            {
                return this.categoryNodes[i];
            }
        }
        return null;
    }; // end func
    clickTreeNode (htmlobject)
    {

        var category_id = htmlobject.node.data.id;
        //var searchString = this.getAppElementByID('searchbox');
        //if (searchString) searchString.value = '';

        //this.changeDirectory(category_id);
        return false;
    }; // end func
    /**
     * Initialize the menu item tree nodes
     * @param {int} category_id
     * @param {int} level
     */
    initMenuItemTreeNodes (category_id, level)
    {
        var myobj, new_node, category_name, node_name;
        for (var i = 0; i < this.tree_items_array.length; i++)
        {
            var parent_id = this.tree_items_array[i]['parent_id'];
            if (parent_id === category_id)
            {
                var virtual_filename = (this.tree_items_array[i]['virtual_filename']) ? this.tree_items_array[i]['virtual_filename'] : '';
                var menu_title = (this.tree_items_array[i]['title']) ? this.tree_items_array[i]['title'] : '';
                var id = this.tree_items_array[i]['id'];
                var myobj = {virtual_filename: virtual_filename, label: menu_title, id: id, html: this.drawMenuItemTreeNode(i, level)};
                this.categoryNodes[i] = new SCHLIX.UI.HTMLNode(myobj, this.getNodeByDataID(category_id), true, true);
                this.initMenuItemTreeNodes(id, level + 1);
            }
        }
    }; // end func
    /**
     * Initialize the menu item tree blocks
     * @param {int} category_id
     * @param {int} level
     */
    initMenuItemBlocks ()
    {
        var myobj, new_node, category_name, node_name;
        for (var i = 0; i < this.tree_items_array.length; i++)
        {
            var virtual_filename = (this.tree_items_array[i]['virtual_filename']) ? this.tree_items_array[i]['virtual_filename'] : '';
            var menu_title = (this.tree_items_array[i]['title']) ? this.tree_items_array[i]['title'] : '';
            var id = this.tree_items_array[i]['id'];
            var myobj = {virtual_filename: virtual_filename, label: menu_title, id: id, html: this.drawMenuBlock(i)};
            this.categoryNodes[i] = new SCHLIX.UI.HTMLNode(myobj, this.itemsTree.getRoot(), true, true);
        }
    }; // end func
    
    /**
     * Init second treeview from DataSource and populates the
     * RecordSet with the results.
     *  
     * @method onDataReturnSetRows
     * @param oRequest {MIXED} Original generated request.
     * @param oResponse {Object} Response object.
     * @param oPayload {MIXED} (optional) Additional argument(s)
     */
    initItemsTreeView (oRequest, oResponse, oPayload) {

        this.tree_items_array = oResponse.results;
        // console.table(this.tree_items_array);
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-menu-items");
        if (!SCHLIX.Util.isUndefined(this.itemsTree))
            this.itemsTree.destroy();

        this.itemsTree = new SCHLIX.UI.TreeView(tree_id);
        this.categoryNodes = [];

        if (this.currentCategory == 0 || this.currentCategory == 'c0')
        {
            this.currentCategory = 0;
            this.initMenuItemBlocks();
            this.initMenuItemTreeNodes(0, 0);
        }
        else
            this.initMenuItemTreeNodes(0, 0);
        this.itemsTree.subscribe("clickEvent", this.clickTreeNode, this, true);  // scope correction with this, true - Feb  21, 2009
        this.itemsTree.draw();
        this.initResizer();
        this.initDragDropForItemsTreeView();
    }; // end func
    
    initDragDropForItemsTreeView (node)
    {
        if (this.currentCategory > -1)
        {
            if (SCHLIX.Util.isUndefined(node))
                node = this.itemsTree.getRoot();
            if (node.hasChildren) {
                var nodes = node.children;

                for (var i = 0; i < nodes.length; i++) {
                    var the_node = nodes[i];
                    var node_el = the_node.contentElId;
                    var target_top = SCHLIX.Dom.get("{#" + node_el + " .menu-dragdrop.top}");
                    var target_right = SCHLIX.Dom.get("{#" + node_el + " .menu-dragdrop.right}");
                    var target_bottom = SCHLIX.Dom.get("{#" + node_el + " .menu-dragdrop.bottom}");
                    var drag_el = SCHLIX.Dom.get("{#" + node_el + " .schlix-tree-label}");

                    var dd_target_main = new SCHLIX.CMS.DragDrop(drag_el[0].id, this, "", {node_cid: the_node.data.cid});
                    if (target_top && target_top[0])
                        var dd_target_top = new SCHLIX.Core.DDTarget(target_top[0].id);
                    if (target_bottom)
                        var dd_target_bottom = new SCHLIX.Core.DDTarget(target_bottom[0].id);
                    //var dd_target_right = new SCHLIX.Core.DDTarget(target_right[0].id);

                    if (the_node.hasChildren)
                        this.initDragDropForItemsTreeView(the_node);

                }
            }
        }
    }; // end func
    queryItemsTreeView ()
    {
        this.currentCategory = isNaN(this.currentCategory) ? 0 : this.currentCategory;
        this.setBusy(false);
        this.setLocalStorageCacheItem("query_action", "action=getitemsbycategory&id=" + this.currentCategory);
        this.datasource_datatable.sendRequest("action=getitemsbycategory&id=" + this.currentCategory + "&sortby=id&sortdirection=asc&start=0&end=1000",
                {
                    success: this.initItemsTreeView,
                    scope: this
                }
        );

    }; // end func
    getItemsListing ()
    {
        this.queryItemsTreeView();
    }; // end func
    initDataTable ()
    {
        var saved_category = parseInt(this.getLocalStorageCacheItem("currentCategory"));
        if (saved_category > 0)
        {
            this.currentCategory = saved_category;
        }
        this.queryItemsTreeView();
        var breadcrumb = this.getChildElementNameByDynamicDomId('breadcrumb');
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-menu-items");

        //$('#' + tree_id).on('change', '.' + this.app_name + '-chkselections', $.proxy(this.onToggleSelectItem, this));

        var tv = SCHLIX.Dom.get(tree_id);
        var bc = SCHLIX.Dom.get(breadcrumb);
        SCHLIX.Event.delegate(tv, 'change', this.onToggleSelectItem, '.' + this.app_name + '-chkselections', this, true);
        SCHLIX.Event.delegate(bc, 'click', this.onBreadCrumbClick, 'a', this, true);


    }; // end func
    initSearchForm ()
    {
        // Disable
    }; // end func
    initDataTableEvent ()
    {
    }; // end func
    onTreeClick (oArgs)
    {
        var category_id = oArgs.node.data["cid"];
        this.changeCurrentCategory(category_id);
    };
};


/**
 * Class for viewing arbitrary app with cats/items
 */
SCHLIX.CMS.SkeletonExplorer = class extends SCHLIX.CMS.DataExplorerHierarchicalTreeList
{
    /**
     * Constructor
     */
    constructor (el, options)
    {
        //alert(options);
        super(el, options);
        this.field_category_id = 'cid';
        this.field_category_title = 'title';
        this.__first_time_load = true;
        this.__dtt = options.datatype;
    }; 
    

    isTreeNodeDynamic()
    {
        var is_dyn = false;
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-tree"); 
        var elem_tree = SCHLIX.Dom.get(tree_id);
        if (elem_tree)
        {
            var before = elem_tree.getAttribute('data-dynamic');
            is_dyn =  (this.__dtt == "basicnestedcategory" || this.__dtt == "basicmultiplecategory");
            var dyn = is_dyn ? "true" : "false";

            elem_tree.setAttribute('data-dynamic', dyn);
            var proof = SCHLIX.Dom.get(tree_id).getAttribute('data-dynamic');            
            return is_dyn;
        }
        return false;

    }; // end func
     
        
    // --------------------------------- PROCEDURES -------------------------- //
    /**
     * Initialize the layout - looks like it's not needed 
     */
    initAllControls ()
    {
        super.initAllControls();
       // this.initDataSourceForTreeView();
        // 3. Init Resizer
        //this.initTreeView();
    }; // end func
    /**
     * Initialize the layout
     */
    initVariables ()
    {
        //this.initDataSourceForTreeView();
        // 3. Init Resizer
        //this.initTreeView();
        super.initVariables();
        this.setDataModelURL(this.options['model']);
    }; // end func
    /**
     * Returns the query initial uqery string required for loading the treeview. 
     * Loaded expanded folder states from the HTML5 Local Storage and appended it to the query
     * @returns {String}
     */
    getInitialTreeViewQueryString ()
    {
        var initial_query = "parent_id=0";
        //this.restoreExpandedTreeNodesFromCache();
        if (this.tree_expanded_nodes.length > 0)
        {
            initial_query += "&expandnodes=" + this.tree_expanded_nodes.join(',');
        }
        return initial_query;
    }; // end func
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    formatDataTableCell_DefaultTitleColumn (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = '';
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        else if (itemTitle === '')
            itemTitle = '(Untitled)';

        var app_name = this.parentControl.app_name;
        var is_category = oRecord.getData("cid") > 0;

        var the_id = is_category ? oRecord.getData("cid") : oRecord.getData("id");
        var theValue = is_category ? 'c' + the_id : 'i' + the_id;
        var icon = is_category ? "<i class =\"fas fa-folder fa-2x\"></i>" : "<i class =\"far fa-file-alt fa-2x\"></i>";
        var existing_menuitem = document.getElementById('existing_menuitem');
        var existing_menuitem_id = (existing_menuitem !== undefined && existing_menuitem !== null) ? existing_menuitem.value : 0;
        var is_checked = (existing_menuitem_id === theValue) ? ' checked ' : '';
        var the_input ='<input type="radio" class="' + app_name + '-radio" name="menuitem" id="' + the_id + '"  value="' + theValue + '" required  ' + is_checked + '/>'  ;

        var preview_link = oRecord.getData('preview_link');
        var preview_icon = '<i class="fa fa-eye"></i>';
        var href_preview_link = (preview_link === undefined) ? '' : '<div style="float:right;margin-left:4em"><a title="Preview" target="_blank" href="' + preview_link + '">' + preview_icon + '</a></div>';

        elCell.innerHTML = '<div style="float:left" class="radio"><label> ' + the_input + icon + ' ' + itemTitle + '</label></div>' + href_preview_link;


    }

};



///////////////////////////////////////

/////////////////////////////////
// ******************************************************************************************************************************************** 

    var menu_selected_app_name;
    var global_currentapp_datatype;
    var reset_selected_action;
    var global_field_selected_item_title;
    var global_field_selected_category_title;

    SCHLIX.CMS.MenusAdmin = class extends SCHLIX.CMS.BaseController
    {
        constructor ()
        {
            super('core.menu');
            this.__first_time_load =  true;
            this.control_explorer = null;
            this.registeredName = "Schlix.CMS.MenusAdmin";
            
        };
        /**
         * Receive Menu Information. 
         * @param {type} o
         * @return {undefined}
         */
        displayMenuInformationFromSelectedApp (o)
        {
            var str = '';
            this.setMenuAction('');
            var container = SCHLIX.Dom.get('menu_application_methods_container');
            switch (this.selected_app_name)
            {
                case 'home':
                case 'menu_placeholder':
                case 'menu_divider':
                    str = 'Click Save';
                    container.innerHTML = '';
                    break;
                case 'external_link':
                    var existing_customurl = '';
                    if (document.getElementById('existing_customurl'))
                        existing_customurl = document.getElementById('existing_customurl').value;
                    str = '<label for="customurl">Please enter the URL</label><input NAME="customurl" type="text" class="form-control" value="' + existing_customurl + '"  required /><BR />';
                    container.innerHTML = '<h4><i class="fa fa-th-list"></i> Please select an action </h4>' + str;
                    break;
                default:
                    var existing_menuaction = document.getElementById('existing_menuaction').value;
                    var response = ajax_parse(o.responseText);

                    var data_type = response['data_type'];
                    var public_methods = response['public_methods'];
                    var the_app_name = response['app_name'];
                    global_currentapp_datatype = data_type;
                    this.current_app_data_type = data_type;
                    if (response['field_category_title'])
                        this.field_selected_category_title = response['field_category_title'];
                    else
                        this.field_selected_category_title = 'title';
                    if (response['field_item_title'])
                        this.field_selected_item_title = response['field_item_title'];
                    else
                        this.field_selected_item_title = 'title';
                    
                    global_field_selected_item_title = this.field_selected_item_title;
                    global_field_selected_category_title = this.field_selected_category_title;

                    menu_selected_app_name = the_app_name;
                    var str = '';
                    for (var i = 0; i < public_methods.length; i++)
                    {
                        var action = public_methods[i]['action'];
                        var desc = public_methods[i]['description'];
                        var checked_str = (existing_menuaction === action && this.__first_time_load) ? ' checked ' : '';
                        str = str +  '<div class="radio">' +  '<label id="labelradioaction' + i + '" for="radioaction' + i + '"><input name="menuaction" type="radio" id="radioaction' + i + '" value="' + action + '" class="schlix-menu-app-action"' + checked_str + ' required />' + desc + '</label>' +'</div>'+ "\n";
                    }
                    container.innerHTML = '<h4><i class="fa fa-th-list"></i> Please select an action </h4>' + str;
                    
            } // end switch
            var existing_application = document.getElementById('existing_application').value;
            //	if (!this.__first_time_load) document.getElementById('existing_application').value = '';
            if (existing_menuaction !== "" && existing_application !== 'external_link' && existing_application !== 'home')
            {
                if (this.__first_time_load)
                {
                    this.setMenuAction(existing_menuaction);
                    this.__first_time_load = false;
                } 
                
                /* var existing_menuitem = document.getElementById('existing_menuitem').value;
                 var existing_menu_parent_category = document.getElementById('existing_menu_parent_category');
                 //		alert(existing_menu_parent_category.toSource());
                 if (existing_menu_parent_category)
                 {
                 if (existing_menu_parent_category.value !== "")
                 {
                 this.currentCategory = existing_menu_parent_category.value;
                 // Dec 6, 2011 - 
                 if (this.selected_app_name === 'home' && this.selected_app_name === 'external_link')
                 this.changeAppViewerParentCategoryID(existing_menu_parent_category);
                 
                 }
                 }*/

            }
        }; // end func
        changeAppViewerParentCategoryID (id)
        {

        }; // end func
        setMenuAction (action)
        {
            if (action === 'standard_browse')
            {

                document.getElementById('menu_editor_layout').style.display = 'block';
                var data_explorer_list_els = SCHLIX.Dom.get("{schlix-data-explorer-skeleton}");
                if (this.control_explorer !== null)
                    this.control_explorer.destroy();
                this.control_explorer = new SCHLIX.CMS.SkeletonExplorer(data_explorer_list_els[0],
                        {'model': "/admin/app/" + this.selected_app_name,
                            'datatype': this.current_app_data_type});
                ////////////////////////////////////////
                var existing_menu_parent_category = document.getElementById('existingmenu_parent_category');

                if (existing_menu_parent_category)
                {
                    this.control_explorer.currentCategory = existing_menu_parent_category.value;

                    if (existing_menu_parent_category.value !== "")
                    {
                        this.currentCategory = existing_menu_parent_category.value;
                        if (this.selected_app_name === 'home' && this.selected_app_name === 'external_link')
                            this.control_explorer.getItemsListing(existing_menu_parent_category.value);

                    }
                }
                

                ////////////////////////////////////////
            } else
            {
                // if you don't destroy the control explorer properly, during submit there will be an error
                // if the user changes the selection
                if (this.control_explorer !== null)
                    this.control_explorer.destroy();
                document.getElementById('menu_editor_layout').style.display = 'none';
            }
        }; // end func
        /**
         * This function is called after the user click the selected app
         * @param {event} event
         * @return {undefined}
         */
        getMenuInformationFromSelectedApp (event)
        {
            //	container.innerHTML = 'test';
            //console.log(event.target);
            //console.log(args);
            var el_id = event.target.id;
            return this.getMenuInformationFromDomById(el_id);
        }; // end func
        /**
         * Get the menu information by Dom ID
         * @param {String} el_id
         * @return {undefined}
         */
        getMenuInformationFromDomById (el_id)
        {
            var app_target = SCHLIX.Dom.get(el_id);
            var selected_app_name = app_target.getAttribute('data-app-target');

            this.selected_app_name = selected_app_name;
            menu_selected_app_name = selected_app_name;
            // this.__first_time_load = first_time;
            var callback = {success: this.displayMenuInformationFromSelectedApp, failure: this.handleFailure, scope: this};
            var sUrl = site_httpbase + "/admin/app/" + selected_app_name + "?action=getmenuinfo";
            var request = SCHLIX.Ajax.GET( sUrl, callback);
        }; // end func
        getMoreDetailedMenuAction (event, matchedEl, container)
        {
            this.setMenuAction(event.target.value);
        }; // end func
        /**
         * Notify that the item has been changed
         */
        notifyItemSelectionChanged ()
        {
            document.getElementById('user_changed_item_or_category').value = 1;
        }; // end func
        /**
         * Run the controller
         */
        Run ()
        {
            super.Run();
            var available_apps = SCHLIX.Dom.get('{.schlix-menu-item-choice}');
            SCHLIX.Event.on(available_apps, 'click', this.getMenuInformationFromSelectedApp, this, true);

            //var available_app_action = SCHLIX.Dom.get('{.schlix-menu-app-action}');
            SCHLIX.Event.delegate("menu_application_methods_container", 'click', this.getMoreDetailedMenuAction, "input", this, true);

            if (available_apps)
            {
                global_currentapp_datatype = '';
                var selected_app_radio_button = SCHLIX.Util.getRadioButtonCheckedValue('application');  // getRadioCheckedValue('application');
                var the_id = "schlix-app-choice-" + selected_app_radio_button;
                //var existing_menuaction = document.getElementById('existing_menuaction').value;
                if (selected_app_radio_button != "")
                    this.getMenuInformationFromDomById(the_id, true);
            }
        }; // end func
        
        onUpdateMenuStatus(o)
        {
            var response = ajax_parse(o.responseText);
            if (response === 'OK')
            {
                SCHLIX.Alert.info('Menu status has been changed');
                this.cms_control.refreshControls();            
            }
            else
                alert(response);
            
        };
        
        onStatusCheckboxClick(event)
        {
            var menu_item_node = event.target.parentNode;
            if (menu_item_node)
            {
                var menu_id = menu_item_node.getAttribute('data-menu-id');
                var menu_status = menu_item_node.getAttribute('data-status');
                console.log(menu_status);
                var new_value = (parseInt(menu_status,10) === 1) ? 0 : 1;
                var postData = "_csrftoken=" + _csrftoken + '&id=i' +menu_id + '&field=status&value=' + new_value;
                var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=updatefield",
                    {success: this.onUpdateMenuStatus, failure: this.handleFailure, scope: this}, postData
                    );

            }
        }
        
        onShowNewCategoryDialog ()
        {

            var obj = SCHLIX.CMS.getObject('schlix-cms-category-dialog');
            var tgt_cid = SCHLIX.Dom.get('dlg-category-id');
            var tgt_title = SCHLIX.Dom.get('dlg-category-title');
            SCHLIX.Dom.get('label-new-category-title').style.display = '';
            SCHLIX.Dom.get('label-edit-category-title').style.display = 'none';


            tgt_cid.value = 'new';
            tgt_title.value = '';
            obj.show();
        }; // end func
        
        onShowEditCategoryDialog (event)
        {
            var el = SCHLIX.Dom.get(event.target.parentElement.id);
            var category_id = el.getAttribute('data-cid'); //  $(target).attr("data-category-id");
            var title = el.getAttribute('data-title'); //  $(target).attr("data-category-id");
            var obj = SCHLIX.CMS.getObject('schlix-cms-category-dialog');
            var tgt_cid = SCHLIX.Dom.get('dlg-category-id');
            var tgt_title = SCHLIX.Dom.get('dlg-category-title');
            
            var span_cid = SCHLIX.Dom.get('label-edit-category-id');
            span_cid.innerHTML = '#' + category_id;
            
            SCHLIX.Dom.get('label-edit-category-title').style.display = '';
            SCHLIX.Dom.get('label-new-category-title').style.display = 'none';

            tgt_cid.value = category_id;
            tgt_title.value = title;
            obj.show();
        }; // end func
        /**
         * 
         * @param {String} command
         * @return {true/false/RESOLVE_TO_PARENT}
         */
        runCommand (command, evt)
        {
            switch (command)
            {
                case 'new-item':
                    this.redirectToCMSCommand("newitem");
                    return true;
                    break;
                case 'new-category':
                    this.onShowNewCategoryDialog();
                    return true;
                    break;
                case 'config':
                    this.redirectToCMSCommand("editconfig");
                    return true;
                    break;
                case 'form-submit-ok':
                case 'refresh':
                    this.cms_control.refreshControls();
                    return true;
                    break;
                default:
                    return super.runCommand(command, evt);
                    //return RESOLVE_TO_PARENT;
            }
        }; // end func
        /**
         * Automatically called when the DOM is ready
         * @param {event} event
         */
        onDOMReady (event)
        {
            SCHLIX.Event.delegate('schlix-core-menu-admin', 'click', this.onShowEditCategoryDialog, 'a.dlg-edit-category', this, true);
            SCHLIX.Event.delegate('schlix-core-menu-admin', 'click', this.onStatusCheckboxClick, 'a.status_checkbox', this, true);
            
        }

    };
    
     /**********************************************************/


    SCHLIX.CMS.SkeletonExplorerController = class extends SCHLIX.CMS.BaseController
    {
        constructor()
        {
            super('menus');
            this.__first_time_load = true;
            this.registeredName = "Schlix.CMS.MenusAdmin";
            //  alert("Schlix.AdminController called");
        };

        /**
         * 
         * @param {String} command
         * @return {true/false/RESOLVE_TO_PARENT}
         */
        runCommand (command, evt)
        {
            switch (command)
            {
                case 'new-item':
                    this.redirectToCMSCommand("newitem");
                    return true;
                    break;
                default:
                    return super.runCommand(command, evt);
            }
        };
    };

SCHLIX.CMS.registerComponent('schlix-data-explorer-doubletree', SCHLIX.CMS.DataExplorerDoubleTree);
