<?php
/**
 * Gallery - Edit Category Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php

global $CurrentUser;

if ($id == 'new') {
    $category['permission_read'] = serialize('everyone');
    $category['items_per_page'] = 10;
    $header_title = ___('New Category');
}
else {
    $preview_link = $this->app->createFriendlyURL("action=viewcategory&cid={$id}");
    $header_title = ___('Edit Category').' #'.$id;
}

    $image_sizes = $this->app->getImageSizeNames();
    $default_sizes = $this->app->getDefaultSizes();
    
?>
<!-- {top_menu} -->
<x-ui:schlix-category-editor  data-type-desc="<?= ___('album') ?>" data-schlix-controller="SCHLIX.CMS.GalleryAdminController" >    
        
        <x-ui:schlix-editor-form id="form-edit-category" method="post" admin-action="savecategory">
            
            <x-ui:csrf id="_csrftoken" />
            
            <x-ui:hidden id="cid" name="cid" data-field="cid" />
            <x-ui:hidden id="parent_id" name="parent_id"  data-field="parent_id" />
            <x-ui:hidden id="guid" data-field="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     <x-ui:schlix-document-title id="title" maxlength="191"  required="required"  data-field="title" label="<?= ___('Category Title') ?>" table-type="category" />
                    <!-- Virtual Filename -->
                    <x-ui:schlix-document-virtual-filename id="virtual_filename" full-url="1"  data-field="virtual_filename" name="virtual_filename" />
                    
                    <x-ui:checkbox id="non_public" name="non_public" data-field="non_public" value="1" label="<?= ___('This gallery category is not visible to the public regardless of its permission (e.g. for slideshow only)') ?>" />
                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="far fa-file-alt" label="<?= ___('Content') ?>"> 
                    <x-ui:wysiwyg id="summary" name="summary" data-field="summary" label="<?= ___('Summary') ?>" />
                    <x-ui:clearboth />
                    <x-ui:wysiwyg id="description" name="description" data-field="description" label="<?= ___('Description') ?>" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_meta" fonticon="fa fa-hashtag" label="<?= ___('Meta') ?>">    
                    <x-ui:textbox id="meta_description" name="meta_description"  data-field="meta_description" label="<?= ___('Meta Description') ?>" />
                    <x-ui:textbox id="meta_key" name="meta_key" data-field="meta_key" label="<?= ___('Meta Keywords') ?>" />
                    <x-ui:tagbox id="tags" name="tags" data-field="tags" label="<?= ___('Tags') ?>" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_size" fonticon="fas fa-compress-arrows-alt" label="<?= ___('Size') ?>">    
                    <p><?= ___('Images in this gallery category will be resized to the following specifications when they are uploaded for the first time') ?></p>
                    <!-- size -->
                    <x-ui:row>
                        <?php foreach ($image_sizes as $size): ?>
                        <?php $ds = $default_sizes[$size]; ?>
                            <x-ui:column sm="6" >
                                         <fieldset  class="form-inline"><legend><?= ucwords($size) . ' ' . ___('Image Dimension (pixels)') ?></legend>
                                        <x-ui:input-group>
                                            <x-ui:input-group-addon><?= ___('Width') ?></x-ui:input-group-addon>                                        
                                            <x-ui:textbox type="number"  min="<?= (int) ($ds['width'] / 10) ?>" max="<?= $ds['width'] * 5 ?>" name="<?= $size ?>_width"   data-field="<?= $size ?>_width" default-value="<?= $this->app->getConfig("int_{$size}_width", $ds['width']) ?>" required="required" placeholder="<?= ___('Width') ?>"/>                            
                                        </x-ui:input-group>
                                        <x-ui:input-group>
                                            <x-ui:input-group-addon><?= ___('Height') ?></x-ui:input-group-addon>
                                            <x-ui:textbox type="number"  min="<?= (int) ($ds['width'] / 10) ?>" max="<?= $ds['width'] * 5 ?>"  name="<?= $size ?>_height"  data-field="<?= $size ?>_height" default-value="<?= $this->app->getConfig("int_{$size}_height", $ds['height']) ?>" required="required" placeholder="<?= ___('Height') ?>" />
                                        </x-ui:input-group>
                                        <?= ___('pixels') ?>.   
                                         </fieldset>

                                    <x-ui:textbox type="number"  min="10" max="100" label="<?= ___('Quality') ?>"  name='<?= $size ?>_quality' data-field='<?= $size ?>_quality'  required="required" default-value="<?= $this->app->getConfig("{$size}_quality", $ds['quality']) ?>"  />                                    
                                    <!-- end margin -->
                                    <hr />
                            </x-ui:column>
                        <?php endforeach ?>
                    </x-ui:row>
                    
                    <!-- end size -->
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    <x-ui:schlix-datetime-picker id="date_available" name="date_available" data-field="date_available" label="<?= ___('Available on') ?>" />
                    <x-ui:schlix-datetime-picker id="date_expiry" name="date_expiry" data-field="date_expiry" label="<?= ___('Expiry') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_options" fonticon="fa fa-sliders-h" label="<?= ___('Options') ?>">
                    <x-ui:textbox type="number" min="1" max="10000" size="5"  id="items_per_page" name="items_per_page"  data-field="items_per_page" label="<?= ___('Maximum number of items to be displayed per page') ?>" class="schlix-input-auto-width"/>
                    <x-ui:schlix-editor-category-meta-options name="options" data-field="options" max-item-per-column="1" column="3" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditCategoryTab', $this, $category) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-category-editor >