<?php
/**
 * Gallery - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php
global $CurrentUser;
if ($id == 'new') {
    $item['permission_read'] = serialize('everyone');
    $header_title = ___('New Item');
} else {
    $preview_link = $this->app->createFriendlyURL("action=viewitem&id={$id}");
    $header_title = ___('Edit Item').' #'.$id;
}

$parent_category_text = '';
$field_category_id = $this->app->getFieldCategoryID();

$parent_category_text = $this->getItemParentURLPathPreviewLink($item); 
?>
<!-- {top_menu} -->
<x-ui:schlix-item-editor data-type-desc="<?= ___('image') ?>" data-schlix-controller="SCHLIX.CMS.GalleryAdminController">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:hidden id="category_id" name="category_id" data-field="category_id" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     <x-ui:schlix-document-title id="title" maxlength="191"  required="required"  data-field="title" table-type="item" />
                    <!-- Virtual Filename -->
                    <x-ui:schlix-document-virtual-filename id="virtual_filename" full-url="1"  data-field="virtual_filename" name="virtual_filename" />
                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="far fa-file-alt" label="<?= ___('Content') ?>">                     
                    <h5><?= ___('Image') ?></h5>
                    <?php 
                        $preview_width = (int) $this->app->getConfig("int_medium_width", $ds['width']);
                        $preview_height = (int) $this->app->getConfig("int_medium_height", $ds['height']);
                    ?>
                     <x-ui:schlix-multi-source-media-uploader data-field="url_media_file" name="image_file" id="image_file" data-dir-key="image_medium" accept="image/png, image/jpeg, image/gif" data-disable-option-existing-file="true" data-disable-option-none="true" data-allow-url-variable-dimension="true" data-preview-width="<?= $preview_width ?>" data-preview-height="<?= $preview_height ?>" />
                     <?php /* old uploader only <x-ui:schlix-document-image-uploader label="<?= ___("Select a new image") ?>" fonticon="far fa-image" name="image_file" id="image_file" data-field="url_media_file" data-dir-key="image_medium" accept="image/png, image/jpeg, image/gif" />*/ ?>
                     <p><?= sprintf(___('(Optional) You can specify the dimension of the image as %s and %s as variables in the URL. For example'),'<strong>{$width}</strong>','<strong>{$height}</strong>') ?>:</p>                     
                     <ul>
                         <li>https://via.placeholder.com/{$width}x{$height}</li>
                         <li>https://placeimg.com/{$width}/{$height}/arch</li>
                         <li>https://picsum.photos/{$width}/{$height}</li>
                     </ul>
                    <x-ui:clearboth />
                    <x-ui:hr />
                    
                    <x-ui:wysiwyg id="summary" name="summary" data-field="summary" label="<?= ___('Summary') ?>" />
                    <x-ui:clearboth />
                    <x-ui:wysiwyg id="description" name="description" data-field="description" label="<?= ___('Description') ?>" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_meta" fonticon="fa fa-hashtag" label="<?= ___('Meta') ?>">    
                    <x-ui:row>
                        <x-ui:column md="4">
                            <x-ui:textbox id="meta_description" name="meta_description"  data-field="meta_description" label="<?= ___('Meta Description') ?>" />
                            <x-ui:textbox id="meta_key" name="meta_key" data-field="meta_key" label="<?= ___('Meta Keywords') ?>" />
                            <x-ui:tagbox id="tags" name="tags" data-field="tags" label="<?= ___('Tags') ?>" />
                            
                        </x-ui:column>
                        <x-ui:column md="8">
                                <?php if (is_array($exif_data)): ?>
                                    <table class="table table-bordered table-striped" id="exif_data">
                                    <?php foreach ($exif_data as $key => $value): ?>
                                        <tr>
                                            <td><?= $key ?></td>
                                            <td>
                                                <?php if (is_array($value)): ?>
                                                <!-- inner array -->
                                                    <table class="table table-bordered table-striped" id="exif_data">
                                                        <?php foreach ($value as $value_key => $value_value): ?>
                                                        <tr>
                                                            <td><?= $value_key ?></td>
                                                            <td><?= $value_value ?></td>
                                                        </tr>
                                                        <?php endforeach; ?>
                                                    </table>
                                                <!-- end inner array -->
                                                <?php else: ?>
                                                    <?= $value ?>
                                                <?php endif ?>
                                            </td>
                                        </tr>
                                    <?php endforeach ?>
                                    </table>
                                <?php else: ?>
                                    <?= ___('No EXIF data found') ?>
                                <?php endif ?>
                        </x-ui:column>
                        
                    </x-ui:row>
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    <x-ui:schlix-datetime-picker id="date_available" name="date_available" data-field="date_available" label="<?= ___('Available on') ?>" />
                    <x-ui:schlix-datetime-picker id="date_expiry" name="date_expiry" data-field="date_expiry" label="<?= ___('Expiry') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_options" fonticon="fa fa-sliders-h" label="<?= ___('Options') ?>">
                    <x-ui:schlix-editor-item-meta-options name="options" data-field="options" max-item-per-column="1" column="3" />
                </x-ui:schlix-tab>
                <!-- hooks -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>                
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor>