/**
 * Gallery - Javascript admin controller class
 * 
 * Gallery 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.GalleryAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("gallery");
    };
 
    /**
     * Datatable row format: item title
     * @static
     * @param {object} elCell
     * @param {object} oRecord
     * @param {object} oColumn
     * @param {object} oData
     * @param {object} oDataTable
     * @returns {void}
     */
    static formatDataTableCell_TitleWithImage (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var odata_ext = oRecord.getData("extension");
        var file_exists = oRecord.getData("file_exists");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';

        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            var icon = (file_exists == 'true' || file_exists == true) ?  '<img src="' + oRecord.getData('url_image_small') + '" /><br />' : '<i class="far fa-newspaper fa-2x"></i> ';

            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class =  'dragdrop';
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            
            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>';

        }
    };
    
    static formatGallery (elCell, r, datatable) 
    {
        return SCHLIX.CMS.__default_formatGallery(elCell, r, datatable, 'title', 'file_exists', 'url_image_small'); 
    };
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                if (oRecord.getData("cid") > 0)
                {
                    theID = app_name + '-select-cid' + oRecord.getData("cid");
                    theValue = 'c' + oRecord.getData("cid");
                }
                else
                {
                    theID = app_name + '-select-id' + oRecord.getData("id");
                    theValue = 'i' + oRecord.getData("id");
                }

                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    }; 
    
    onShowImageUploadDialog ()
    {
        
        var currentCategory = this.cms_control.currentCategory;
        console.log(currentCategory);
        if (currentCategory === 'c0' || currentCategory === 0 || isNaN(currentCategory))
        {
            SCHLIX.Alert.warning('Please navigate to a category before trying to upload a file');
        } else
        {
            
        var obj = SCHLIX.CMS.getObject('schlix-cms-upload-image-dialog');
            obj.show();
        }
        
    }; // end func
    
    onImageThumbnailOK(o)
    {
        var response = ajax_parse(o.responseText);
        this.setBusy(false);
        this.loopCreateThumbnail();
    }; // end func
    
    loopCreateThumbnail()
    {
        var notification = SCHLIX.Dom.get('imagegallery-thumbs-notification');
        
        if (this.task_position < this.recreate_thumbnail_tasks.length)
        {
            var abs_task_pos = this.task_position + 1;
            var percentage = Math.round( abs_task_pos / this.recreate_thumbnail_tasks.length * 100.0, 2);
            var item = this.recreate_thumbnail_tasks[this.task_position];
            notification.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ' + 'Recreating thumbnails for item ID#' + item['id'] + ' ' + item['path'] + ' ~ ' + percentage + '%' + ' (' + abs_task_pos + ' of ' + this.recreate_thumbnail_tasks.length + ' images)';            
            notification.className = 'alert alert-info';
            notification.style.margin = '0';
            notification.style.display = '';
            this.setBusy(true);
            var postData = "_csrftoken=" + _csrftoken + '&id=' + item['id'];

            var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=recreatethumbnail",
                    {success: this.onImageThumbnailOK, failure: this.handleFailure, scope: this}, postData);
            this.task_position++;
        } else
        {
            notification.innerHTML = '';
            notification.style.display = 'none';
            this.setBusy(false);
            this.cms_control.refreshControls();
            
            //console.log('Completed image thumbnail creation from new images');
        }
    }
    
    
    
    onDatabaseRefreshed (o)
    {
        var response = ajax_parse(o.responseText);
        if (response.status === 'OK')
        {
            this.setBusy(false);
            if (response.data.length == 0)
            {
                SCHLIX.Alert.info('No new files have been manually uploaded files to this site\'s /data/private/gallery folder');
                this.cms_control.refreshControls();
            } else
            {
                SCHLIX.Alert.info('Checking for images to be regenerated... please wait');
                
                this.task_position = 0;
                this.recreate_thumbnail_tasks = response.data;
                this.loopCreateThumbnail();
            }
            
        }
        else
            SCHLIX.Alert.error(response);
        
    };
    
    
    refreshDatabase(val)
    {
        var postData = "_csrftoken=" + _csrftoken + '&refresh=' + val;
        this.setBusy(true);
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=refreshdb",
                {success: this.onDatabaseRefreshed, failure: this.handleFailure, scope: this}, postData);        
    };    
    
    
    regenerateImages()
    {
        if (confirm('WARNING - this is a long running process that could take up to hours! Are you sure you want to regenerate all images?'))
        {
            this.refreshDatabase('force');
        } else 
        {
            SCHLIX.Alert.info('Image regeneration has been cancelled.');
        } 
    }
    
    ajxhExtraImagesRegenerated(o)
    {
        var resp = ajaxParse(o.responseText);
        console.log(resp);
        this.setBusy(false);
        if (resp.status == 1)
        {
            SCHLIX.Alert.info('Images have been regenerated');
            this.cms_control.refreshControls();
        } else 
        {
            SCHLIX.Alert.error('Could not regenerate image(s)');
        }
        
    };
    
    
    runCommand (command, evt)
    {
        var open_in_new_window = is_rightclick_event(evt);
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem",open_in_new_window);
                return true;
                break;
            case 'upload-multiple':
                this.onShowImageUploadDialog();
                break;
                
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;                                                
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            case 'regenerate-images':
                this.regenerateImages();                
                return true;
                break;
            
            case 'form-submit-ok':
            case 'refreshdb':
                this.refreshDatabase('normal');
                return true;
                break;
                
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};