<?php
/**
 * Image Gallery - Main page view template. Lists both categories and items with parent_id = 0 and category_id = 0 
 * 
 * Image Gallery
 * 
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die(); ?>
<?php $category_link = $this->createFriendlyURL("action=viewcategory&cid={$category['cid']}"); ?>
<?php if ($items): ?>
<ul class="imagegallery-folder">
    <?php foreach ($items as $item): ?>
        <li><a href="<?= $category_link ?>" title="<?= ___h($item['title']) ?>"><img src="<?= $this->getGalleryImage('image_small', $item['url_media_file'], $item['category_id'])?>" /></a></li>
    <?php endforeach; ?>
</ul><!--pics -->
<?php else: ?>
<a href="<?= $category_link ?>" title="<?= ___h($category['title']) ?>">
    <i class="fas fa-folder fa-10x"></i>
</a>
<?php endif ?>
<h2 class="text-center category title"><a href="<?= $category_link ?>"><?= $category['title'] ?></a></h2>
