<?php
/**
 * Plugin for compliance with GDPR - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package personaldatarequest
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<!-- {top_menu} -->
<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.GDPRAdminController" type="config">

        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                    <!--content -->
                        
                        <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                        <schlix-config:app_description   />
                        <schlix-config:checkbox config-key="bool_disable_app" label="<?=  ___('Disable application') ?>" />
                        <hr />
                        <schlix-config:integerbox config-key="int_validity" label="<?=  ___('Request validity (days)') ?>" config-default-value="30" min="1" max="365" />
                        <schlix-config:integerbox config-key="int_rate_limit" label="<?=  ___('Limit number of request per IP address per day') ?>" config-default-value="1" min="1" max="10000" />
                        <schlix-config:checkbox config-key="bool_ask_for_removal_reason" label="<?=  ___('Show reason input box for delete request') ?>" />
                        <schlix-config:checkbox config-key="bool_enable_captcha_request" label="<?=  ___('Require captcha for request') ?>" />
                        <schlix-config:checkbox config-key="bool_enable_captcha_confirm" label="<?=  ___('Require captcha for confirmation') ?>" />
                        <!--config --> 


                       <!-- Example Ends -->
                </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_main_opt" fonticon="fa fa-newspaper" label="<?= ___('Text') ?>"> 
                <!-- main page -->
                <x-ui:row>
                    <x-ui:column md="6">
                        <schlix-config:textbox config-key="str_mainpage_title" label="<?=  ___('Main page title') ?>"   />                        
                        <schlix-config:textarea config-key="str_mainpage_text" label="<?= ___('Main page introduction text') ?>" class="wysiwyg" />
                    </x-ui:column>
                    <!-- col -->
                    <x-ui:column md="6">
                        <schlix-config:textbox config-key="str_mainpage_title" label="<?=  ___('Confirmation page title') ?>"   />                        
                        <schlix-config:textarea config-key="str_mainpage_text" label="<?= ___('Confirmation page introduction text') ?>" class="wysiwyg" />
                    </x-ui:column>
                </x-ui:row>

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_item_opt" fonticon="fa fa-file-alt" label="<?= ___('Default Item Options') ?>"> 

                <schlix-config:item-meta-options config-key="array_default_item_meta_options" item-per-column="1" column-count="3" />
                <schlix-config:checkbox config-key="reset_item_options" label="<?=  ___('Reset all item options') ?>" />
            </x-ui:schlix-tab>
            <!-- hooks -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>                       

            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>      
