<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php $group_choices_array = $this->app->getGroupIDArrayForPermission(); ?>
<?php global $SystemConfig, $CurrentUser; ?>
<?php /*                    <li  class="selected"><a href="#tab1"><em><?= ___('Application Configuration') ?></em></a></li>                
  <li><a href="#tab2"><em><?= ___('Text Customization') ?></em></a></li>
  <li><a href="#tab2"><em><?= ___('User picture sizes') ?></em></a></li>
  <li><a href="#tab4"><em><?= ___('Permissions') ?></em></a></li>
 */ ?>
<schlix-config:data-editor   data-schlix-controller="SCHLIX.CMS.UsersAdmin" data-model="<?= $this->getDataModelURL() ?>"  data-field-id="<?= $this->app->getFieldID() ?>" data-cancel-warning="true">

    <schlix-config:save-result />
    <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

        <schlix-config:action-buttons />
        <x-ui:csrf />

        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('Application Configuration') ?>"> 
                <!--config -->
                <x-ui:row>
                    <x-ui:column md="6">
                        <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                        <schlix-config:app_description   />
                        <schlix-config:checkbox config-key="bool_force_ssl_authentication" label="<?= ___('Force SSL for login/registration (will not work if you do not have SSL installed') ?>" />
                        <schlix-config:checkbox config-key="bool_force_ssl_admin_authentication" label="<?= ___('Force SSL for login to the Administration backend (will not work if you don\'t have SSL installed') ?>" />
                        <br />
                        <schlix-config:checkbox config-key="bool_enable_captcha_user_login" label="<?= ___('Enable CAPTCHA for user login') ?>" />
                        <schlix-config:checkbox config-key="bool_enable_captcha_user_registration" label="<?= ___('Enable CAPTCHA for user registration') ?>" />
                        <schlix-config:checkbox config-key="bool_enable_captcha_user_activation" label="<?= ___('Enable CAPTCHA for user activation') ?>" />
                        <schlix-config:checkbox config-key="bool_enable_captcha_forgot_password" label="<?= ___('Enable CAPTCHA for forgot password request') ?>" />

                        <fieldset><legend><?= ___('Maintenance options') ?></legend>
                        <schlix-config:checkbox config-key="bool_disable_frontend_login" label="<?= ___('Disable frontend login') ?>" />
                        <schlix-config:checkbox config-key="bool_enable_registration" label="<?= ___('Enable Registration') ?>" />                        
                        </fieldset>
                    </x-ui:column>
                    <x-ui:column md="6">
                        
                        
                        

                        
                        <schlix-config:checkbox config-key="bool_allow_login_by_email" label="<?= ___('Enable Login by Email') ?>" />

                        <schlix-config:checkbox config-key="bool_requires_activation_by_email" label="<?= ___('Requires user to verify activation after registration') ?>" />
                        <schlix-config:checkbox config-key="bool_allow_public_profile_view" label="<?= ___('Enable public profile view') ?>" />


                        <schlix-config:checkbox config-key="bool_require_dob" label="<?= ___('Require date of birth to be specified during registration / profile edit') ?>" />
                        <schlix-config:checkbox config-key="bool_require_gender" label="<?= ___('Require gender to be specified during registration / profile edit') ?>" />                        

                        <schlix-config:integerbox   min="0" max="100" config-key="int_number_of_login_retry_before_captcha" label="<?= ___('Number of invalid logins before displaying captcha') ?>" />
                        <schlix-config:integerbox   min="0" max="150" config-key="int_minimum_age_registration" label="<?= ___('Minimum age for registration (require date of birth to be enabled)') ?>" />
                        <schlix-config:integerbox   min="1" max="720" config-default-value="48" config-key="int_hours_forgot_password" label="<?= ___('Validity period of password reset (hours)') ?>"  />

                        <schlix-config:dropdownlist   config-key="int_default_newuser_group_id" label="<?= ___('Default Group for New User Registration') ?>">
                            <schlix-config:option value="0"><?= ___('Please select') ?></schlix-config:option>
                            <?php foreach ($group_choices_array as $group): ?>
                                <schlix-config:option value="<?= ___h($group['value']) ?>"><?= ___h($group['label']) ?></schlix-config:option>
<?php endforeach ?>
                        </schlix-config:dropdownlist> 

                    </x-ui:column>
                </x-ui:row>
                <!-- end config -->

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_custom_text" fonticon="fa fa-file-alt" label="<?= ___('Text Customization') ?>">
                <!--content -->
                <schlix-config:textarea config-key="str_registration_welcome_text" label="<?= ___('Registration welcome text') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_registration_disabled_text" label="<?= ___('Registration disabled text / under maintenance message') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_login_welcome_text" label="<?= ___('Login welcome text') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_authenticated_users_welcome_text" label="<?= ___('Welcome text for authenticated users') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_forgot_password_text" label="<?= ___('Forgot password instruction text') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_password_reset_text" label="<?= ___('Password reset instruction text') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_myprofile_text" label="<?= ___('User profile instruction text') ?>" class="wysiwyg"  />
                <schlix-config:textarea config-key="str_password_change_text" label="<?= ___('Change Password instruction text') ?>" class="wysiwyg"  />

                <!-- end content -->
            </x-ui:schlix-tab>                
            <!-- tab -->
            <x-ui:schlix-tab id="tab_picture_size" fonticon="fa fa-image" label="<?= ___('User picture sizes') ?>">
                <!--content -->
                <x-ui:row>
                    <x-ui:column md="4">
                        <fieldset><legend><?= ___('Small Image') ?></legend>
                            <div class="form-inline">
                                <schlix-config:integerbox  min="16" max="512" config-key="int_small_width" required="required"   style="width:100px" config-default-value="32" />                                                             x                            
                                <schlix-config:integerbox  min="16" max="512" config-key="int_small_height" required="required"   style="width:100px" config-default-value="32" />
<?= ___('pixels') ?>.
                            </div>
                        </fieldset>
                    </x-ui:column>
                    <!-- col -->
                    <x-ui:column md="4">
                        <fieldset><legend><?= ___('Medium Image') ?></legend>
                            <div class="form-inline">
                                <schlix-config:integerbox  min="16" max="512" config-key="int_medium_width" required="required"   style="width:100px" config-default-value="128" />                            
                                x                            
                                <schlix-config:integerbox  min="16" max="512" config-key="int_medium_height" required="required"   style="width:100px" config-default-value="128" />
<?= ___('pixels') ?>.
                            </div>
                        </fieldset>                               
                    </x-ui:column>
                    <!-- col -->
                    <x-ui:column md="4">
                        <fieldset><legend><?= ___('Small Image') ?></legend>
                            <div class="form-inline">
                                <schlix-config:integerbox  min="16" max="1920"  config-key="int_large_width" required="required"   style="width:100px" config-default-value="256" />                                       x                            
                                <schlix-config:integerbox  min="16" max="1920"  config-key="int_large_height" required="required"   style="width:100px" config-default-value="256" />
<?= ___('pixels') ?>.
                            </div>
                        </fieldset>                                
                    </x-ui:column>
                </x-ui:row>
                <!-- end content -->
            </x-ui:schlix-tab>                


            <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>
            <!-- end -->
        </x-ui:schlix-tab-container>

    </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
