/* 
 * Copyright (C) 2015 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */
/**
 * Element class
 */

SCHLIX.CMS.UserExplorer = class extends SCHLIX.CMS.DataExplorerManyToMany  {  
    /**
     * Constructor
     */
    constructor (el, options)
    {
        super(el, options);
        this.field_category_id = 'cid';
        this.field_category_title = 'title';
        this.field_item_title = 'username';
        
        this.__first_time_load = true;
    };

    /**
     * Datatable row format: item status
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_Status (elCell, oRecord, oColumn, oData) {
        var button_name = '';
        var color = '';

        switch (oData)
        {
            case -2:
                button_name = "question-circle";
                color = 'orange';
                break;
                // more ...
            case 1:
                button_name = "check-circle";
                color = 'green';
                break;
                // more ...
                
            default:
                button_name = "times-circle";
                color = 'red';
                break;
        }
        elCell.innerHTML = '<i class="fa fa-' + button_name + '" style="color:' + color + '"></i>';
    }; // end func 

    // --------------------------------- VARIABLES ------------------------------- //
    formatUserName (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];

        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var app_name = this.parentControl.app_name;
        var is_category = oRecord.getData("cid") > 0;
        var the_id = is_category ? odata_cid : odata_id;
        var itemTitle = is_category ? oRecord.getData("groupname") : oRecord.getData(field_title);
        if (itemTitle == null) itemTitle = '???';
        itemTitle = (itemTitle.length > 40) ? itemTitle.substr(0, 40) + '...' : (itemTitle === '') ? '(Untitled)' : itemTitle;
        var editIcon = is_category ?  "<i class=\"fas fa-pencil-alt\"></i> " : '';
        var icon = is_category ? "<i class =\"fas fa-folder fa-2x\"></i>" : "<i class =\"fa fa-user fa-2x\"></i>";      
        var theValue = is_category ? 'c' + the_id : 'i' + the_id;
        var action_link = is_category ? 'editcategory' : 'edititem';
        var itemLink = site_httpbase + this.parentControl.schlix_application_url + 'action=' + action_link +  '&id=' + the_id;
        if (itemTitle)
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);
        if (is_category)
            elCell.innerHTML = '<div style="float:left" >' + '<a  title="Click here to go into this category" class="datatable-folder dragdrop" href="#"  data-category-id="' + the_id + '" data-dragdrop-id="' + theValue + '" id="' + app_name + "-lnk-" + theValue + '">' + " " + icon + " " + itemTitle + '</a>' +
                    '</div>  <div style="float:right;margin-left:4em"><a title="Edit this category" href="' + itemLink + '">' + editIcon + '</a></div>';
        else
            elCell.innerHTML = '<a class="dragdrop" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>'; 
    };
};

SCHLIX.CMS.registerComponent('schlix-user-explorer', SCHLIX.CMS.UserExplorer);


/****************************************************/
/**
 * View Controller class
 */
SCHLIX.CMS.UsersAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("users");
    };
    
    static formatHistoryDescription (elCell, oRecord, oColumn, oData) {

        var itemTitle = ___h(oRecord.getData('description')); // Dec 2, 2025 - fix
        if (itemTitle == null) itemTitle = '???';
        itemTitle = (itemTitle.length > 100) ? itemTitle.substr(0, 100) + '...' : (itemTitle === '') ? '(Untitled)' : itemTitle;
       
        elCell.innerHTML = itemTitle;
    };
     
    setDefaultFields(fields) {
        for(var el of fields) {
            el.defaultValue = el.value;
        }
    }

    doBeforeDialogFormClose() {
        var els = SCHLIX.Dom.get(['change_email_address','change_email_address_verify']);
        if (els[0].value != els[0].defaultValue) {
            this.setDefaultFields(els);
            SCHLIX.Dom.get('original_email_address').value = els[0].value;
            this.updateEmailTexts(els[0].value);
        }
        return true;
   };

   updateEmailTexts(email) {
        var els = SCHLIX.Dom.getElementsByClassName('email-address-text');
        for (var el of els) {
            el.innerHTML = email;
        }
   };

    toggleDialog(id, doShow)
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-'+id+'-dialog');
        if (typeof doShow === 'undefined')
        {
            doShow = !obj.dialog.cfg.getProperty('visible');
        }
        (doShow) ? obj.show() : obj.hide(true);
    }
    
    onChangePasswordClick(e)
    {
        this.toggleDialog('change-password');
        this.onPasswordToggle();
    };
    
    onChangeEmailClick(e)
    {
        this.toggleDialog('change-email');
    };

    onPasswordResetSent(o)
    {
        var response = ajax_parse(o.responseText);
        if (o.status == 200)
        {
            SCHLIX.Alert.info(response);
            this.toggleDialog('change-password', false);
        }
    };
    
    
    onPasswordToggle(e, input)
    {
        if (!input) 
            input = SCHLIX.Dom.query('#change_password_type input:checked')[0];
        var hideClass, showClass;
        if (input.value === 'change_password') {
            hideClass = 'password-toggle-email';
            showClass = 'password-toggle-change';
        } else {
            hideClass =  'password-toggle-change';
            showClass = 'password-toggle-email';
        }
        SCHLIX.Dom.addClass(SCHLIX.Dom.getElementsByClassName(hideClass), 'hidden');
        SCHLIX.Dom.removeClass(SCHLIX.Dom.getElementsByClassName(showClass), 'hidden');
    }
    
    onDOMReady()
    {
        SCHLIX.Event.on('change_email','click',this.onChangeEmailClick, this, true);
        SCHLIX.Event.on('change_password','click',this.onChangePasswordClick, this, true);
        //SCHLIX.Event.on('btn_send_password_reset','click',this.sendPasswordResetLink, this, true);
        SCHLIX.Event.delegate('change_password_type','change',this.onPasswordToggle, 'input', this, true);
     //   SCHLIX.Event.on(SCHLIX.Dom.get('{.confirm_status}'),'click',this.onChangeUserStatus);
    };
    
    validateSaveUser()
    {
        var pwd_display = SCHLIX.Dom.get('new_account_email_password_setup');
        if (pwd_display )
        {
            var field_email = SCHLIX.Dom.get('email_address');
            var txt_email = field_email.value;
            var txt_email_verify = SCHLIX.Dom.get('email_address_verify').value;
            if (txt_email !== txt_email_verify)
            {
                SCHLIX.Alert.error('Please verify your email');
                field_email.focus();
                return false;
            }
            
            var field_password = SCHLIX.Dom.get('password');
            var txt_password = field_password.value;
            var txt_password_verify = SCHLIX.Dom.get('password_verify').value;
            if (txt_password !== txt_password_verify)
            {
                SCHLIX.Alert.error('Please verify your password');
                field_password.focus();
                return false;
            }
        }
        return true;
    
    };
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'save-item':
            case 'apply-item':
                var result = this.validateSaveUser();
                return result ? super.runCommand(command, evt) : true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    };
    

    
} // end class