<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
namespace Block;

global $__google_analytics_loaded;

class GoogleAnalytics extends \SCHLIX\cmsBlock
{
	public function Run()
	{
		global $SystemConfig, $CurrentUser, $__google_analytics_loaded;

		if ($__google_analytics_loaded !== 'loaded') // prevent the built-in duplicate blocks feature 
		{
			
			$tracking_id = alpha_numeric_with_dash_underscore($this->getConfig('str_tracking_id'));
			$ga_tracking_method = (int) $this->getConfig('int_tracking_method');
			$ga_support_ip_anonymization = $this->getConfig('bool_support_ip_anonymization');
			$ga_support_force_ssl = $this->getConfig('bool_support_force_ssl');
                        
			$domain_name = $this->getConfig('str_domain_name');			
			$track_sub_domains = $this->getConfig('bool_track_sub_domains');
			$track_multiple_top_level_domains = $this->getConfig('bool_track_multiple_tld_domains');	
			$display_advertiser_support = $this->getConfig('bool_display_advertiser_support');		
			$__google_analytics_loaded = 'loaded';
			$this->loadTemplateFile('googleanalytics',compact(array_keys(get_defined_vars())));
		}
  	}
}
 