<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Macro;

class BannedIP extends \SCHLIX\cmsMacro {

    protected function isCurrentUserIPBanned() {
        global $SystemDB;

        $ip_addr = get_user_real_ip_address();
        $is_ban = \SCHLIX\cmsContextCache::get('banned_ip', $ip_addr);
        if ($is_ban == 'yes' || $is_ban == 'no')
        {
            return $is_ban == 'yes';
        } else
        {
            $sanitized_ip_addr = sanitize_string($ip_addr);
            $sql = "SELECT id FROM gk_bannedip_items WHERE ip_address = {$sanitized_ip_addr}";
            $result = $SystemDB->getQueryResultSingleRow($sql, true);
            $is_banned = ($result != null);
            \SCHLIX\cmsContextCache::set('banned_ip', $ip_addr, $is_banned ? 'yes' : 'no');
            return $is_banned;
        }
       
    }

    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = NULL) {

        if ($this->isCurrentUserIPBanned()) {
            $text = $this->config['str_banned_text'];
            ob_end_clean();
            die($text);
        } else
            return $text;
    }

}

?>