<?php
/**
 * Gallery
 * 
 * Gallery macro alternative view template using FancyBox and Slider Pro (not included in the core)
 *
 * @copyright SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    https://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php if ($album_images): ?>
<!-- REMOVE THIS -->
<div class="alert alert-danger">
    <?php 
    $template_file_name = 'view.imagegallery';
    $old_file_location = CURRENT_SUBSITE_URL_PATH.'/macros/imagegallery/'.$template_file_name.'.template.php'; 
    $new_file_location = CURRENT_THEME_URL_PATH.'/macros/imagegallery/'.$template_file_name.'.template.php'; 
    ?>
    <p><strong>WARNING</strong>: This is a stock template file that you must customize on your own. This file is located in <strong><?= $old_file_location ?></strong>. You should copy this file and customize it in this location: <strong><?= $new_file_location ?></strong></p>
</div>
<!-- END REMOVE THIS -->
    <?php
    // vars: $image_gallery_app and $album_images
    // Replace this with your own in your /web/<subsite>/themes/<theme>/apps/gallery/xxxx 
    // JQuery should be loaded prior to this
    // You can replace this with others like owlCarousel 2, slick Slider, etc
    global $HTMLHeader;
    $HTMLHeader->CSS('/system/js/slider-pro/css/slider-pro.css');
    $HTMLHeader->CSS('/system/js/fancybox/jquery.fancybox.css');    
    $HTMLHeader->JAVASCRIPT('/system/js/fancybox/jquery.fancybox.pack.js');    
    $HTMLHeader->JAVASCRIPT('/system/js/slider-pro/js/jquery.sliderPro.min.js');
    
    $blank_gif = '/'.SCHLIX_SITE_HTTPBASE. $this->getURLofScript('slider-pro/css/images/blank.gif');
    global $HTMLHeader;
    
    $HTMLHeader->JAVASCRIPT_TEXT("$( document ).ready(function( $ ) {
                $( '#imagegallery-macro-{$image_gallery_id}' ).sliderPro({
			width: 960,
			height: 500,
			fade: true,
			arrows: true,
			buttons: false,
			fullScreen: true,
			shuffle: true,
			smallSize: 500,
			mediumSize: 1000,
			largeSize: 3000,
			thumbnailArrows: true,
			autoplay: true
		});
	});");
    ?>
        <div id="imagegallery-macro-<?= $image_gallery_id ?>" class="slider-pro">
            <div class="sp-slides"> 
                
                <?php foreach ($album_images as $image): ?>
                     
                <div class="sp-slide">
                    <img class="sp-image" src="<?= $blank_gif ?>" 
                         data-src="<?= $image_gallery_app->getDataFileURLPath('image_medium', $image['url_media_file'])?>" 
                         data-small="<?= $image_gallery_app->getDataFileURLPath('image_small', $image['url_media_file'])?>"
                         data-medium="<?= $image_gallery_app->getDataFileURLPath('image_medium', $image['url_media_file'])?>"
                         data-large="<?= $image_gallery_app->getDataFileURLPath('image_large', $image['url_media_file'])?>"
                         data-retina="<?= $image_gallery_app->getDataFileURLPath('image_large', $image['url_media_file'])?>"/>
                    <?php if ($image['summary']): ?>
                    <div  class="sp-layer sp-black sp-padding" 
                       data-position="bottomLeft" data-width="100%" 
                       data-show-transition="up" data-show-delay="400">
                        <?= $image['summary'] ?>
                    </div>                    
                    <?php endif ?>
                </div>
                    
                <?php endforeach ?>
                
            </div>

            <div class="sp-thumbnails">
                <?php foreach ($album_images as $image): ?>
                    <img class="sp-thumbnail" src="<?= $image_gallery_app->getDataFileURLPath('image_medium', $image['url_media_file'])?>" alt="<?= ___h($image['title']) ?>" />
                <?php endforeach ?>
            </div>
        </div>
    
<?php else: ?>
<!-- No Gallery Image found - Gallery Macro -->
<?php endif ?>