<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */
?>
<?php
/**
 * This is specified from /themesberitanews/apps/blog/view.main.template.php,
 * which runs before this page is called.
 *
 * @global $_blog_first_page
 */
global $_blog_first_page;

$column_body_width = $_blog_first_page ? '12': '8';


?>
<!doctype html>
  <head>
    <title><?= \SCHLIX\cmsPageOutput::HTMLPageTitle() ?> - <?= ___h(SCHLIX_SITE_NAME) ?></title>
    <?php include('header.inc.php'); ?>
  </head>
  <body>
    <div class="page-wrapper">
      <div class="page-content">
        <!--- header  -->
        <?php include('header_nav.inc.php'); ?>
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
        <div class="breadcrumb-bg">
            <div class="container">
                <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
            </div>
        </div>
        <!-- end breadcrumb -->
        <section id="display-page" class="section-row" >
          <div class="container">
            <div class='row'>
              <div class='col-md-<?= $column_body_width ?>'>
                <?= SCHLIX\cmsPageOutput::ApplicationBody() ?>
              </div>
                <?php if (!$_blog_first_page): ?>
              <div class='col-md-4'>
                <?= SCHLIX\cmsPageOutput::BlockCategory('sidebar') ?>
              </div>
                <?php endif ?>
            </div>
          </div>
        </section>
      </div>


      <!-- end body -->
      <?php include('footer.inc.php'); ?>
    </div>
  </body>
</html>
