<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.

The view templates inside the apps and blocks  folder in this theme provide  you with ample amount of customization.
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

// this will retrieve the custom header image
$header_img = \App\Core_MediaHeader::getCustomHeaderByGUID($this, $item['guid']);

global $_custom_header_image, $_custom_header_title, $_custom_header_use_global;
$_custom_header_image = $header_img;
$_custom_header_title = $item['title'];

?>
<div class="app-page-item app-<?= $this->app_name; ?>" >
    <?= $item['macro_processed_text_outside_article_top'] ?>
    <article itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>" class="item" id="app-<?= $this->app_name; ?>-item-<?= $item[$this->field_id]; ?>">
        <!-- Page Title with custom background image -->
        <?php if ($item_meta_options['display_pagetitle'] && !$_custom_header_use_global): ?>
        <div class="media-header-full-width " style="background-image: url('<?= $header_img ?>');">
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="headline"><?= ___h($_custom_header_title); ?></h1>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
        <!-- End Page Title -->
        <!-- breadcrumb -->
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
        <div class="breadcrumb-bg">
            <div class="container">
                <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
            </div>
        </div>
        <?php endif; ?>
        <!-- end breadcrumb -->
        
        
        <!-- Macro - Pre -->
        <?php if ($item['macro_processed_text_before_article']): ?>        
            <div class="meta before-article">        
            <?= $item['macro_processed_text_before_article'] ?>            
            </div>
        <?php endif ?>
        <!-- End Macro - Pre -->
        <!-- content -->
        <div class="text" itemprop="articleSection">
            <?= $item['summary'] ?>
            <?= $item['description'] ?>
        </div>
        <!-- end content -->
        <?php if ($item['macro_processed_text_after_article']): ?>
            <div class="meta after-article">
                <?= $item['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
    </article>
</div>
