<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.
 * License: MIT
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */ ?>
<!doctype html>
<html>
<head>
    <meta charset="UTF-8">
    <title><?= ___h(SCHLIX_SITE_NAME); ?> - <?= \SCHLIX\cmsPageOutput::HTMLPageTitle() ?></title>
    <?php include('header.inc.php'); ?>
</head>
<body>
    <!-- topmenu -->
    <div class="navbar-wrapper frontpage-navbar-wrapper">
        <div class="container">
            <nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top">
                <div class="container">
                    <a class="navbar-brand" href="<?= SCHLIX_SITE_HTTPBASE . '/' ?> "><img src="<?= CURRENT_THEME_URL_PATH; ?>/images/sample_logo_1_colour.png" alt="Company Name"></a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#main-navbar-menu" aria-controls="main-navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="main-navbar-menu">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('menu_top'); ?>
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('search'); ?>
                    </div>
                </div>
            </nav> 
        </div>
    </div>
    <!-- end topmenu -->

    <section id="display-page" class='container'>
        <?php
        /**********************************************************************
         * Custom header image needs to be placed in the THEME template file
         * if the template has 1 or more sidebar (2 or 3 column)
         * Otherwise the header image will not be displayed properly.
         * To do this, you will need to specify 2 global variables inside your
         * APP template file: $_custom_header_image and $_custom_header_title.
         * The name is arbitrary but must be the same declaration
         * 
         * In this example, the blog will be set to using the regular template
         * if it's displayed on the main page, but on subsequent page it will
         * switch to 2 column (two-column-right-sidebar.template.php)
         * because on its MENU item, the inner pages subtemplate is set to 
         * two-column-right-sidebar.template.php.
         * 
         * You can change this behaviour if you prefer to use a single column
         * template
         **********************************************************************/ 
        global $_custom_header_image, $_custom_header_title, $_custom_header_extra_class;
        ?>
        <div class="media-header-full-width <?= $_custom_header_extra_class ?>" style="background-image: url('<?= $_custom_header_image ?>');">
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="name"><?= $_custom_header_title ?></h1>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
        <!-- End Page Title -->
        <!-- breadcrumb -->
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
        <div class="breadcrumb-bg">
            <div class="container">
                <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
            </div>
        </div>        
        
        <div class="row">
            <!-- main -->
            <div class="col-md-8">
                <?= SCHLIX\cmsPageOutput::ApplicationBody() ?>
            </div>
            <!-- sidebar -->
            <div class="col-md-4">
                <?= SCHLIX\cmsPageOutput::BlockCategory('sidebar') ?>
            </div>                        
        </div>
    </section>
    <section id="bottom">
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer1') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer2') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer3') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer4') ?>
                    </div>    
                </div><!--/.col-md-3-->
            </div>
        </div>
    </section><!--/#bottom-->


    <footer id="footer">
        <div class="container">
            <div class="row">
                <div class="col-sm-6">
                    &copy; <?= date('Y') ?> <a target="_blank" href="<?= SCHLIX_SITE_URL ?>" title="Demo theme">My Company Name</a>. All Rights Reserved.
                </div>
                <div class="col-sm-6">
                    <?= \SCHLIX\cmsPageOutput::BlockCategory('menu_bottom') ?>
                </div>
            </div>
        </div>
    </footer><!--/#footer-->
    <?php include('footer.inc.php'); ?>
    <!-- end body -->
</body>
</html>