CKEDITOR.plugins.add('fontawesome', {
    requires: 'widget',
    icons: 'fontawesome',
    init: function(editor) {
        editor.widgets.add('FontAwesome', {
            button: 'Insert Font Awesome',
            template: '<span class="fav2"><i class="" style="" aria-hidden="true" title=""></i><span style="position:absolute; left:-10000px; top:auto; width:1px; height:1px; overflow:hidden;"></span></span>',
            dialog: 'fontawesomeDialog',
            allowedContent: 'span(!fav2){*};i(*)[*]',
            upcast: function(element) {
                return element.name == 'span' && element.hasClass('fav2')
            },
            init: function() {
                this.setData('title', this.element.$.children[0].getAttribute('title'));
                this.setData('class', this.element.$.children[0].getAttribute('class'));
                this.setData('color', this.element.$.children[0].style.color);
                this.setData('size', this.element.$.children[0].style.fontSize)
            },
            data: function() {
                this.element.$.children[0].setAttribute('title', this.data.title);
                this.element.$.children[0].setAttribute('class', this.data.class);
                this.element.$.children[1].innerHTML = this.data.title;
                var istayl = '';
                istayl += this.data.color != '' ? 'color:' + this.data.color + ';' : '';
                istayl += this.data.size != '' ? 'font-size:' + parseInt(this.data.size) + 'px;' : '';
                istayl != '' ? this.element.$.children[0].setAttribute('style', istayl) : '';
                istayl == '' ? this.element.$.children[0].removeAttribute('style') : ''
            }
        });
        CKEDITOR.dialog.add('fontawesomeDialog', this.path + 'dialogs/fontawesome.js');
        CKEDITOR.document.appendStyleSheet( CKEDITOR.plugins.getPath('fontawesome') + 'dialogs/plugin.css');
        CKEDITOR.document.appendStyleSheet( CKEDITOR.plugins.getPath('fontawesome') + '../../../../fonts/font-awesome/font-awesome.min.css?v=5');
    }
});