/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */
SCHLIX.CMS.WysiwygHelper = {
    insertURL: function (url)
    {
        parent.tinymce.activeEditor.windowManager.getParams().setUrl(url);
        parent.tinymce.activeEditor.windowManager.close();

    },
    browse: function (field_name, url, type, win) {
        // TODO: user file browser
        fileBrowserURL = site_httpbase + "/admin/app/core.mediamanager?frame=1";

        var width = window.innerWidth - 30;
        var height = window.innerHeight - 60;
        if (width > 1800)
            width = 1800;
        if (height > 1200)
            height = 1200;
        if (width > 600) {
            var width_reduce = (width - 20) % 138;
            width = width - width_reduce + 10;
        }

        tinyMCE.activeEditor.windowManager.open({
            title: "SCHLIX Media Manager",
            url: fileBrowserURL,
            width: width,
            height: height,
            resizable: true,
            inline: 1,
            maximizable: 1,
            close_previous: 0
        }, {
            window: win,
            input: field_name,
            oninsert: function (url, title, alt, height, width)
            {
                win.document.getElementById(field_name).value = url;
                win.parent.tinymce.activeEditor.windowManager.close(window);
            },
            /***********/

            setUrl: function (url) {
                //console.warn('setURL' + url);
                var fieldElm = win.document.getElementById(field_name);
                fieldElm.value = tinymce.activeEditor.convertURL(url);
                if ("createEvent" in document) {
                    var evt = document.createEvent("HTMLEvents");
                    evt.initEvent("change", false, true);
                    fieldElm.dispatchEvent(evt);
                } else {
                    fieldElm.fireEvent("onchange");
                }
            }
            /***********/

        });
    }    
}

/****__insert_config_here__****/


SCHLIX.CMS.TinyMCE4Helper = {
    onDOMReady: function ()
    {
        var editor_els = SCHLIX.Dom.get('{' + __tinymce4_config.selector + '}');
        if (editor_els && editor_els.length > 0)
        {
            SCHLIX.CMS.TinyMCE4Helper.loadJavascriptFile();
            // For Bootstrap compatibility
            $(document).on('focusin', function(e) {
              if ($(e.target).closest(".mce-window").length) {
                e.stopImmediatePropagation();
              }
            });            
        }
    },
    onWywiwygLoaded: function ()
    {
        tinymce.init(__tinymce4_config);
    },
    loadJavascriptFile: function ()
    {
        var tinymce_full_path = site_httpbase +'/system/wysiwygeditors/tinymce4/tinymce.full.min.js';
        //experimental, release it for next version
        //tinymce_full_path = site_httpbase +'/wysiwygeditors/action/call/editor/tinymce4/do/compress/profile/2';
        
        SCHLIX.CMS.TinyMCE4Helper.EditorLoader = new SCHLIX.Core.JSLoader({onSuccess: SCHLIX.CMS.TinyMCE4Helper.onWywiwygLoaded});
        SCHLIX.CMS.TinyMCE4Helper.EditorLoader.addModule({
            name: 'wysiwyg', type: 'js', varName: "tinymce4", fullpath: tinymce_full_path //,
        });
        SCHLIX.CMS.TinyMCE4Helper.EditorLoader.require("wysiwyg"); 
        SCHLIX.CMS.TinyMCE4Helper.EditorLoader.insert();
    }

};





SCHLIX.Event.onDOMReady(SCHLIX.CMS.TinyMCE4Helper.onDOMReady);