<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die();
global $Blocks;
?>
<h1 class="title"><i class="fa fa-user"></i> <?= ___('Change Password') ?></h1>
<hr />


    <x-ui:row>
        <!-- col -->
    <x-ui:column sm="2" md="2">
        
       <?php 
       /* example on how to call SCHLIX\cmsPageOutput::BlockCategory('menu_members') from application template file. If you want to do it this way then you will have to  */
       $Blocks->displayBlockByCategoryNameRerun('sidebar_members');
       ?>
    </x-ui:column>
    <!-- col -->
        
        <x-ui:column sm="6" md="4">

            <x-ui:panel type="panel-default">
                <x-ui:panel-body>
                    <x-ui:row>
                        <x-ui:column sm="12">
                            <x-ui:form-simple-ajax name="form-user-change-password" id="form-user-change-password" method="post" data-action="<?= $this->createFriendlyURL("action=UserChangePassword") ?>" enctype="multipart/form-data" >
                                <x-ui:csrf />
                                <x-ui:password name="oldpassword" id="oldpassword" required="required" fonticon="fa fa-unlock" label="<?= ___('Current password') ?>" placeholder="<?= ___('Current password') ?>" value="" />

                                <x-ui:form-group>

                                    <label for="password"><?= ___('Enter a new password and confirm') ?></label>
                                    <x-ui:input-group>

                                        <x-ui:input-addon>
                                            <i class="fa fa-lock"></i>
                                        </x-ui:input-addon>                                    
                                        <x-ui:password name="password" id="password" required="required" placeholder="<?= ___('New password') ?>" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{7,70}"  value="" />

                                        <x-ui:password name="password_verify" id="password_verify" required="required"   placeholder="<?= ___('Confirm this new password') ?>" value="" />
                                    </x-ui:input-group>
                                </x-ui:form-group>

                                <?php if ($this->getConfig('bool_enable_captcha_change_password')): ?>
                                    <x-ui:captcha id="verification_code" name="verification_code" />
                                <?php endif ?>
                                <x-ui:button button-type="ok"  type="submit" name="submit" id="btn-change-password" data-form-submit="1"  value="Submit" label="<?= ___('Change Password') ?>" fonticon="fas fa-lock" block="1" size="large" />
                            </x-ui:form-simple-ajax>    

                        </x-ui:column>
                    </x-ui:row>
                </x-ui:panel-body>
            </x-ui:panel>

        </x-ui:column>

    <!-- col -->
    <x-ui:column sm="6" md="6">
        <div class="schlix-ajax-output"></div>
        <?php if (___c($error_list) > 0): ?>
            <x-ui:alert type="error" var="error_list" fonticon="fa fa-times" />
        <?php endif; ?>            
        <?php if (___c($success_list) > 0): ?>
            <x-ui:alert type="info" var="success_list" fonticon="fa fa-check" />
        <?php endif; ?>            


        <!-- content -->
        <x-ui:echo-safe-config-value key="str_password_change_text" />
    </x-ui:column>
</x-ui:row>
 

<!-- ############################ -->