<?php
/* 
 * SCHLIX WEB CONTENT MANAGEMENT SYSTEM
 * Copyright (C) SCHLIX WEB INC.
 * License: GPLv3
 */

/**
 * SCHLIX Version definition
 */
define ('SCHLIX_VERSION','2.2.9-5');
if (PHP_VERSION_ID < 50600 )
    die('PHP v5.6.0+ required. This system is running on PHP v'.PHP_VERSION.'. If this is a CPanel-based server, change it in MultiPHP');
/**
 * Initializes SCHLIX runtime
 */

function setupSchlixRuntime()
{
    global $CurrentWebSiteThemeName;

    define('SCHLIX_ROOT_PATH', str_replace('\\', '/', dirname(__FILE__)));        
    require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/translation.inc.php');
    ini_set('pcre.jit', false); // May 1, 2017 - fix for PHP7 PREG_JIT_STACKLIMIT_ERROR
    ini_set('session.use_only_cookies', '1');
    ini_set('session.use_trans_sid', '0');
    @ini_set('session.cookie_httponly', 1);
    if (isCurrentRequestSSL() )
    {
        @ini_set('session.cookie_secure', 1);        
    }
    
    set_error_handler("_schlix_main_error_handler");
    //set_exception_handler("_schlix_exception_handler");
    register_shutdown_function('schlix_shutdown_handler');
    spl_autoload_register('schlix_autoloader');
    
    define('SCHLIX_SERVER_ROOT_PATH',str_replace('\\', '/', realpath($_SERVER['DOCUMENT_ROOT'])));    
    define('SCHLIX_SYSTEM_PATH', SCHLIX_ROOT_PATH.'/system');
    define('SCHLIX_SYSTEM_URL_PATH_NO_BASE', '/system');
    define ('SCHLIX_DEFAULT_CA_BUNDLE',  SCHLIX_SYSTEM_PATH.'/libs/data/ca-bundle/ca-bundle.pem');
    // 2. Initialize Multisit
    if (!file_exists(SCHLIX_ROOT_PATH.'/multisite-config.inc.php'))
        die('Multisite configuration file cannot be found. Please <a href="install">install</a> the CMS first.');
    require (SCHLIX_ROOT_PATH.'/multisite-config.inc.php');
    
    // 2a. You can force SITE_HTTPBASE in multisite-config.inc.php
    // Jan 17, 2017 - fix for ISPConfig since it uses smylink
    // Jan 19, 2017 - fix for Odin automation with custom config
    if (file_exists(SCHLIX_ROOT_PATH.'/custom-config.inc.php'))
    {
        include (SCHLIX_ROOT_PATH.'/custom-config.inc.php');
    }
    if (!defined('SCHLIX_SITE_HTTPBASE'))
    {
        $site_httpbase = '';
        if (strlen(SCHLIX_SERVER_ROOT_PATH) != strlen (SCHLIX_ROOT_PATH))
        {
            $s = strpos(SCHLIX_ROOT_PATH, SCHLIX_SERVER_ROOT_PATH);
            if (($s == 0) && ($s !== false)) {
                $prefix_length = strlen(SCHLIX_SERVER_ROOT_PATH);
                $site_httpbase = substr(SCHLIX_ROOT_PATH, $prefix_length, strlen(SCHLIX_ROOT_PATH) - $prefix_length);
            }
            else 
            {
                //The only time that this custom config is generated automatically
                //is when the site is visited and no custom-config.inc.php found
                //The visit must be SCHLIX CMS root URL without any other parameters
                if ($_SERVER['REQUEST_URI'].'index.php' === $_SERVER['SCRIPT_NAME'])
                {
                    $site_httpbase = rtrim($_SERVER['REQUEST_URI'],'/');
                    $custom_config_content = "<?php define ('SCHLIX_SITE_HTTPBASE','{$site_httpbase}');\n";
                    $result = file_put_contents(SCHLIX_ROOT_PATH.'/custom-config.inc.php', $custom_config_content);
                    if ($result === FALSE)
                        die ('Error while trying to define SCHLIX_SITE_HTTPBASE automatically and write to /custom-config.inc.php');
                } else
                die ('Could not determine SCHLIX_SITE_HTTPBASE automatically since SCHLIX seems to be installed outside of server document root. Please define SCHLIX_SITE_HTTPBASE manually in custom-config.inc.php and change the line in .htaccess that contains index.php to /{SCHLIX_SITE_HTTPBASE}/index.php');
            }
        }
        define('SCHLIX_SITE_HTTPBASE', $site_httpbase); // auto path (but it's slower ... change this when you're in production mode    
    }
    define('SCHLIX_SYSTEM_URL_PATH', SCHLIX_SITE_HTTPBASE.'/system');
    
    // 3. Initialize Current Subsite 
    verifySchlixSubsites();                
    define('CURRENT_SUBSITE_PATH', SCHLIX_ROOT_PATH.'/web/'.CURRENT_SUBSITE_NAME);
    define('SCHLIX_FS_CACHE_FOLDER', CURRENT_SUBSITE_PATH.'/cache');


    if (!file_exists(CURRENT_SUBSITE_PATH.'/config.inc.php'))
      die('Configuration file for ['.CURRENT_SUBSITE_NAME.'] cannot be found. Please <a href="install/">re-install</a> or configure config.inc.php for subsite: ');
    
    
    define('CURRENT_SUBSITE_URL_PATH', SCHLIX_SITE_HTTPBASE.'/web/'.CURRENT_SUBSITE_NAME);
    define('CURRENT_SUBSITE_URL_PATH_NO_BASE', '/web/'.CURRENT_SUBSITE_NAME);
    
    require (CURRENT_SUBSITE_PATH.'/config.inc.php');
    //. Begin the rest 
    require (SCHLIX_ROOT_PATH.'/system/libs/schlix/definitions.inc.php');
    //. Load language
    if (SCHLIX_DEFAULT_LANGUAGE !== 'en_us')
    {
        $lang_file = SCHLIX_ROOT_PATH.'/system/languages/'. SCHLIX_DEFAULT_LANGUAGE . '.lang.php';
        if (file_exists($lang_file)) require $lang_file;
    }
    // end load language
    // removed - for subsites only - September 23, 2020
    //require (SCHLIX_ROOT_PATH.'/system/libs/external/vendor/autoload.php');
    
    require (SCHLIX_ROOT_PATH.'/system/libs/schlix/app_interface.php');
    require_once(SCHLIX_ROOT_PATH.'/system/libs/schlix/app_basic.class.php');
    //***** INTERNAL *****
    require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/html.inc.php');
    require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/schlix_util.inc.php');
    require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/util.inc.php');
    
    schlix_check_install_errors();
    
    require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/db.inc.php');
    require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/skins.inc.php');
    require_once (SCHLIX_ROOT_PATH.'/system/apps/core/core.class.php');    
    
    //***** END INTERNAL INIT *****
    initializeSchlixSystem();
    $CurrentWebSiteThemeName = \App\Core_ThemeManager::getCurrentFrontendWebsiteTemplateName();
    define ('CURRENT_THEME_PATH', SCHLIX_SITE_PATH . "/themes/{$CurrentWebSiteThemeName}");
    define ('CURRENT_THEME_URL_PATH', SCHLIX_SITE_HTTPBASE.'/web/'.CURRENT_SUBSITE_NAME."/themes/{$CurrentWebSiteThemeName}");
    define ('CURRENT_THEME_URL_PATH_NO_BASE', '/web/'.CURRENT_SUBSITE_NAME."/themes/{$CurrentWebSiteThemeName}");
    if (file_exists(CURRENT_SUBSITE_PATH.'/libs/autoload.php'))
            require (CURRENT_SUBSITE_PATH.'/libs/autoload.php');
    
}

function initializeSchlixSystem()
{
    
    global $CurrentPage;
    /**
     * Global view data
     * @var array
     */
    global $ViewData;
    /**
     * Database
     * @var \SCHLIX\cmsDBCache
     */
    global $SystemDB;
    /**
     * Versioning
     * @var \App\Core_versioning
     */
    global $Versioning;
    /**
     * Tag Manager
     * @var \App\Tag
     */    
    global $TagManager;
    /**
     * Current User
     * @var \App\Users
     */    
    global $CurrentUser;
    /**
     * System configuration registry
     * @var \SCHLIX\cmsConfigRegistry
     */        
    global $SystemConfig;
    /**
     * @var \SCHLIX\cmsLogger
     */        
    global $SystemLog;
    /**
     * @var \SCHLIX\cmsSessionHandler
     */            
    global $SchlixSessionHandler;
    
    // removed - 2021-Jan-10 - not necessary
    // global $SystemCustomField;
    
    // internal - don't access directly
    global $__schlix_table_columns, $__schlix_table_pks;    
    class_alias('\\App\\Core_CustomField', '\\App\\CustomField');
    class_alias('\\App\\Core_BannedIP', '\\App\\BannedIP');
    class_alias('\\App\\Core_CronScheduler', '\\App\\CronScheduler');
    class_alias('\\App\\Core_EmailQueue', '\\App\\EmailQueue');
    class_alias('\\App\\Core_EmailTemplate', '\\App\\EmailTemplates');
    class_alias('\\App\\Core_Menu', '\\App\\Menus');
    class_alias('\\App\\Core_LogViewer', '\\App\\LogViewer');
    class_alias('\\App\\Core_Versioning', '\\App\\Versioning');
    class_alias('\\App\\Core_SCHLIXUpdater', '\\App\\SCHLIXUpdater');
    class_alias('\\App\\Core_ApplicationManager', '\\App\\Applications');
    class_alias('\\App\\Core_BlockManager', '\\App\\Blocks');
    class_alias('\\App\\Core_EditorManager', '\\App\\wysiwygEditors_Profiles');
    class_alias('\\App\\Core_EditorManager', '\\App\\wysiwygEditors');
    

    $__timezone = (defined('SCHLIX_SYSTEM_TIMEZONE') && SCHLIX_SYSTEM_TIMEZONE != '') ? SCHLIX_SYSTEM_TIMEZONE : 'GMT';
    date_default_timezone_set($__timezone);
    $CurrentPage = filter_input(INPUT_SERVER, 'PHP_SELF', FILTER_SANITIZE_URL);
    
    $SystemDB	=  \SCHLIX\cmsDatabase::genericInit();

    $SystemConfig = new \SCHLIX\cmsConfigRegistry('gk_config');
    $SystemLog = new \Schlix\cmsLogger('gk_log_items');
    
    /** PHP 8.4 fixes **/
    $SchlixSessionHandler = new \SCHLIX\cmsSessionHandler();    
    $save_handler_result = session_set_save_handler( $SchlixSessionHandler);
    if (!$save_handler_result)
            die('Failure when calling session_set_save_handler() ');
    $SchlixSessionHandler->start();    
    /** end PHP 8.4 fixes **/
    $SystemDB->query("SET SQL_MODE=''");
    //$SystemDB->query("SET SQL_MODE='STRICT_TRANS_TABLES'");
    $app_core = new \App\Core(); // dont remove this line as it contains backward compatibility for class_alias
    // removed - 2021-Jan-10
    // $SystemCustomField = new \App\Core_CustomField();
    
    // 1. Cache table names
    $result = $SystemDB->getQueryResultArray( "SHOW TABLES");
    $all_tables = array_map('array_values', $result);    
    foreach ($all_tables as $tbl)
        \SCHLIX\cmsContextCache::set('db_table_exists', $tbl[0], 1);
    // 2. Cache application alias
    $sql = "SELECT title, app_alias, app_description FROM gk_app_items";
    $app_info = $SystemDB->getQueryResultArray($sql);
    foreach ($app_info as $info)
    {
        \SCHLIX\cmsContextCache::set('app_alias', $info['title'], $info['app_alias']);
        \SCHLIX\cmsContextCache::set('app_description', $info['title'], $info['app_description']);
    }    
    
    // 3. Cache table columns
    $__schlix_table_columns = SCHLIX\cmsDBCache::get('table_columns');        
    $__schlix_table_pks = SCHLIX\cmsDBCache::get('table_pks');
    if ($__schlix_table_columns == null || $__schlix_table_pks == null )
    {
        $__schlix_table_columns = array();
        $__schlix_table_pks = array();
        foreach ($all_tables as $tbl)
        {
            $ticked_table_name = "`{$tbl[0]}`";
            $sql = "SHOW COLUMNS FROM {$ticked_table_name}";
            $result = $SystemDB->getQueryResultArray($sql);
            $__schlix_table_columns[$tbl[0]] = array_column($result,'Field');        
            
            $sql = "SHOW KEYS FROM {$ticked_table_name} WHERE key_name = 'PRIMARY'";
            $result = $SystemDB->getQueryResultArray($sql);
            $__schlix_table_pks[$tbl[0]] = array_column($result,'Column_name');        
        }
        \SCHLIX\cmsDBCache::set('table_columns', $__schlix_table_columns,0,5,0); // set for 5 minutes
        \SCHLIX\cmsDBCache::set('table_pks', $__schlix_table_pks,0,5,0); // set for 5 minutes
        
    }  
    // setup versioning (for later version - frontend editing)
    $Versioning = new App\Core_Versioning();
    // setup tagging (for later version - frontend editing)
    $TagManager = new App\Tag();    
}
 
/**
 * Returns true if current request is through SSL, whether it is through a proxy load balancer or not
 * @return boolean
 */
function isCurrentRequestSSL()
{
    return ( (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || 
         (!empty( $_SERVER['HTTP_X_FORWARDED_PROTO'] ) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' )
       );
}
/**
 * Verify the subsites configuration
 * @global array $SchlixWebsites
 * @global String $CurrentSubSite
 */
function verifySchlixSubsites()
{
    global $SchlixWebsites, $CurrentSubSite;


    $_site_request = strip_tags($_SERVER['HTTP_HOST']);
    $_pport = strpos($_site_request, ':');
    if ($_pport > 0) {
        $_site_request = substr($_site_request, 0, $_pport);
    }
// The HTTP_HOST is obtained from the HTTP request header and this is what the client actually used as "target host" of the request.
    if (array_key_exists($_site_request, $SchlixWebsites)) {
        $CurrentSubSite = $SchlixWebsites[$_site_request];
    } else {
        if (array_key_exists('*', $SchlixWebsites)) {
            $CurrentSubSite = $SchlixWebsites['*'];
        } else {
            // $_SERVER['HTTP_HOST'] has already been validated earlier with $_SERVER['HTTP_HOST'] = strip_tags($_SERVER['HTTP_HOST']);
            $SiteRequestAttempt = (isCurrentRequestSSL() ? 'https' : 'http') . '://' . $_site_request . (($_SERVER['SERVER_PORT'] != 80 && $_SERVER['SERVER_PORT'] != 443) ? ':' . $_SERVER['SERVER_PORT'] : '');
            die('There is no website configured at this address: ' . $SiteRequestAttempt);
        }
    }
    define('CURRENT_SUBSITE_NAME', '' . $CurrentSubSite);
}




//______________________________________________________________________________________//

function _schlix_exception_handler($exc)
{
    if (!headers_sent()) header('HTTP/1.1 500 Internal Server Error');    
    if (ob_get_contents())  ob_end_clean();
    $err_msg = "Uncaught exception has been detected: ".$exc->getMessage().' on '.$exc->getFile().' line '.$exc->getLine()."\n";
    echo $err_msg;
    error_log($err_msg);
    exit(-5);
}

/**
 * SCHLIX Error Handler
 * @param type $type
 * @param string $message
 * @param string $file
 * @param int $line
 * @return boolean
 */

function _schlix_main_error_handler($type, $message, $file, $line)
{
    
    $_ERRORS = array(
        E_ERROR => 'Error', // E_ERROR
        E_WARNING => 'Warning', // E_WARNING
        E_PARSE => 'Parse error', // E_PARSE
        E_NOTICE => 'Notice', // E_NOTICE
        E_CORE_ERROR => 'Core error', // E_CORE_ERROR
        E_CORE_WARNING => 'Core warning', // E_CORE_WARNING
        E_COMPILE_ERROR => 'Compile error', // E_COMPILE_ERROR
        E_COMPILE_WARNING => 'Compiler warning', // E_COMPILE_WARNING
        E_USER_ERROR => 'User-defined error', // E_USER_ERROR
        E_USER_WARNING => 'User-defined warning', // E_USER_WARNING
        E_USER_NOTICE => 'User-defined notice', // E_USER_NOTICE
//        E_STRICT => 'Strict PHP', // E_STRICT - deprectated in PHP 8.4
        E_RECOVERABLE_ERROR => 'Recoverable Error', // E_RECOVERABLE_ERROR
        E_DEPRECATED => 'Deprecated', // E_DEPRECATED
        E_USER_DEPRECATED => 'User-defined deprecation' // E_USER_DEPRECATED
    );

    if ( ($type != E_ERROR) && ($type != E_COMPILE_ERROR) && ($type != E_PARSE) && (($type === E_NOTICE) || !(error_reporting() & $type))) return;
     
    
    if (!@is_string($name = @array_search($type, @array_flip($_ERRORS)))) {
        $name = 'E_UNKNOWN';
    }
    
    $is_ajax = false;
    if (isset($_SERVER['HTTP_USER_AGENT']))
    {
        //if (is_ajax_request()) 2017 Sept 12 - In case the error happens before it is initialized
        $is_ajax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');
        if ($is_ajax)
        {
            // 2023-11-16 - Fix for PHP 8.2 ...
            require_once (SCHLIX_ROOT_PATH.'/system/libs/schlix/util.inc.php');
            $err_format = ajax_reply (500, "%s in [%s] at [line %d]: %s");
        }
            else
        $err_format = '<div style="background:pink;padding:3px">%s in <strong>%s</strong> at <strong>line %d</strong>: <span style="color:red">%s</span></div><br />';
    } else
    {
        $err_format = "%s in [%s] at [line %d]: %s\n";
    } 
    if ($is_ajax)
        $message = addslashes ($message);
    print(@sprintf($err_format, $name, @basename($file), $line, $message));
  
    if ($is_ajax && $type == E_WARNING)
        exit(1);
    return true;
}


function schlix_shutdown_handler()
{
    if (is_array($error = error_get_last())) {

        return(call_user_func_array('_schlix_main_error_handler', $error));
    }

    return(TRUE);
} 


/**
 * This is the autoloader for Schlix as of June 2013.
 *
 * @param string $class
 */
function _schlix_get_classes_to_load($class)
{
    $class_filenames = [];
    
    $valid_schlix_namespaces = array('app','block','macro','wysiwygeditor','skin');
    $possibilities = array (SCHLIX_SITE_PATH, SCHLIX_SYSTEM_PATH);
    $class = ltrim($class, '\\');    
    $alternative_class_file_name = null;
    // if using namespace then it can be an App, Block, or Filter (or Libs)
    $shared_lib_file = null;
    if (strpos($class, '\\'))
    {
        $last_ns_pos = strrpos($class, '\\');
        $namespace = substr($class, 0, $last_ns_pos);
        $class_name_only = substr($class, $last_ns_pos + 1);
        
        $lowered_namespace =  strtolower($namespace);
        $main_directory =  $lowered_namespace.'s';
        $desired_file = str_replace(array('\\', '_'),array( '/','.'), strtolower($class_name_only));
        $parts = explode('.', $desired_file);
        $class_directory = $parts[0];
        $alternative_class_file_name = '';
        if (in_array($lowered_namespace, $valid_schlix_namespaces) && is_dir(SCHLIX_SYSTEM_PATH.'/'.$main_directory))
        {
            if ($lowered_namespace === 'app')
            {
                if (strpos($desired_file,'.') !== FALSE)
                {
                    
                    $arr_classes = explode('.',$desired_file);
                    $count_classes = ___c($arr_classes);
                    $valid_count_classes =  ($arr_classes[$count_classes-1] != 'admin')  ? $count_classes : $count_classes - 1;
                    if ($valid_count_classes == 2)
                    {
                        $alternative_class_file_name = "/{$main_directory}/{$class_directory}/{$arr_classes[1]}/{$desired_file}.class.php" ;
                    }
                    $shared_lib_file = "/{$main_directory}/{$class_directory}/{$arr_classes[0]}.shared.library.php" ;
                }                 
            }
            $default_class_file_name = "/{$main_directory}/{$class_directory}/{$desired_file}.class.php" ;
            
            
        } else
        {
            $last_fns_pos = strpos($lowered_namespace, '\\');
            if ($last_fns_pos > 0)
                $lowered_namespace = substr($lowered_namespace, 0, $last_fns_pos);
            $default_class_file_name = str_replace('\\','/',"/libs/{$lowered_namespace}/{$class_name_only}.php");
            $alternative_class_file_name = str_replace('\\','/',"/libs/{$lowered_namespace}/__load__.php");
            
        }
    } else // if there's no namespace
    {
            $class_name_only = strtolower($class);
            $default_class_file_name =  '/libs/' . $class_name_only . '/' . $class_name_only . '.class.php';
    } 
    // Now begin loading
    foreach ($possibilities as $possible_dir)
    {
        $possible_class_file = $possible_dir.$default_class_file_name;
        if ($alternative_class_file_name)
        {
            $possible_alternative_class_file = $possible_dir.$alternative_class_file_name;
            if (is_readable($possible_alternative_class_file)) {             
                if ($shared_lib_file && file_exists($possible_dir.$shared_lib_file))
                {
                    $class_filenames[] = $possible_dir.$shared_lib_file ;
                }
                $class_filenames[] = $possible_alternative_class_file;
                return $class_filenames;
            }
            
        }
        if (is_readable($possible_class_file)) {
            $class_filenames[] = $possible_class_file;
            if ($shared_lib_file && file_exists($possible_dir.$shared_lib_file))
            {
                $class_filenames[] = $possible_dir.$shared_lib_file ;
            }            
            return $class_filenames;
        }
    }  
    
    return null;
    
}

/**
 * This is the autoloader for Schlix as of June 2013.
 *
 * @param string $class
 */
function schlix_autoloader($class)
{
    $class_filenames = _schlix_get_classes_to_load($class);
    
    if (___c($class_filenames) > 0) 
    {
        foreach ($class_filenames as $class)
        {
            require_once ($class);
        }
    } 
}
