<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
global $SystemConfig, $CurrentUser, $SchlixSupportedLanguages;

$app_list = $this->getListofApplications();
$main_frontend_app = $SystemConfig->get('system', 'str_main_app');
if (empty($main_frontend_app))
    $main_frontend_app = 'html';
$forbidden_frontend = ['cronscheduler', 'wysiwygeditors', 'core', 'personaldatarequest', 'tag', 'contacts', 'mediamanager','users','tagmanager'];

$languages = array();

$skin_list = get_all_skin_modules();
?> 

<schlix-config:data-editor  data-main-app-description="<?= ___('Global Configuration') ?>"  data-schlix-controller="SCHLIX.CMS.AdminAdmin">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" admin-action="saveglobalconfig" action="<?= $this->createFriendlyAdminURL('action=saveglobalconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                    <!--content -->
                    <x-ui:row>
                        <x-ui:column sm="6">
                    <schlix-config:textbox config-key='str_site_name' config-default-value="<?= ___h(SCHLIX_SITE_NAME) ?>"   config-fonticon="fas fa-university" label="<?= ___('Site Name') ?>" />
                    
                    <schlix-config:dropdownlist   config-key="int_search_engine_hidden" config-fonticon="fas fa-search-location" label="<?= ___('Search engine visibility') ?>">
                        <schlix-config:option value="0"><?= ___('Visible') ?> (<?= ___('default') ?>)</schlix-config:option>
                        <schlix-config:option value="-2"><?= ___('Hidden') ?> </schlix-config:option>
                    </schlix-config:dropdownlist>
                    <p><em><?= ___('For best result, consider submitting your sitemp to the search engine. Check the sitemap URL from Tools - Site Map.') ?> <?= ___('If you would like to set your website to offline for maintenance, go to Settings - Site Manager.') ?></em></p>
                    <schlix-config:dropdownlist   config-key="str_interface_language" config-fonticon="fas fa-language" label="<?= ___('Language') ?> (<?= ___('BETA') ?>)">
                        <schlix-config:option value="en_us"><?= ___('English') ?> (<?= ___('default') ?>)</schlix-config:option>
                        <?php foreach ($SchlixSupportedLanguages as $lang => $desc): ?>
                            <schlix-config:option value="<?= $lang ?>"><?= $desc ?> </schlix-config:option>
                        <?php endforeach ?>
                    </schlix-config:dropdownlist>
                    <p id="schlix-downloadlang-notice"></p>

                    <!-- note -->
                    <p><em><?= ___('When you change the language, SCHLIX CMS will attempt to download the system language pack if it has not been installed. Installation may take up to 1 minute.') ?></em></p>
                    <schlix-config:dropdownlist   config-key="str_main_app" config-fonticon="fas fa-puzzle-piece" label="<?= ___('Main application for the frontpage') ?>">
                        <schlix-config:option value="">(<?= ___('Default') ?>)</schlix-config:option>
                        <?php foreach ($app_list as $app_info): ?>
                            <?php if (!in_array($app_info['value'], $forbidden_frontend)): ?>
                                <schlix-config:option value="<?= $app_info['value'] ?>"><?= ___h($app_info['label']) ?> </schlix-config:option>
                            <?php endif ?>
                        <?php endforeach ?>
                    </schlix-config:dropdownlist>

                    <!-- note -->                    
                    <p><em><?= ___('You can change which application to be called when the homepage is called. You can use this feature to mimic other software, e.g. blog in the front page. The standard and the recommended one is Web Pages (html).') ?></em></p>
                    <!-- row -->
                        <schlix-config:dropdownlist   config-key="int_system_update_frequency" config-fonticon="far fa-clock" label="<?= ___('System update check frequency') ?>" >
                            <schlix-config:option value=""><?= ___('(Default - 3 days)') ?> </schlix-config:option>
                            <schlix-config:option value="7"><?= ___('Every week') ?> </schlix-config:option>
                            <schlix-config:option value="14"><?= ___('Every two weeks') ?> </schlix-config:option>
                            <schlix-config:option value="30"><?= ___('Once a month') ?> </schlix-config:option>
                            <schlix-config:option value="180"><?= ___('Every 6 months') ?> </schlix-config:option>
                        </schlix-config:dropdownlist>

                    
                            
                        </x-ui:column>
                        <x-ui:column md="6">
                            
                            <schlix-config:dropdownlist  config-fonticon="fas fa-desktop"  config-key="str_frontend_skin" label="<?= ___('Frontend CSS framework') ?>" required="required" >
                                
                                <?php foreach ($skin_list as $skin): ?>
                                    <schlix-config:option value="<?= ___h($skin) ?>"><?= ___h($skin) ?></schlix-config:option>
                                <?php endforeach ?>
                            </schlix-config:dropdownlist>
                            
                            <schlix-config:dropdownlist   config-key="str_admin_colors" config-fonticon="fas fa-palette" label="<?= ___('Colour scheme for the default theme') ?>" >
                                <schlix-config:option value=""><?= ___('(Default - Purplish Blue)') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-greenish"><?= ___('Greenish') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-orange-red"><?= ___('Orange Red') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-cotton-candy"><?= ___('Cotton Candy') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-blue"><?= ___('Blue') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-blue-green"><?= ___('Bluish Green') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-light-blue"><?= ___('Light Blue') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-purple-orange"><?= ___('Purple Orange') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-chocolate"><?= ___('Chocolate') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-black"><?= ___('Black') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-pink"><?= ___('Pink') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-mango"><?= ___('Mango') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-red-blue"><?= ___('Red and Blue') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-light-rainbow"><?= ___('Light Rainbow') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-lime"><?= ___('Lime') ?> </schlix-config:option>
                                <schlix-config:option value="bg-schlix-peach"><?= ___('Peach') ?> </schlix-config:option>
                                

                            </schlix-config:dropdownlist>
                            
                        </x-ui:column>
                    </x-ui:row>
                    

                    
                    <!-- end content -->
                </x-ui:schlix-tab>
                <x-ui:schlix-tab id="tab_advanced" fonticon="fas fa-screwdriver" label="<?= ___('Advanced') ?>"> 
                    <h3><?= ___('Maintenance tools') ?></h3>
                    <x-ui:button button-type="default" type="button" id="btn-refresh-all-hooks" label="<?= ___('Refresh all hooks') ?>" fonticon="fas fa-swatchbook" />
                    
                    <x-ui:button button-type="default" type="button" id="btn-clear-cache" label="<?= ___('Clear all cache') ?>" fonticon="fas fa-swatchbook" />
                    
                    <x-ui:button button-type="default" type="button" id="btn-clear-sessions" label="<?= ___('Clear all sessions') ?>" fonticon="fas fa-swatchbook" />
                    
                    <x-ui:button button-type="default" type="button" id="btn-regenerate-all-tags" label="<?= ___('Regenerate all tags') ?>" fonticon="fas fa-swatchbook" />
                    <!--content -->
                </x-ui:schlix-tab>
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>  
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>     