//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

/**
 * View Controller class
 */
SCHLIX.CMS.BlogAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("blog");
    };
    
    static formatGallery (elCell, r, datatable) 
    {
        return SCHLIX.CMS.__default_formatGallery(elCell, r, datatable, 'title', 'file_exists', 'url_image_small'); 
    };
    /**
     * Datatable row format: item title
     * @static
     * @param {object} elCell
     * @param {object} oRecord
     * @param {object} oColumn
     * @param {object} oData
     * @param {object} oDataTable
     * @returns {void}
     */
    static formatDataTableCell_TitleWithImage (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var odata_ext = oRecord.getData("extension");
        var file_exists = oRecord.getData("file_exists");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';

        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            var icon = (file_exists == 'true' || file_exists == true) ?  '<img src="' + oRecord.getData('url_image_small') + '" /><br />' : '<i class="far fa-newspaper fa-2x"></i> ';

            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class =  'dragdrop';
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            
            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>';

        }
    };

    getOriginalPrimaryCategoryID()
    {
        var original_primary_category_id = SCHLIX.Dom.get('original_primary_category_id');
        if (!original_primary_category_id)
        {
            SCHLIX.Alert.error('Original primary category ID was not specified in the form');
            return 0;
        } else 
        {
            var original_primary_category_id_value = parseInt(original_primary_category_id.value, 10);
            return original_primary_category_id_value;            
        }
    };
    
    getNumberofAssociatedCategories()
    {
        var checkboxes = SCHLIX.Dom.get('{.chk_category_assoc}');
        var count_enabled_categories = 0;
        
        if (checkboxes.length > 0)
        {
            for (var i = 0;i < checkboxes.length;i++)
            {
                if (checkboxes[i].checked)
                {
                    count_enabled_categories++;
                }
            }
        }
        return count_enabled_categories;
    };
    
    determinePrimaryCategories(evt)
    {
        var count_enabled_categories = 0;
        var last_enabled_category_id = 0;
        var original_primary_category_id_value = this.getOriginalPrimaryCategoryID();
        var id = "schlix-" + this.app_name + "-edit-categories-associations";
        var checkboxes = SCHLIX.Dom.get('{.chk_category_assoc}');
        var arr_chk_values = [];
        var arr_opt_values = [];
        var previously_checked_radiobox_value = 0;
        if (checkboxes.length > 0)
        {
            for (var i = 0;i < checkboxes.length;i++)
            {
                var value = checkboxes[i].value;
                var radiobox = SCHLIX.Dom.get('__radio_category_id_' + value);
                if (radiobox)
                {
                    var is_checked = checkboxes[i].checked;
                    arr_chk_values[value] = is_checked;
                    arr_opt_values[value] = radiobox.checked;
                    if (radiobox.checked)
                        previously_checked_radiobox_value = value;
                    if (is_checked)
                    {
                        count_enabled_categories++;
                        last_enabled_category_id = value;
                        radiobox.style = 'display:inline';
                        radiobox.disabled = false;
                    } else
                    {
                        radiobox.style = 'display:none';
                        radiobox.checked = false;
                        radiobox.disabled = true;
                    }
                    
                }
            }
            if (count_enabled_categories === 1)
            {
                var radiobox = SCHLIX.Dom.get('__radio_category_id_' + last_enabled_category_id);                
                radiobox.checked=  true;
            } 
            else if (count_enabled_categories > 1)
            {
                if (!arr_chk_values[previously_checked_radiobox_value])
                {
                    var radiobox = SCHLIX.Dom.get('__radio_category_id_' + last_enabled_category_id);                
                    if (last_enabled_category_id > 0)
                        radiobox.checked=  true;
                }
            }
        } else
        {
            SCHLIX.Alert.error('Cannot find category association checkboxes in the form');
        }
        if (SCHLIX.Dom.get(id))
        {
            var checkboxes = SCHLIX.Dom.get('{#' +id  + ' input}');
            //console.log(checkboxes);
        }
    };
    
    onDOMReady (event)
    {
    //    SCHLIX.Event.on('filedata', 'change', this.updateFileListToUpload, this, true);
    
        var id_category_assoc = "schlix-" + this.app_name + "-edit-categories-associations";
    
        if (SCHLIX.Dom.get('schlix-non-ajax-category-edit'))
        {
            SCHLIX.Event.delegate( id_category_assoc , 'click', this.determinePrimaryCategories, 'input[type="checkbox"]', this, true);
            var original_prim_cat_id = this.getOriginalPrimaryCategoryID();
            if (original_prim_cat_id)
            {
                SCHLIX.Event.onAvailable('chk_document_status___category_id_' + original_prim_cat_id, this.determinePrimaryCategories, this ,true);
            } else
            {
                var radioboxes = SCHLIX.Dom.get('{.schlix-primary-category-radiobox}');
                for (var i = 0; i < radioboxes.length;i++)
                {
                    radioboxes.style = 'display:none';
                }
            }
        }
        //this.determinePrimaryCategories(null);
    }; // end func

    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory");
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;                
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                return true;
                break;
            case "apply-item":
            case "save-item":         
                if (SCHLIX.Dom.get('schlix-non-ajax-category-edit'))
                {
                    if (this.getNumberofAssociatedCategories() === 0)
                    {
                        var a_meta = SCHLIX.Dom.get('{a[href="#tab_meta"]}');
                        if (a_meta && a_meta.length > 0)
                        {
                            a_meta[0].click();
                        }
                            
                        SCHLIX.Alert.error('Please select at least one category');
                        return false;
                    } else
                    {
                        return super.runCommand(command, evt);
                    }
                } else return super.runCommand(command, evt);
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
        //alert("Received Command: " + command);
    };
};