<?php
/**
 * Blog - Edit Form: Item
 * 
 * @copyright (C)  SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

global $CurrentUser;
if ($id == 'new') {
    $item['permission_read'] = serialize('everyone');
    $header_title = ___('New Post');
} else {
    $id = (int) $id;
    $header_title = ___('Edit Post') . ' #' . ___h($id);
}


$max_upload_size = get_real_max_upload_size() / (1024 * 1024);
$ds = $this->app->getDefaultSizes();
$preview_width = (int) $this->app->getConfig("int_medium_width", $ds['medium']['width']);
$preview_height = (int) $this->app->getConfig("int_medium_height", $ds['medium']['height']);
?>


<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.BlogAdmin" data-type-desc="<?= ___('post') ?>">    

    <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">

        <x-ui:csrf id="_csrftoken" />
        <x-ui:hidden id="id" name="id" data-field="id" />
        <x-ui:hidden id="category_id" data-field="category_id" name="category_id" />
        <x-ui:hidden id="guid" data-field="guid" name="guid" />
        <x-ui:schlix-editor-top-row>    
            <x-ui:schlix-editor-top-left>
                <!-- Page Title -->
                <x-ui:schlix-document-title id="title" maxlength="191"  required="required"   data-field="title" table-type="item" />
                <!-- Virtual Filename -->
                <x-ui:schlix-document-virtual-filename id="virtual_filename" data-field="virtual_filename" name="virtual_filename" full-url="1" />

            </x-ui:schlix-editor-top-left>
            <x-ui:schlix-editor-top-right>
                <x-ui:schlix-editor-action-buttons />
            </x-ui:schlix-editor-top-right>            
        </x-ui:schlix-editor-top-row>

        <!-- main -->
        <x-ui:clearboth />

        <x-ui:schlix-document-save-result />
        <!-- end main section -->
        <strong><?= ___('Note') ?>:</strong>
        <em><?= sprintf(___('Your server max upload size: %dMb. To change this value, please contact the server admin and set it in php.ini (upload_max_filesize, post_max_size, memory_limit).'), $max_upload_size) ?></em><br />
        <!-- begin tabs -->
        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_summary" fonticon="far fa-file-alt" label="<?= ___('Summary/Intro') ?>"> 
                <x-ui:wysiwyg id="summary" name="summary" data-field="summary" label="<?= ___('Summary') ?>" />
                <x-ui:clearboth />
                <!-- secondary headline -->
                <x-ui:row>
                    <x-ui:column  md="5">
                        <h3><i class="far fa-image"></i> <?= ___('Intro image') ?></h3>
                        <p><?= ___('The first image of the article to be displayed on the list view as a thumbnail and/or as the first image in the detail view. If you want the image not to be displayed on the list view, simply insert the image to the WYSIWYG editor only. Uploaded image will be resized automatically') ?></p>
                        <?php /*<x-ui:schlix-document-image-uploader label="<?= ___("Select a new intro Image") ?>" fonticon="far fa-image" name="summary_intro_image" id="summary_intro_image" data-field="summary_intro_image" data-dir-key="image_medium" />*/?>
                     <x-ui:schlix-multi-source-media-uploader data-field="summary_intro_image" name="summary_intro_image" id="summary_intro_image" data-dir-key="image_medium" accept="image/png, image/jpeg, image/gif" data-disable-option-existing-file="true" data-disable-option-none="true" data-allow-url-variable-dimension="true" data-preview-width="<?= $preview_width ?>" data-preview-height="<?= $preview_height ?>" />
                    
                     <p><?= sprintf(___('(Optional) You can specify the dimension of the image as %s and %s as variables in the URL. For example'),'<strong>{$width}</strong>','<strong>{$height}</strong>') ?>:</p>                     
                     <ul>
                         <li>https://via.placeholder.com/{$width}x{$height}</li>
                         <li>https://placeimg.com/{$width}/{$height}/arch</li>
                         <li>https://picsum.photos/{$width}/{$height}</li>
                     </ul>
                        
                        <x-ui:clearboth />

                        <x-ui:textbox name="summary_intro_image_caption" maxlength="4096" id="summary_intro_image_caption" label="<?= ___('Caption for intro image'); ?>" placeholder="<?= ___('Copyright (C) ....'); ?>" />
                    </x-ui:column>
                    <x-ui:column  md="7">

                        <h3><i class="fa fa-align-center"></i> <?= ___('Optional Secondary Headline') ?></h3>
                        <x-ui:wysiwyg name="summary_secondary_headline" id="summary_secondary_headline" data-field="summary_secondary_headline" label="<?= ___('Optional Secondary Headline') ?>" />
                    </x-ui:column>
                </x-ui:row>


            </x-ui:schlix-tab>

            <!-- tab -->
            <x-ui:schlix-tab id="tab_description" fonticon="far fa-file-alt" label="<?= ___('Description/Detail') ?>"> 


                <x-ui:textbox name="description_alternative_title" id="description_alternative_title" data-field="description_alternative_title" label="<?= ___('Alternative Page Title'); ?>" placeholder="<?= ___('Optional alternative page title to be shown in detail view') ?>" />


                <!-- description -->
                <x-ui:wysiwyg id="description" name="description" data-field="description" label="<?= ___('Description') ?>" />
                <!-- end description -->
                <!-- end secondary headline -->                                                

                <x-ui:row>
                    <x-ui:column  md="5">


                        <!-- image -->

                        <h3><i class="far fa-image"></i> <?= ___('Alternative intro image') ?></h3>
                        <p><?= ___('If specified, the alternative intro image will be shown in the detail view.') ?></p>
                        <?php /*<x-ui:schlix-document-image-uploader label="<?= ___("Select a new alternative intro image") ?>" fonticon="far fa-image" name="description_intro_image" id="description_intro_image" data-field="description_intro_image" data-dir-key="image_medium" />*/ ?>
                     <x-ui:schlix-multi-source-media-uploader data-field="description_intro_image" name="description_intro_image" id="description_intro_image" data-dir-key="image_medium" accept="image/png, image/jpeg, image/gif" data-disable-option-existing-file="true" data-disable-option-none="true" data-allow-url-variable-dimension="true" data-preview-width="<?= $preview_width ?>" data-preview-height="<?= $preview_height ?>" />
                    
                     <p><?= sprintf(___('(Optional) You can specify the dimension of the image as %s and %s as variables in the URL. For example'),'<strong>{$width}</strong>','<strong>{$height}</strong>') ?>:</p>                     
                     <ul>
                         <li>https://via.placeholder.com/{$width}x{$height}</li>
                         <li>https://placeimg.com/{$width}/{$height}/arch</li>
                         <li>https://picsum.photos/{$width}/{$height}</li>
                     </ul>

                        <!-- image caption -->
                        <x-ui:textbox name="description_intro_image_caption" maxlength="4096" id="description_intro_image_caption" label="<?= ___('Caption for alternative intro image'); ?>" placeholder="<?= ___('Copyright (C) ....'); ?>" />

                        <h3><i class="fa fa-code"></i> <?= ___('Alternative custom code') ?></h3>
                        <p><?= ___('As an alternative, you can copy and paste custom HTML, CSS, and Javascript code in here for more advanced functionality in detail view. e.g. video, custom animation, etc.') ?></p>
                        <x-ui:textarea name="description_custom_html_code" id="description_custom_html_code" data-field="description_custom_html_code" rows="10" />


                    </x-ui:column>
                    <x-ui:column  md="7">

                        <!-- secondary headline -->     
                        <h3><i class="fa fa-align-center"></i> <?= ___('Alternative Secondary Headline') ?></h3>
                        <x-ui:wysiwyg name="description_secondary_headline" id="description_secondary_headline" data-field="description_secondary_headline"  />

                    </x-ui:column>
                </x-ui:row>



            </x-ui:schlix-tab>
            <!-- tab -->

            <x-ui:schlix-tab id="tab_meta" fonticon="fa fa-hashtag" label="<?= ___('Meta and Categories') ?>">    
                <!-- row -->
                <x-ui:row sm="6">
                    <!-- column -->
                    <x-ui:column md="6">

                        <x-ui:schlix-document-multi-category-selector enable-primary-category="true" name="original_primary_category_id" id="original_primary_category_id" data-field="original_primary_category_id" label="<?= ___('Categories') ?>" help-text="<?= ___('Please select at least one category and then select the primary category to determine the canonical URL of this post') ?>" primary-category-text="<?= ___('Primary Category') ?>" /> 

                    </x-ui:column>
                    <!-- column -->
                    <x-ui:column md="6">
                        <x-ui:textbox id="meta_description" name="meta_description"  data-field="meta_description" label="<?= ___('Meta Description') ?>" />
                        <x-ui:textbox id="meta_key" name="meta_key" data-field="meta_key" label="<?= ___('Meta Keywords') ?>" />
                        <x-ui:tagbox id="tags" name="tags" data-field="tags" label="<?= ___('Tags') ?>" />

                    </x-ui:column>
                </x-ui:row>
            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 

                <x-ui:schlix-datetime-picker id="date_created" name="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                <x-ui:schlix-datetime-picker id="date_modified" name="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                <x-ui:schlix-datetime-picker id="date_available" name="date_available" data-field="date_available" label="<?= ___('Available on') ?>" />
                <x-ui:schlix-datetime-picker id="date_expiry" name="date_expiry" data-field="date_expiry" label="<?= ___('Expiry') ?>" />

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_options" fonticon="fa fa-sliders-h" label="<?= ___('Options') ?>">
                <x-ui:schlix-editor-item-meta-options name="options" data-field="options" max-item-per-column="1" column="3" />
            </x-ui:schlix-tab>
            <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
        </x-ui:schlix-tab-container>            
        <!-- end tabs -->
    </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor>
