<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
	if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php 
    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-<?= $category[$field_cid]; ?>" >   
    <?= isset($category['macro_processed_text_outside_article_top']) ?  $category['macro_processed_text_outside_article_top'] : null ?>
    <!-- ########################################################################### -->
    <!-- ####################### main info of this category  ####################### -->
    <!-- ########################################################################### -->
    <article class="main category">
	<?php if ($category_meta_options['display_pagetitle']): ?>
            <h1 class="category title"><?= ___h($category['title']); ?></h1>
        <?php endif; ?>
        <?php if ($category['macro_processed_text_before_article']): ?>        
        <!-- Macro - Pre -->            
            <div class="meta before-article">        
            <?= $category['macro_processed_text_before_article'] ?>            
            </div>
        <!-- End Macro - Pre -->        
        <?php endif ?>
        <div class="text">
            <?= $category['summary'].$category['description'] ?>
        </div>
        <?php if (isset($category['macro_processed_text_after_article'])): ?>
        <!-- Macro - Post -->                
            <div class="meta after-article">
                <?= $category['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
        <!-- End Macro - Post -->                
    </article>
    <!-- ########################################################################### -->
    <!-- ######################## end info of this category  ####################### -->
    <!-- ########################################################################### -->

    <?php if ($child_categories && $category_meta_options['display_child_categories']): ?>
    <!-- ########################################################################### -->
    <!-- ################## child categories / subfolder ########################### -->
    <!-- ########################################################################### -->
        <div class="category child categories">
            <?php foreach ($child_categories as $child_category): ?>
                <?php if ($child_category['status'] > 0): ?>            
                <section class="child-category">
                    <?= isset($child_category['macro_processed_text_outside_article_top']) ? $child_category['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_category_id = $child_category[$field_cid];
                        $this->processDataOutputWithMacro($child_category, 'viewChildCategory', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$child_category_id}");
                        $child_category_title = ___h($child_category['title']);
                        $child_category_title_text = ($child_category!= null) && ($category_meta_options['display_child_category_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_category_title,$link) : $child_category_title;
                        
                    ?>
                    <?php if ($child_category_title_text): ?>
                        <h2 class="category title"><i class="fas fa-folder"></i> <?= $child_category_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_child_category_summary']): ?>
                        <div class="text">
                            <?= $child_category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if ($child_category['macro_processed_text_after_article']): ?>                
                        <div class="meta after-article">
                            <?= $child_category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->                
                    <?= $child_category['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ########################################################################### -->
    <!-- ################## end child categories / subfolder ####################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>

    <?php if ($items && $category_meta_options['display_items']):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="category child items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item" itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>">    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_item_id = $child_item[$field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        // force CID
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}&cid={$category[$this->field_category_id]}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                      
                        $image_size = $category_meta_options['image_display_size'] ? 'image_medium' : 'image_small';
 

                        $continue_reading = ' <i class="fa fa-arrow-circle-right"></i> '.___('Continue Reading');
                        $continue_reading_link = __HTML::A($continue_reading,$link)
                        
                    ?>

                    <div class="row">
                        <div class="col-sm-12">
                            <?php if ($child_item_title_text): ?>
                                <h2 class="item title" itemprop="headline"><?= $child_item_title_text; ?></h2>
                            <?php endif ?>                            
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4">
                            <!-- intro image -->
                            <?php $intro_img_src = $this->getBlogImage($image_size, $child_item['summary_intro_image']); ?>
                            <?php if ($category_meta_options['display_summary_intro_image'] && $intro_img_src): ?>
                                <div class="intro-image">
                                    <figure>
                                      <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $intro_img_src ?>" alt="<?= ___h($child_item['summary_intro_image_caption']) ?>"></a>
                                      <?php if ($category_meta_options['display_item_summary_intro_image_caption'] && $child_item['summary_intro_image_caption']): ?>
                                      <div class="intro-image"><?= $child_item['summary_intro_image_caption'] ?></div>
                                      <?php endif ?>
                                    </figure>                                             
                                </div>
                            <?php endif ?>                    
                            <!-- end intro image -->
                        </div>
                        <!-- columns -->
                        <div class="col-sm-8">
                            <?php if ($category_meta_options['display_summary_secondary_headline'] && $child_item['summary_secondary_headline']): ?>
                                <div class="secondary-headline">
                                    <?=  $child_item['summary_secondary_headline'] ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- summary -->
                            <?php if ($category_meta_options['display_item_summary'] && $child_item['summary']): ?>
                                <div class="secondary-headline">
                                    <?=  $child_item['summary'].$continue_reading_link ?>
                                </div>
                            <?php endif; ?>
                            
                            
                        </div>                    
                    </div>
                    <!-- move it to below summary -->
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->
                    
                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->     
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>

                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    <!-- pagination -->
    
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$category['cid']}"); ?>    
    <?php if ($pagination_str && ($category_meta_options['display_child_categories'] || $category_meta_options['display_items'])): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>