<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');

global $TagManager;
global $HTMLHeader;


?>

<div class="app-page-item app-<?= $this->app_name; ?>" >
    <?= isset($item['macro_processed_text_outside_article_top']) ? $item['macro_processed_text_outside_article_top'] : null ?>
    <article class="item" id="app-<?= $this->app_name; ?>-item-<?= $item[$this->field_id]; ?>">
        <!-- Page Title -->
        <?php if ($item_meta_options['display_pagetitle']): ?>
            <h1 class="item title" itemprop="headline"><?= ___h($item['title']); ?></h1>
        <?php endif; ?>
        <!-- End Page Title -->
        <?php if ($item_meta_options['display_description_secondary_headline'] && $secondary_headline): ?>
            <div class="secondary-headline">
                <?= $secondary_headline ?>
            </div>
        <?php endif ?>

        <!-- Macro - Pre -->
        <?php if ($item['macro_processed_text_before_article']): ?>        
            <div class="meta before-article">        
            <?= $item['macro_processed_text_before_article'] ?>            
            </div>
        <?php endif ?>
        <!-- End Macro - Pre -->
        
        <!-- intro image and custom code -->
        <?php if ($item_meta_options['description_custom_html_code']): ?>
            <?= $item['description_custom_html_code'] ?>
        <?php elseif ($url_intro_image): ?>
            <div class="intro-image">
                <figure>
                  <img class="intro-image" src="<?= $url_intro_image ?>" alt="<?= ___h($intro_image_caption) ?>" />
                  <?php if ($item_meta_options['display_description_intro_image_caption'] && $intro_image_caption): ?>
                  <div class="intro-image-caption"><?= $intro_image_caption ?></div>
                  <?php endif ?>
                </figure>                                             
            </div>
        <?php endif ?>                    
        <!-- end intro image -->
        
        <!-- content -->
        <div class="text" itemprop="articleSection">
            <?php if (!$item_meta_options['hide_item_summary_in_detail_view']): ?>
                <?= $item['summary'] ?>
            <?php endif ?>
            <?= $item['description'] ?>
        </div>
        <!-- end content -->
        <!-- category info -->
        
        <?php $categories = $this->getItemCategoriesByItemID($item['id'],'*', 'status > 0') ?>
        <?php if ($categories): ?>                
                <div class="article-item-categories row">        
                    <div class="col-sm-12">        
                        <?= ___c($categories) > 1 ? ___('Categories') : ___('Category') ?>:
                        <?php foreach ($categories as $category): ?>
                        <span class="article-item-category"><a href="<?= $this->createFriendlyURL("action=viewcategory&cid={$category['cid']}") ?>" ><i class="fa fa-bookmark"></i>&nbsp;<?= ___h($category['title']) ?></a></span>
                        <?php endforeach ?>
                    </div>
                </div>
            
        <?php endif ?>
        <!-- end category info -->
        <!-- tag info -->
        <?php if ($item['tags']): ?>            
        
            <?php $tags = explode(',', $item['tags']) ?>
            <?php if ($tags): ?>
                <div class="article-item-tags row">        
                    <div class="col-sm-12">
                        <?= ___c($tags) > 1 ? ___('Tags') : ___('Tag') ?>:
                        <?php foreach ($tags as $tag): ?>
                        <?php $sanitized_tag = urlencode(trim($tag)); ?>
                        <span class="article-item-tag"><a href="<?= $TagManager->createFriendlyURL("action=viewtag&tag={$sanitized_tag}") ?>" ><i class="fa fa-tag"></i>&nbsp;<?= ___h(trim($tag)) ?></a></span>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endif ?>
        
        <?php endif ?>
        <!-- end tag info -->
        
        <!-- macro -->
        <?php if ($item['macro_processed_text_after_article']): ?>
            <div class="meta after-article">
                <?= $item['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
    </article>
    <?= $item['macro_processed_text_outside_article_bottom'] ?>
</div>