<?php
/**
 * Core - Block Manager - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

global $SystemConfig;

$header_title = ($id == 'new') ? ___('New Item') : ___('Edit Item') . ' #' . ___h($id);
$categories = $this->app->getAllCategories();
$ob = $item['original_block'];
if ($item['display_in_menu'] < 1)
    $item['display_in_menu'] = 1;
?>

<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.Core_BlockManagerAdminController" data-type-desc="<?= ___('block') ?>">    

    <x-ui:schlix-editor-form id="block_item_editor" method="post" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>" enctype="multipart/form-data" >

        <x-ui:csrf id="_csrftoken" />
        <x-ui:hidden id="ob" name="ob" data-var="ob" />
        <x-ui:hidden name="id" id="id" value="<?= ___h($id) ?>" />

        <x-ui:schlix-editor-top-row>    
            <x-ui:schlix-editor-top-left>
                <!-- Page Title -->
                <x-ui:form-group>
                    <x-ui:label for="title"><?= ___('Block Name') ?></x-ui:label>
                    <x-ui:input-group>
                        <!-- title -->
                        <x-ui:textbox name="title" id="title" type="text" maxlength="31"  required="required" data-field="title" /> 

                        <!-- Instance Of -->
                        <x-ui:input-addon>
                            <?= ___('instance of'); ?> <strong><?= ___h($item['original_block']) ?></strong>
                        </x-ui:input-addon>


                        <!-- status -->
                        <x-ui:input-addon>
                            <schlix-cms-document-status id="status" data-input-name="status" data-value="<?= ($item['status'] == 1 || $item['id'] == 'new') ?>" 
                                                        data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                                        data-text-yes="<?= ___S('Active & Published') ?>" data-text-no="<?= ___('Inactive') ?>"></schlix-cms-document-status>
                        </x-ui:input-addon>
                    </x-ui:input-group>
                </x-ui:form-group>

                <x-ui:select id="category_id" name="category_id" data-field="category_id" label="<?= ___('Located in category') ?>" fonticon="fas fa-folder" default-value="<?= $this->getCurrentCategoryIDFromCookie() ?>">
                    <?php foreach ($categories as $category): ?>
                        <x-ui:option value="<?= ___h($category['cid']) ?>" label="<?= ___h($category['title']) ?>" />
                    <?php endforeach ?>                        
                </x-ui:select>

            </x-ui:schlix-editor-top-left>
            <x-ui:schlix-editor-top-right>
                <x-ui:schlix-editor-action-buttons />
            </x-ui:schlix-editor-top-right>            
        </x-ui:schlix-editor-top-row>

        <br />
        <!-- main -->
        <x-ui:clearboth />

        <x-ui:schlix-document-save-result />
        <!-- end main section -->

        <!-- begin tabs -->
        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_block_config" fonticon="far fa-file-alt" label="<?= ___('Block Configuration') ?>"> 
                <input type="hidden" name="display_in_menu_workaround" id="display_in_menu_workaround" value="<?= $item['display_in_menu']; ?>" />
                <div class="schlix_editor_main">
                    <?= \SCHLIX\cmsConfigRegistry::loadConfigFile('blocks', $item, $item['original_block'], $item['title']) ?> 
                    <br />                                
                </div>

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_meta" fonticon="fa fa-hashtag" label="<?= ___('Visibility') ?>">    


                <p><?= ___('Please choose where you want to display this block') ?>:</p>
                <x-ui:radio value="1" id="menu_select_everywhere" data-field="display_in_menu" name="display_in_menu" label="<?= ___('Every page (default)'); ?>" <?= $item['display_in_menu'] < 2 ? 'checked="checked"' : '' ?> />
                <x-ui:radio value="2" id="menu_select_some" data-field="display_in_menu" name="display_in_menu" label="<?= ___('Only on specified pages:'); ?>" />      
                <br />
                <div class="content">
                    <div id="schlix_multiple_categories_checkboxes">
                        <?php include('edit.item.menu.template.php'); ?>
                    </div>
                </div>


            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_options" fonticon="fa fa-question-circle" label="<?= ___('About') ?>">
                <?php include('edit.item.about.template.php'); ?>
            </x-ui:schlix-tab>

            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
        </x-ui:schlix-tab-container>            
        <!-- end tabs -->
    </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor> 
