<?php
/**
 * Core: Composer - Main admin view template
 * 
 * Core - Composer
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.Core_ComposerAdminController" data-enable-preview-link="true" data-default-item-icon="fas fa-box fa-2x">
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <?php /*<x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />*/ ?>
            <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fas fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fa-question" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />        
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                <x-ui:schlix-data-table-columns>
                    <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="SCHLIX.CMS.Core_ComposerAdminController.formatDataTableCell_CheckBox" sortable="false" />
                    <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Title') ?>" formatter="SCHLIX.CMS.Core_ComposerAdminController.formatDataTableCell_DefaultTitleColumn" />
                    <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />

                    <x-ui:schlix-data-table-column key="date_created" label='<?= ___('Date Created') ?>' sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                    <x-ui:schlix-data-table-column key="date_modified" label='<?= ___('Date Modified') ?>' sortable="true" formatter="this.formatDataTableCell_Date" editor= "new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                </x-ui:schlix-data-table-columns>
            </x-ui:schlix-data-table>
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-list>