<?php
/**
 * Core: Custom Field - Main admin view template
 * 
 * Core - Custom Field
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die();

$title = ___('Custom table configuration').': ['.$tablename.']';
?>

<x-ui:schlix-data-explorer-blank data-schlix-controller="SCHLIX.CMS.Core_CustomFieldAdminController" data-main-app-description="<?= $title ?>" data-enable-preview-link="true" data-default-item-icon="fa fa-file fa-2x">
    <!-- Toolbar -->

    <x-ui:row class="content">
        <!-- column -->
        <x-ui:column md="6">
            
            <?php if ($original_table_fields): ?>
             <h3><?= ___('Pre-defined table fields') ?></h3>
                <table class="table table-bordered table-stripe" style="width:auto !important">
                    <tr>            
                        <th><?= ___('Field Name') ?></th>
                        <th><?= ___('Type') ?></th>
                    </tr>
                    <?php foreach ($original_table_fields as $column): ?>

                        <tr>            
                            <td><?= ___($column['name']) ?></td>
                            <td><?= ___($column['type']) ?></td>
                        </tr>

                <?php endforeach ?>
                </table>
            <?php endif ?>

        </x-ui:column>
        <!-- column -->
        <x-ui:column md="6">
            <h3><?= ___('Custom table fields') ?></h3>
            <?php if ($custom_table_fields): ?>
             
                <table class="table table-bordered table-stripe" style="width:auto !important">
                    <tr>            
                        <th><?= ___('Field Name') ?></th>
                        <th><?= ___('Type') ?></th>
                        <th><?= ___('Action') ?></th>
                    </tr>
                    <?php foreach ($custom_table_fields as $column): ?>

                        <tr>            
                            <td><strong>xcf_</strong><?= ___($column['name']) ?></td>
                            <td><?= ___($column['type']) ?></td>
                            <td>
                            <x-ui:link-button button-type="default" size="small" href="<?= $this->createFriendlyAdminURL("action=edititem&table={$tablename}&id={$column['id']}") ?>"  label="<?= ___('Edit') ?>" fonticon="fa fa-pencil" />&nbsp;&nbsp;&nbsp;
                            <x-ui:link-button button-type="danger"  size="small" data-field-name="xcf_<?= ___($column['name']) ?>" data-field-id="<?= ___h($column['id']) ?>" class="btn-cmd-delete-field" label="<?= ___('Delete') ?>" fonticon="fa fa-times" />
                        </td>
                        </tr>

                <?php endforeach ?>
                </table>
            <?php endif ?>
            <x-ui:link-button button-type="success"  href="<?= $this->createFriendlyAdminURL("action=edititem&table={$tablename}&id=new") ?>" id="btn-new" label="<?= ___('New') ?>" fonticon="fa fa-plus" />

        </x-ui:column>        
    </x-ui:row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-blank>