<?php
/**
 * Core - EmailQueue - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.Core_EmailQueueAdminController" type="config">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>">     
                    <schlix-config:integerbox min="1" config-key="int_max_email_per_batch"   label="<?= ___('Max emails/batch send') ?>" config-default-value="10" />
                    <schlix-config:integerbox min="1" config-key="int_max_email_per_hour"   label="<?= ___('Max emails/hour') ?>" config-default-value="200" />                    
                    <div class="form-group">
                        <label><?= ___('SMTP Timeout') ?></label>
                        <div class="input-group">
                            <schlix-config:integerbox config-key="int_smtp_timeout" 
                                                      config-default-value="180" 
                                                       min="30" max="600"   /> 
                            <span class="input-group-addon">seconds</span>
                        </div>
                    </div>

                                        

                    
                </x-ui:schlix-tab>                
                
                <!-- tab -->
               <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>  
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>      
