<?php
/**
 * Core: Extension Gallery - Main admin view template
 * 
 * Core - Extension Gallery
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
$this->app->CSS('extgallery.css');
?>
<x-ui:schlix-explorer-sub-application-header />

<x-ui:schlix-data-explorer-hierarchical-treelist data-schlix-controller="SCHLIX.CMS.Core_ExtGalleryAdminController" data-enable-preview-link="true" data-default-view-mode="gallery">
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="main" data-schlix-app-action="main"  fonticon="fab fa-schlix text-schlix-logo" label="<?= ___('Extension Gallery') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="installedexts" data-schlix-app-action="installedexts" fonticon="fas fa-archive text-maroon" label="<?= ___('Installed Extensions') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/extensions/" target="_blank" fonticon="fas fa-chalkboard-teacher" open-new-window="1" label="<?= ___('Publish your extensions') ?>" />            
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
        <?php \App\Core_Composer_Admin::displayComposerInstallProgress() ?>

    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />        
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Left Column -->
        <x-ui:schlix-explorer-left-column>
            <!-- treeview -->
            <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
            <!-- end column -->
        </x-ui:schlix-explorer-left-column>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                <x-ui:schlix-data-table-columns>
                    <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="SCHLIX.CMS.Core_ExtGalleryAdminController.formatDataTableCell_CheckBox" sortable="false" />
                    <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Title') ?>" formatter="SCHLIX.CMS.Core_ExtGalleryAdminController.formatDataTableCell_Icon" />
                    <x-ui:schlix-data-table-column key="this.field_category_id" hidden="true" sortable="false" formatter="number" />
                    <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                    <x-ui:schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />
                    <x-ui:schlix-data-table-column key="featured" label="<?= ___('Featured') ?>" sortable="true" formatter="this.formatDataTableCell_Featured" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />

                    <x-ui:schlix-data-table-column key="sort_order" label="<?= ___('Sort Order') ?>" sortable="true" formatter="number" editor="new SCHLIX.UI.TextboxCellEditor({validator:SCHLIX.UI.DataTable.validateNumber,disableBtns:false})" />

                    <x-ui:schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                    <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor= "new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                    <x-ui:schlix-data-table-column key="pageview" label="<?= ___('View Count') ?>" sortable="true" formatter="number" />
                </x-ui:schlix-data-table-columns>
            </x-ui:schlix-data-table>
            
            <x-ui:schlix-gallery-view schlix-id="datanav-gallery" md="2" sm="4" xs="12" formatter="SCHLIX.CMS.Core_ExtGalleryAdminController.formatGallery"  />
            
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-hierarchical-treelist>

<?php 

$last_update_check = $this->app->getConfig('str_last_repo_check');

$last_update_check = $this->formatNiceDate($last_update_check, true);
?>
<div class="last-update"><?= ___('Data last updated') ?>: <span class="last-update-date"><?= $last_update_check ?></span></div>