<?php
namespace App;

/**
 * Core: LogViewer - Admin class
 * 
 * Core - LogViewer
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_LogViewer_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     * Constructor
     */
    public function __construct()
    {
        // Data: Item
        parent::__construct( true, []);
        $this->search_field = 'description';
        $this->setItemFieldNamesForAjaxListing('id', 'request_uri', 'referrer', 'user_agent', 'ip_address', 'date_created', 'host_name', 'description','module','type');
    }
         
    protected function modifyResult($result)
    {
        $count = ___c($result);
        if ($count > 0)
        {
            for ($i = 0;$i < $count; $i++)
            {
                $img = \App\Core_ApplicationManager::getApplicationIcon($result[$i]['module']);
                if (!empty($img))
                $result[$i]['module']  = \__HTML::IMG ($img, ['class' => 'schlix-data-listview-image-icon', 'alt' => $result[$i]['module']]). ' '.$result[$i]['module'] ;
                $result[$i]['user_agent'] = get_readable_user_agent_in_html($result[$i]['user_agent']);
            }
        }
        return $result;
    }
    
    public function modifyAjaxGetAllItemsResult($result) {
        $result = parent::modifyAjaxGetAllItemsResult($result);
        $result = $this->modifyResult($result);
        return $result;
    }
    
    public function modifyAjaxSearchObjectsResult($keyword, $result) {
        $result = parent::modifyAjaxSearchObjectsResult($keyword, $result);
        $result = $this->modifyResult($result);
        return $result;
    }
}
 
