<?php
/**
 * Core - Media Manager - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

$app_list = $this->getListofApplications();

?>
<?php global $SystemConfig, $CurrentUser; ?>

<schlix-config:data-editor   data-schlix-controller="SCHLIX.CMS.MediaManager">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                    <!--content -->
                    <fieldset><legend><?= ___('Thumbnail Dimension') ?></legend>
                        <div class="form-inline">
                        <schlix-config:integerbox min="16" max="512" config-key="int_thumb_width" required="required"   style="width:100px" config-default-value="128" />                            
                        x                            
                        <schlix-config:integerbox min="16" max="512"  config-key="int_thumb_height" required="required"   style="width:100px" config-default-value="128" />
                        <?= ___('pixels') ?>. <?= ___('(If you\'re not sure, you can just enter 128 x 128)') ?>
                        </div>
                    </fieldset>
                    
                    <schlix-config:checkbox config-key="bool_disable_file_safety_check" label="<?=  ___('Disable file safety check to prevent PHP file from being uploaded') ?>" />
                    <!-- end config -->
                    <schlix-config:checkboxgroup config-key="array_enabled_apps" label="<?=  ___('Enable TinyMCE insert URL list for the following applications') ?>">
                        <?php foreach ($app_list as $enabled_app): ?>
                            <schlix-config:option value='<?= $enabled_app['value'] ?>'><?= ___h($enabled_app['label']) ?></schlix-config:option>
                        <?php endforeach ?>
                    </schlix-config:checkboxgroup>

                    <!-- end content -->
                </x-ui:schlix-tab>
                <!-- tab -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
 