<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
namespace App;

/**
 * HTML - main HTML class
 */
class Html extends \SCHLIX\cmsApplication_HierarchicalTree_List {

    protected $user_editable_item_fields;

    //_______________________________________________________________________________________________________________//
    /**
     * Constructor
     */
    public function __construct() {
        $this->user_editable_item_fields = array('id', 'status', 'category_id', 'title', 'summary', 'description', 'virtual_filename', 'date_available', 'date_expiry', 'date_created', 'date_modified', 'sort_order', 'meta_key', 'meta_description');
        parent::__construct( ___('Web Pages'), 'gk_html_items', 'gk_html_categories');
        $this->schema_org_type_item = 'WebPage';
        $this->has_versioning = true;
        $this->has_custom_media_header = true;
        // For this class only
        $this->disable_app_description_in_page_title = ($this->app_name == 'html');
    }

    protected function probeMainPageURLRedirect()
    {
        global $CurrentFrontendApplication;
        
        if (SCHLIX_SEF_ENABLED)
        {
            $my_alias = $this->getOriginalFullApplicationAlias();
            if ($my_alias ==  $CurrentFrontendApplication)
            {
                $url = get_relative_url_request_path();
                if ($url === "/{$my_alias}/" || $url === "/{$my_alias}/home.html")
                {
                    redirect_url(SCHLIX_SITE_URL . SCHLIX_SITE_HTTPBASE );
                    exit();
                }
            }
        }
    }
    
    
    //_______________________________________________________________________________________________________________//
    /**
     * View Main Page
     */
    public function viewMainPage() {
        
        global $SystemConfig;
        
        $main_app_replacement = $SystemConfig->get('system','str_main_app');
        
        if (!empty($main_app_replacement) && ($main_app_replacement != 'html'))
        {
            redirect_url(SCHLIX_SITE_URL . SCHLIX_SITE_HTTPBASE );
            exit();
        }
        
        $item = $this->getItemsByVirtualFilename('home');
        if ($item)
            $this->viewItemByID($item[0]['id'], $this->cache);
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Returns the default category ID, must return 0 to override previous one
     * @return int
     */
    public function getDefaultCategoryID() {
        return 0;
    }  

    //_______________________________________________________________________________________________________________//
    /**
     * Deprecated, replaced with getCategoryMetaOptionKeys. 
     * Returns an array of category meta options
     * @deprecated since v2.03
     * @return array
     */
    public function getCategoryMetaOptions() {
        return array(
          array('value' => 'display_pagetitle', 'label' => ___('Display category title')),
          array('value' => 'display_error_no_access', 'label' => ___('Display errors for inaccesible item')),
          array('value' => 'display_link_title', 'label' => ___('Display links in the title')),
          array('value' => 'display_category_summary_noread', 'label' => ___('Display summary for users with no read access')),
          array('value' => 'display_category_created_by', 'label' => ___('Display created by')),
          array('value' => 'display_category_modified_by', 'label' => ___('Display modified by')),
          array('value' => 'display_category_date_created', 'label' => ___('Display date created')),
          array('value' => 'display_category_date_modified', 'label' => ___('Display date modified')),
          array('value' => 'display_child_categories', 'label' => ___('Display list of child categories')),
          array('value' => 'display_child_category_summary', 'label' => ___('Display summary')),
          array('value' => 'display_child_category_created_by', 'label' => ___('Display created by')),
          array('value' => 'display_child_category_date_created', 'label' => ___('Display date created')),
          array('value' => 'display_child_category_date_modified', 'label' => ___('Display date modified')),
          array('value' => 'display_child_category_view_count', 'label' => ___('Display view count')),                    
          array('value' => 'display_child_category_read_more_link', 'label' => ___('Display "Read More" link')),
          array('value' => 'display_items', 'label' => ___('Display list of items')),
          array('value' => 'display_item_summary', 'label' => ___('Display item\'s summary')),
          array('value' => 'display_item_created_by', 'label' => ___('Display item\'s created by')),
          array('value' => 'display_item_date_created', 'label' => ___('Display item\'s date created')),
          array('value' => 'display_item_date_modified', 'label' => ___('Display item\'s date modified')),
          array('value' => 'display_item_read_more_link', 'label' => ___('Display item\'s "Read More" link')),
          array('value' => 'display_item_view_count', 'label' => ___('Display item\'s view count')),

          //array('value' => 'display_user_can_change_sort_options', 'label' => ___('Visitors can change sort options')), // todo
          //array('value' => 'display_user_can_change_items_perpage', 'label' => ___('Visitors can change items per page')), // todo
          array('value' => 'display_category_view_count', 'label' => ___('Show this view count')),
          array('value' => 'categories_sortby', 'label' => ___('Sort child categories by'), 'options' =>
            array(
              array('value' => 'cid', 'label' => ___('Category ID')),
              array('value' => 'title', 'label' => ___('Title')),
              array('value' => 'date_created', 'label' => ___('Date Created')),
              array('value' => 'date_modified', 'label' => ___('Date Modified')),
              array('value' => 'sort_order', 'label' => ___('Sort Order'))
            )
          ),
          array('value' => 'categories_sortdirection', 'label' => ___('Child categories sort direction'), 'options' => array(array('value' => 'desc', 'label' => ___('Descending')), array('value' => 'asc', 'label' => ___('Ascending')))),
          array('value' => 'items_sortby', 'label' => ___('Sort child items by'), 'options' => $this->getSortableItemColumns()
          ),
          array('value' => 'items_sortdirection', 'label' => ___('Child items sort direction'), 'options' => array(array('value' => 'desc', 'label' => ___('Descending')), array('value' => 'asc', 'label' => ___('Ascending')))),
        );
    }
    //_______________________________________________________________________________________________________________//
    /**
     * Deprecated. Replaced with getSortableItemColumns in parent class
     * @deprecated since version 2.0.3
     * @return array
     */
    public function getSortableItemFields() {
        return array(
          array('value' => 'id', 'label' => ___('Item ID')),
          array('value' => 'title', 'label' => ___('Title')),
          array('value' => 'date_created', 'label' => ___('Date Created')),
          array('value' => 'date_modified', 'label' =>___('Date Modified')),
          array('value' => 'sort_order', 'label' => ___('Sort Order'))
        );
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Deprecated. Replaced with getSortableCategoryColumns in parent class
     * @deprecated since version 2.0.3
     * @return array
     */

    public function getSortableCategoryFields() {
        return array(
          array('value' => 'cid', 'label' => ___('Category ID')),
          array('value' => 'title', 'label' => ___('Title')),
          array('value' => 'date_created', 'label' => ___('Date Created')),
          array('value' => 'date_modified', 'label' =>___('Date Modified')),
          array('value' => 'sort_order', 'label' => ___('Sort Order'))
        );
    }    
    //_______________________________________________________________________________________________________________//
    /**
     * Deprecated. Replaced with getItemMetaOptionKeys in parent class
     * @deprecated since version 2.0.3
     * @return array
     */
    public function getItemMetaOptions() {
        return array(
          array('value' => 'display_pagetitle', 'label' => ___('Display page title')),
          array('value' => 'display_error_no_access', 'label' => ___('Display errors for inaccesible item')),
          array('value' => 'display_item_summary_noread', 'label' => ___('Display item\'s summary for users with no read access')),
          array('value' => 'display_item_created_by', 'label' => ___('Display item\'s first created by')),
          array('value' => 'display_item_modified_by', 'label' => ___('Display item\'s last modified by')),
          array('value' => 'display_item_date_created', 'label' => ___('Display item\'s date created')),
          array('value' => 'display_item_date_modified', 'label' => ___('Display item\'s date modified')),
          array('value' => 'display_item_view_count', 'label' => ___('Display item\'s view count'))
        );
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Interpret SEO URL and returns an array of command with main key 'action'
     * @param string $urlpath
     * @return array
     */
    public function interpretFriendlyURL($urlpath) {
        $default_indexes = array(SCHLIX_SITE_HTTPBASE . '/', SCHLIX_SITE_HTTPBASE . '/index.html', SCHLIX_SITE_HTTPBASE . '/index.php');

        if ($this->app_name == 'html' && SCHLIX_SEF_ENABLED && !fget_string('app') && substr_count($urlpath, '/') == substr_count(SCHLIX_SITE_HTTPBASE . '/', '/')) { // only for HTML. Do not derive this code.
            // && substr_count($urlpath,'/') == 1
            $parsedurl = $this->probeFriendlyURLDestination($urlpath);
            $url = $parsedurl['url'];
            $url_array = $parsedurl['url_array'];
            $pathonly = parse_url($urlpath, PHP_URL_PATH);

            if (empty($parsedurl['url']) && empty($url_array) && !in_array($urlpath, $default_indexes) && $pathonly[strlen($pathonly) - 1] != '/') {
                $command = [];
                $command['action'] = '404error';
                return $command;
            }
        }
        return parent::interpretFriendlyURL($urlpath);
    }   
    
    //_______________________________________________________________________________________________________________//
    /**
     * Runs command
     * @param array $command
     * @return boolean
     */
    public function Run($command) {
        $pg = isset($command['pg']) ? $command['pg'] : 0;
        
        switch ($command['action']) {
            case 'viewitem': $this->viewItemByID($command['id'], $this->cache);
                break;
            case 'viewcategory': $this->viewCategoryByID($command['cid'], $pg, 'date_created', 'DESC', $this->cache);
                break;

            default: return parent::Run($command);
        }

        return true;
    }

}
