/**
 * Brochure Pages - Javascript admin controller class
 * 
 *  
 *
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *

 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.LandingPagesAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("landing");
    };
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn  (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            // console.log(oRecord);
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            var icon = "<i class =\"far fa-file-alt fa-2x\"></i>";

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class = (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home') ? 'html_home' : 'dragdrop';
            var preview_link = oRecord.getData("preview_link");
            var display_preview_link = '';
            if (SCHLIX.Util.isString(preview_link))
            {
                var preview_icon = "<i class=\"fa fa-eye\"></i> ";
                display_preview_link = '<div style="float:right;margin-left:4em">' +  '<a target="_blank" href="' + preview_link + '">' + preview_icon +  '</a>' + '</div>';
            }
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            

            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>' + display_preview_link;
        }
    };
    
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
            if (oRecord.getData('cid')==1 )
                    elCell.innerHTML = '<i class="fa fa-2x fa-home"></i>';
            else
            {
                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                if (oRecord.getData("cid") > 0)
                {
                    theID = app_name + '-select-cid' + oRecord.getData("cid");
                    theValue = 'c' + oRecord.getData("cid");
                }
                else
                {
                    theID = app_name + '-select-id' + oRecord.getData("id");
                    theValue = 'i' + oRecord.getData("id");
                }

                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';

            }
    }; 
    
    runCommand (command, evt)
    {
        //if (evt.type == 'contextmenu')
        var open_in_new_window = is_rightclick_event(evt);
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem",open_in_new_window);
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;                                                
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};