<?php
/**
 * Personal Data Request - Main admin view template
 * 
 * Plugin for compliance with GDPR
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package personaldatarequest
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<!-- {top_menu} -->
<x-ui:schlix-data-explorer-list data-schlix-controller="SCHLIX.CMS.GDPRAdminController" data-enable-preview-link="true" >
    <x-ui:alert type="warning">
        <p><i class="fa fa-exclamation-triangle"></i> <?= ___('Note: this application is currrently still in BETA and it is not recommended to enable it for production use') ?></p>
    </x-ui:alert>
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            <!-- {config} -->
            <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig" fonticon="fas fa-cog" label="<?= ___('Configuration') ?>" />
                
            <!-- {end config -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />        
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                <x-ui:schlix-data-table-columns>
                    <x-ui:schlix-data-table-column key="this.field_id" sortable="true" label="<?= ___('ID') ?>" formatter="number" />
                    <x-ui:schlix-data-table-column key="request_type" label="<?= ___('Type') ?>" sortable="false" formatter="SCHLIX.CMS.GDPRAdminController.formatDataTableCell_RequestType" />
                    <x-ui:schlix-data-table-column key="guid" label="<?= ___('GUID') ?>"  sortable="false" formatter="text" />
                    <x-ui:schlix-data-table-column key="email_address" label="<?= ___('Email Address') ?>" sortable="true" formatter="text" />
                    <x-ui:schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="SCHLIX.CMS.GDPRAdminController.formatDataTableCell_Status" />
                    <x-ui:schlix-data-table-column key="request_ip_address" label="<?= ___('IP address') ?>" formatter="text" />

                    <x-ui:schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                    <x-ui:schlix-data-table-column key="date_confirmed" label="<?= ___('Date Confirmed') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                    <x-ui:schlix-data-table-column key="reason" sortable="true" label="<?= ___('Reason') ?>" formatter="text" />
                    
                </x-ui:schlix-data-table-columns>

            </x-ui:schlix-data-table>
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-list>