<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace App;

class SiteManager extends \SCHLIX\cmsApplication_List
{

    public function __construct()
    {
        parent::__construct('Site Manager', 'gk_sites_websites');
        $this->disable_frontend_runtime = true;
    }
            
    
    /**
     * Change the definition in config.inc.php
     * @param array $vars
     * @param string $newvalue
     */
    public function changeSiteConfigDefinitions($vars)
    {
        $something_changed = false;
        if (is_array($vars))
        {
            $filename = CURRENT_SUBSITE_PATH . '/config.inc.php'; // realpath( __DIR__.'/../src/web/main/config.inc.php' );    
            $content = file_get_contents($filename);
            if ($content)
            {
                $content = trim($content);
                if (str_ends_with($content, '?>'))
                {
                    //$content = substr
                    $new_length = strlen($content) - 2;
                    $content = substr($content, 0, $new_length);
                }
                foreach ($vars as $var => $newvalue)
                {
                    $regex = "/\bdefine\s*\(\s*('{$var}'|\"{$var}\")\s*,\s*(.*?)\)/i";
                    $c = preg_match_all($regex, $content, $matches);
                    $sanitized_new_value = str_replace("'", "\'", $newvalue);
                    $new_definition = "define('{$var}','{$sanitized_new_value}')";                    
                    $int_value = strval((int) $sanitized_new_value);
                    $bool_value = is_value_true ($sanitized_new_value) ? 'true' : 'false';
                    switch ($var)
                    {
                        case 'SCHLIX_SESSION_LOGIN_TIME' :
                        case 'SCHLIX_SESSION_REMEMBER_COOKIE_TIME':
                        case 'SCHLIX_SMTP_PORT':
                        case 'SCHLIX_SMTP_USE_AUTH':                            
                            $new_definition = "define('{$var}',{$int_value})";           
                            break;
                        case 'SCHLIX_SITE_OFFLINE':
                        case 'SCHLIX_SITE_SSL_ENABLED':
                        case 'SCHLIX_SMTP_SECURITY_SELF_SIGNED':
                            $new_definition = "define('{$var}',{$bool_value})";           
                            break;
                    }
                    
                    if (___c($matches[0]) > 0)
                    {
                        $old_definition = $matches[0][0];
                        $unquoted_old_value = substr($matches[2][0], 1, strlen($matches[2][0]) - 2);
                        
                        $content = str_replace($old_definition, $new_definition, $content);
                        $something_changed = true;
                    } else
                    {
                        $content.= "\n".$new_definition.";\n";
                    }
                }
                if ($something_changed)
                {
                    file_put_contents($filename, $content);
                    clearstatcache(true);
                    sleep(1);
                    
                }
            }
        }
    }


//_______________________________________________________________________________________________________________//
    public function Run($command)
    {
        return false; 
    }

}
