<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
global $CurrentUser;

$field_category_id = $this->app->getFieldCategoryID();

$is_existing_user = (intval($id) > 0);
$is_new_user = ($id === 'new');
$header_title = $is_new_user ? ___('New User') : ___('Edit User');
$require_gender = $this->app->getConfig('bool_require_gender');
$require_dob = $this->app->getConfig('bool_require_dob');

$is_editing_current_user = $id == $CurrentUser->getCurrentUserID();

$status_readonly = $is_editing_current_user ? 'readonly="readonly"' : '';

if ($id == 'new') {
    $item['status'] = 0;
    $item['date_of_birth'] = null;
    $item['email_address'] = '';
}
?>
<x-ui:schlix-explorer-sub-application-header />

<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.UsersAdmin" data-type-desc="<?= ___('user') ?>">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>">
            
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:hidden id="category_id" data-field="category_id" name="category_id" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <?php if ($is_existing_user): ?>
                <x-ui:hidden name="original_email_address" id="original_email_address"  data-field="email_address" />
            <?php endif ?>
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                    <x-ui:form-group>
                        <label for="username" class=" control-label"><?= ___('Username') ?></label>
                        <x-ui:input-group>
                            <x-ui:input-addon><i class="fa fa-user fa" ></i></x-ui:input-addon>
                            <?php if ($is_existing_user): ?>
                            
                            <x-ui:textbox data-field="username" id="username" name="username" readonly="readonly" />
                            <?php else: ?>
                            <x-ui:textbox data-field="username" name="username" maxlength="32" id="username"  placeholder="<?= ___('Enter the username') ?>" 
                                   required="required" pattern="^[a-zA-Z][a-zA-Z0-9-_]{2,63}$" title="<?= ___('Minimum 5 characters, maximum 63 characters, alphanumeric, underscores, and dash only') ?>"  />
                            <?php endif ?>
                            <?php if (!$is_editing_current_user): ?>
                            <x-ui:input-addon><strong><?= ___('Status') ?></strong>:</x-ui:input-addon>
                            <x-ui:input-addon>
                                <label class="radio-inline text-red"><input type="radio" class="confirm_status" id="status_inactive" name="status" value="0" <?= $status_readonly ?> <?= $item['status']==0 && !$is_new_user ? 'checked="checked"' : '' ?> required="required" /><i class="fa fa-times"></i>&nbsp;<?= ___('Inactive') ?></label>
                                
                        <label class="radio-inline">
                            <input type="radio" class="confirm_status" id="status_requires_activation" name="status" value="<?= USER_REQUIRES_ACTIVATION ?>" <?= $status_readonly ?> <?= $item['status']== USER_REQUIRES_ACTIVATION ? 'checked="checked"' : '' ?> required="required" /><i class="fa fa-question"></i>&nbsp;<?= ___('Requires activation') ?>
                        </label>
                        <label class="radio-inline text-green">
                            <input type="radio" class="confirm_status" id="status_active" name="status" value="<?= USER_ACTIVATED_IMMEDIATELY ?>" <?= $status_readonly ?> <?= $item['status']== USER_ACTIVATED_IMMEDIATELY ? 'checked="checked"' : '' ?> required="required"/><i class="fa fa-check"></i>&nbsp;<?= ___('Active') ?>
                        </label>
                                
                            </x-ui:input-addon>
                            <?php else: ?>
                            <x-ui:hidden id="h_status" name="status" data-field="status" />
                            <?php endif ?>
                        </x-ui:input-group>
                    </x-ui:form-group>
                    
                    <!-- field -->
                    <?php if($is_new_user): ?>
                    <x-ui:form-group>
                        <x-ui:checkbox name="notify_new_account" id="notify_new_account" value="1" label="<?= ___('Send the new user an email about this new account') ?>" checked="checked"   />
                    </x-ui:form-group>
                    <?php endif ?>
                     <!-- end field -->
                    
                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <?php if ($is_new_user): ?>
            <br />
            <x-ui:alert type="info">
                <p class="small">
                    <?= ___('If the status is set to') ?>
                    <ul>
                        <li class="small"><?= ___('Active: an email with plaintext password will be sent') ?></li>
                        <li class="small"><?= ___('Requires Activation: an email with activation link will be sent and the user must click to verify its email address') ?></li>
                        <li class="small"><?= ___('Inactive: no email will be sent but the user will not be able to login') ?></li>
                    </ul>
                </p>            
            </x-ui:alert>
            <?php endif ?>
            
            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="far fa-file-alt" label="<?= ___('User Information') ?>"> 
                    <x-ui:row>
                            <x-ui:column md="4">
                                
                                <div class="content">
                                    <!-- col -->
                                    <?php if ($is_existing_user): ?>
                                    <p><?= ___('Current e-mail address') ?>: <strong class="email-address-text"><?= ___h($item['email_address']) ?></strong></p>
                                        <x-ui:form-group id="change_email_opt_div">
                                             <x-ui:button button-type="default" name="change_email" id="change_email" label="<?= ___('Change Email') ?>" fonticon="fas fa-envelope" />
                                        </x-ui:form-group>
                                    
                                    <!-- field -->
                                        <x-ui:form-group id="change_password_opt_div">
                                             <x-ui:button button-type="warning" name="change_password" id="change_password" label="<?= ___('Change Password') ?>" fonticon="fas fa-lock" />
                                        </x-ui:form-group>
                                    <?php else: ?>
                                    <div id="new_account_email_password_setup">
                                    <x-ui:form-group>
                                        <label for="email"><?= ___('Enter and verify the email address') ?></label>
                                        <x-ui:input-group>
                                            <x-ui:input-addon><i class="fa fa-envelope fa" ></i></x-ui:input-addon>                                            
                                            <x-ui:textbox type="email"  name="email_address" id="email_address"  placeholder="<?= ___('Enter email') ?>" data-field="email_address"  required="required" />
                                            <x-ui:textbox type="email" name="email_address_verify" id="email_address_verify"  placeholder="<?= ___('Verify email') ?>" data-field="email_address" required="required" />
                                        </x-ui:input-group>
                                    </x-ui:form-group>

                                    <x-ui:form-group>
                                        <label for="password"><?= ___('Enter and verify the password') ?></label>

                                        <x-ui:input-group>
                                            <x-ui:input-addon>
                                                <i class="fa fa-lock"></i>
                                            </x-ui:input-addon>                                    
                                            <x-ui:password name="password" id="password" placeholder="<?= ___('Enter Password') ?>" pattern=".{7,50}" title="<?= ___('Minimum 7 characters') ?>"  <?= ($is_new_user) ? 'required="required"' : ''; ?> value="" />

                                            <x-ui:password name="password_verify" id="password_verify" placeholder="<?= ___('Confirm Password') ?>"  <?= ($is_new_user) ? 'required="required"' : ''; ?> value="" />
                                        </x-ui:input-group>
                                    </x-ui:form-group>
                                    </div>
                                    <?php endif ?>       
                                    <!-- end col -->
                                </div>
                            </x-ui:column>
                            <x-ui:column md="4">
                                <div class="content">
                                    <!-- content -->
                                    <!-- field -->
                                <x-ui:form-group>
                                    <label for="firstname" class="control-label"><?= ___S('First & Last Name') ?></label>
                                    <x-ui:input-group>
                                        <x-ui:input-addon><i class="fa fa-users fa" ></i></x-ui:input-addon>
                                    <x-ui:textbox name="firstname" id="firstname" required="required" placeholder="<?= ___('Enter your first name') ?>" data-field="firstname" />

                                    <x-ui:textbox name="lastname" id="lastname" required="required" placeholder="<?= ___('Enter your last name') ?>" data-field="lastname"  />
                                    </x-ui:input-group>
                                </x-ui:form-group>
                                    
                                    
                                    
                                    <!-- field -->
                                    <x-ui:textbox name="display_name" id="display_name" data-field="display_name" placeholder="<?= ___('Optional display name') ?>"   fonticon="fa fa-user" label="<?= ___('Display Name') ?>" /> 
                                    <!-- field -->
                                    
                        
                                    <x-ui:form-group>
                                        
                                        <label for="dob_year" class=" control-label"><?= ___('Date of Birth') ?>&nbsp;(<?= $require_gender ? ___('required') : ___('optional') ?>) </label>
                                        <?= \INPUT::DatePicker('dob', $item['date_of_birth'], 1900, date('Y')) ?>
                                    </x-ui:form-group>
                                    <!-- field -->
                                    <x-ui:form-group>
                                        <label class=" control-label"><?= ___('Gender') ?></label><x-ui:clearfix />
                                        <x-ui:radio-group name="gender" data-field="gender" inline="1">
                                            <x-ui:option value="1"><i class="fa fa-male"></i>&nbsp;<?= ___('Male') ?></x-ui:option>
                                            <x-ui:option value="2"><i class="fa fa-female"></i>&nbsp;<?= ___('Female') ?></x-ui:option>
                                            <x-ui:option value="0"><?= ___('Unspecified') ?></x-ui:option>
                                        </x-ui:radio-group>
                                    </x-ui:form-group>
                                    
                                    <!-- end content -->
                                </div>
                            </x-ui:column>
                        </x-ui:row>                                    
                    
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_user_bio" fonticon="fa fa-hashtag" label="<?= ___('Short Bio and Picture') ?>">    

                        <!-- tab content -->
                        <x-ui:row>
                            <x-ui:column md="3">
                                
                                <x-ui:form-group>
                                    <?php if ($is_existing_user): ?>
                                    <p><a href="<?= $this->app->createFriendlyURL("action=viewitem&id={$id}") ?>" class="btn btn-success" target="_blank">
                                            <i class="fa fa-eye"></i>&nbsp;<?= ___('Preview') ?></a></p>
                                    <?php endif ?>
                                </x-ui:form-group> 
                                <x-ui:schlix-document-image-uploader label="<?= ___("Change avatar/picture") ?>" fonticon="far fa-folder-open" name="user_avatar" id="user_avatar" data-field="avatar" data-dir-key="avatar_medium" />
                                
                            </x-ui:column>
                            <x-ui:column md="9">

                            <x-ui:wysiwyg label="<?= ___('User Bio - Intro') ?>" name="summary" id="summary" data-field="summary" />
                            <x-ui:wysiwyg label="<?= ___('User Bio - Details') ?>" name="description" id="description" data-field="description" />
                                
                            </x-ui:column>
                        </x-ui:row>
                        <!-- end tab content -->                   
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_user_group" fonticon="fa fa-users" label="<?= ___('User Groups') ?>">    
                    
                     <x-ui:schlix-document-multi-category-selector enable-primary-category="false" name="original_primary_category_id" id="original_primary_category_id" data-field="original_primary_category_id" label="<?= ___('Categories') ?>" help-text="<?= ___('Please select at least one category') ?>" field-title="groupname" /> 
                    
                </x-ui:schlix-tab>
                
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    <x-ui:schlix-datetime-picker id="date_available" name="date_available" data-field="date_available" label="<?= ___('Available on') ?>" />
                    <x-ui:schlix-datetime-picker id="date_expiry" name="date_expiry" data-field="date_expiry" label="<?= ___('Expiry') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <?php if ($is_existing_user): ?>
                <x-ui:schlix-tab id="tab_history" fonticon="far fa-calendar" label="<?= ___('History') ?>"> 
                    
                    <x-ui:schlix-data-explorer-list id="schlix-userhistory-admin" class="schlix-data-explorer" data-app="users" data-schlix-controller="SCHLIX.CMS.UsersAdmin" data-model="<?= $this->getDataModelURL() ?>" data-desc="<?= ___('User History') ?>">
                        <schlix-datasource>
                            <custom-command data-default="action=getdataresponseschemas"  data-replace-with="action=getuserhistoryresponseschema" />
                            <custom-command data-default="action=getallitems"  data-replace-with="action=gethistory&id=<?= ___h($id) ?>" />
                        </schlix-datasource>

                        <x-ui:clear-both />
                        <!-- Begin Data Viewer -->
                        <x-ui:schlix-explorer-row>
                            <!-- Right Column -->
                            <x-ui:schlix-explorer-right-column>
                                <!-- datatable -->

                                <schlix-data-table schlix-id="datanav-datatable" schlix-query-action="action=gethistory&id=<?= ___h($id) ?>" schlix-field-item-tile="description">
                                    <schlix-data-table-columns>
                                        <schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                                        <schlix-data-table-column key="id" hidden="false" sortable="false" formatter="number" label="<?= ___('ID') ?>" />
                                        <schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor( {disableBtns:false})" />
                                        <schlix-data-table-column key="ip_address" label="<?= ___('IP address') ?>" formatter="text" />
                                        <schlix-data-table-column key="description" sortable="true" label= "<?= ___('Description') ?>" role="title" formatter="SCHLIX.CMS.UsersAdmin.formatHistoryDescription" />
                                        <schlix-data-table-column key="user_agent" label="<?= ___('User Agent') ?>" formatter="text" />
                                     </schlix-data-table-columns>
                                </schlix-data-table>                
                                <!-- pagination -->
                                <x-ui:schlix-explorer-pagination />

                            </x-ui:schlix-explorer-right-column>
                        </x-ui:schlix-explorer-row> 
                        <!-- End Data Viewer -->
                    </x-ui:schlix-data-explorer-list>                    

                </x-ui:schlix-tab>
                <?php endif; ?>
                <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor>

<?php if ($is_existing_user): ?>
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-change-email-dialog" 
                               data-fixedcenter="true" data-visible="false" data-constraintoviewport="true"
                               data-schlix-controller="SCHLIX.CMS.UsersAdmin" header-label="<?= ___('Change Email') ?>" data-model="<?= $this->getDataModelURL() ?>"
                               data-button-submit-id="btn-changeemail-ok" data-button-cancel-id="btn-changeemail-cancel"
                               data-action="action=changeemail" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden id="change_email_user_id" name="id" data-field="id" />
    <x-ui:hidden id="change_email" name="change_email" value="1" />
    <x-ui:form-group>
        <label for="email"><?= ___('Enter and verify the email address') ?></label>
        <x-ui:input-group>
            <x-ui:input-addon><i class="fa fa-envelope fa" ></i></x-ui:input-addon>
            <x-ui:textbox type="email"  name="email_address" id="change_email_address"  placeholder="<?= ___('Enter email') ?>" data-field="email_address"  required="required" />
            <x-ui:textbox type="email" name="email_address_verify" id="change_email_address_verify"  placeholder="<?= ___('Verify email') ?>" data-field="email_address" required="required" />
        </x-ui:input-group>
    </x-ui:form-group>
    <x-ui:form-group>
        <p><?= ___('Send an e-mail about the change to') ?></p>
        <x-ui:checkbox  name="notify_user_email_change_new_address" id="notify_user_email_change_new_address" value="1" checked="checked" label="<?= ___('The new e-mail address above') ?>" />
        <x-ui:checkbox  name="notify_user_email_change_old_address" id="notify_user_email_change_old_address" value="1" checked="checked">
            <?= ___('The old e-mail address') ?>
            <span class="email-address-text">
                <?= ___h($item['email_address']) ?>
            </span>
        </x-ui:checkbox>
        
    </x-ui:form-group>

    <hr />

    <x-ui:schlix-cms-dialog-button-submit id="btn-changeemail-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-changeemail-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>

    <x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-change-password-dialog"
                                   data-fixedcenter="true" data-visible="false" data-constraintoviewport="true"
                                   data-schlix-controller="SCHLIX.CMS.UsersAdmin" header-label="<?= ___('Change Password') ?>" data-model="<?= $this->getDataModelURL() ?>"
                                   data-button-submit-id="btn-changepassword-ok" data-button-cancel-id="btn-changepassword-cancel" 
                                   data-action="action=changepassword" form-method="post" >
        <!-- form -->
        <x-ui:csrf />
        <x-ui:hidden id="change_password_user_id" name="id" data-field="id" />
        <?php if (!$is_editing_current_user): ?>
        <x-ui:form-group id="change_password_type">
            <x-ui:radio name="change_password_type" value="change_password"  label="<?= ___('Change Password') ?>" no-hidden="1" checked="1" />
            <x-ui:radio name="change_password_type" value="reset_link" label="<?= sprintf(___('Send Password reset link to %s'), ___h($item['email_address'])) ?>" no-hidden="1"  />
        </x-ui:form-group>
        <?php else: ?>
        <x-ui:hidden name="change_password_type" value="change_password" />
        <?php endif ?>
        <hr />
        <div class="password-toggle-change">
            <?php if ($is_editing_current_user): ?>
            <x-ui:password name="oldpassword" id="oldpassword" required="required" fonticon="fa fa-unlock" label="<?= ___('Current password') ?>" placeholder="<?= ___('Current password') ?>" value="" />
            <?php endif ?>
            <x-ui:form-group>
                <label for="password"><?= ___('Enter and verify the password') ?></label>
                <x-ui:input-group>
                    <x-ui:input-addon>
                        <i class="fa fa-lock"></i>
                    </x-ui:input-addon>
                    <x-ui:password name="_plaintext_password" id="_plaintext_password" placeholder="<?= ___('Enter Password') ?>" pattern=".{7,50}" title="<?= ___('Minimum 7 characters') ?>"  <?= ($is_new_user) ? 'required="required"' : ''; ?> value="" />

                    <x-ui:password name="_plaintext_password_verify" id="_plaintext_password_verify" placeholder="<?= ___('Confirm Password') ?>"  <?= ($is_new_user) ? 'required="required"' : ''; ?> value="" />
                </x-ui:input-group>
            </x-ui:form-group>
                <?php if (!$is_editing_current_user): ?>
                <x-ui:checkbox name="notify_user_password_change" id="notify_user_password_change" value="1" label="<?= ___('Send the plain text password to the current email address') ?>" />
                 
                <x-ui:alert type="warning">
                    <p><i class="fa fa-exclamation-triangle" ></i> <?= ___('Warning: It is recommended that you use the send password reset link button instead of emailing plain text password') ?></p>
                </x-ui:alert>
                <?php endif ?>
                <hr />

        </div>
        <x-ui:schlix-cms-dialog-button-submit id="btn-changepassword-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
        <x-ui:schlix-cms-dialog-button-cancel id="btn-changepassword-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />    
        <?php /* <x-ui:form-group class="password-toggle-email hidden">
          <button type="button" class="btn btn-info" id="btn_send_password_reset"><i class="fa fa-envelope"></i>&nbsp;<?= ___('Send password reset link') ?></button> to <strong class="email-address-text"><?= $item['email_address'] ?></strong>
          </x-ui:form-group> */ ?>
        <!-- end form -->
    </x-ui:schlix-cms-common-dialog>
<?php endif ?>

