<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die();
?>
<?php
global $HTMLHeader;


$enable_registration =$this->getConfig( 'bool_enable_registration') ;
$rate_limit_exceeded = rate_limit_and_halt('user_successful_registration', 30);
?>

<h1 class="title"><i class="fa fa-user"></i> <?= ___('Create a Profile') ?></h1>
<hr />

<x-ui:row>
    <?php if ($enable_registration ): ?>

        <x-ui:column sm="6" md="5">
            <x-ui:panel type="panel-default">
                <!-- header -->
                <x-ui:panel-body>
    <x-ui:form-simple-ajax method="post" data-action="<?= $this->createFriendlyURL('action=newregistration'); ?>" name="registeruser" id="registeruser" enctype="multipart/form-data" autocomplete="off">                    
                    <div class="main-login">

                        <x-ui:row>


                            <x-ui:column sm="12">
                                
                                    <x-ui:csrf />

                                    <x-ui:form-group>
                                        <label for="firstname" class="control-label"><?= ___S('First & Last Name') ?></label>
                                        <x-ui:input-group>
                                            <x-ui:input-addon>
                                                <i class="fa fa-users"></i>
                                            </x-ui:input-addon>                                    
                                            <x-ui:textbox name="firstname" id="firstname" required="required" placeholder="<?= ___('Enter your first name') ?>" value="" />

                                            <x-ui:textbox name="lastname" id="lastname" required="required"   placeholder="<?= ___('Enter your last name') ?>" value="" />
                                        </x-ui:input-group>
                                    </x-ui:form-group>
                                    <!-- field -->                            
                                    <x-ui:textbox type="email" name="email_address" id="email_address" required="required" fonticon="fa fa-envelope" label="<?= ___('Your Email') ?>" placeholder="<?= ___('Enter your Email') ?>" value=""  />                             
                                    <x-ui:textbox name="username" id="username" required="required" fonticon="fa fa-user" label="<?= ___('Username') ?>" placeholder="<?= ___('Username') ?>" value=""  /> 
                                    <x-ui:form-group>
                                        <label for="password" class="control-label"><?= ___('Password') ?></label>

                                        <x-ui:input-group>
                                            <x-ui:input-addon>
                                                <i class="fa fa-lock"></i>
                                            </x-ui:input-addon>                                    
                                            <x-ui:password name="password" id="password" required="required" placeholder="<?= ___('Enter your Password') ?>" pattern=".{7,70}" title="<?= ___('Minimum 7 characters') ?>"  />

                                            <x-ui:password name="password_verify" id="password_verify" required="required"   placeholder="<?= ___('Confirm your Password') ?>" />
                                        </x-ui:input-group>
                                    </x-ui:form-group>

                                    <!-- field -->

                                    <?php if ($this->getConfig('bool_require_dob')) : ?>

                                        <x-ui:form-group>
                                            <label for="dob_year" class=" control-label"><?= ___('Date of Birth') ?></label>
                                            <?= \INPUT::DatePicker('dob', $_POST['date_of_birth'], 1900, date('Y')) ?>
                                        </x-ui:form-group>
                                    <?php endif ?>
                                    <!-- field -->
                                    <?php if ($this->getConfig('bool_require_gender')) : ?>
                                        <x-ui:radio-group name="gender" label="Gender" inline="1">
                                            <x-ui:option value="1"><i class="fa fa-male"></i>&nbsp;<?= ___('Male') ?></x-ui:option>
                                            <x-ui:option value="2"><i class="fa fa-female"></i>&nbsp;<?= ___('Female') ?></x-ui:option>
                                            <x-ui:option value="0"><?= ___('Unspecified') ?></x-ui:option>
                                        </x-ui:radio-group>

                                    <?php endif ?>
                                    
                                    <?php if ($this->getConfig( 'bool_enable_captcha_user_registration') || $rate_limit_exceeded ): ?>
                                        <x-ui:captcha id="verification_code" name="verification_code" required="required" />
                                    <?php endif; ?>
                                    <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1"  id="btn-register" value="Submit" label="<?= ___('Register') ?>" fonticon="fas fa-user-plus" block="1" size="large" />
                                


                            </x-ui:column>
                        </x-ui:row>

                    </div>        
    </x-ui:form-simple-ajax>        
                </x-ui:panel-body>
                <!-- footer -->
                <x-ui:panel-footer>
                    <a href="<?= $this->createFriendlyURL("action=forgotpassword"); ?>"><i class="fa fa-unlock-alt"></i> <?= ___('Forgot password?'); ?></a>
                    <br />

                    <a href="<?= $this->createFriendlyURL("action=login"); ?>"><i class="fas fa-sign-in-alt"></i> <?= ___('Login with an existing account'); ?></a>

                </x-ui:panel-footer>
            </x-ui:panel>
        </x-ui:column>
        <!-- col -->

    <?php endif ?>
    <!-- col -->
    <x-ui:column sm="6" md="7">
        <div class="schlix-ajax-output"></div>
        <?php if (___c($error_list) > 0): ?>
            <x-ui:alert type="error" var="error_list" fonticon="fa fa-times" />
        <?php endif; ?>            

        <!-- content -->
        <?php if  (!$enable_registration): ?>
        <x-ui:echo-safe-config-value key="str_registration_disabled_text" />
        
        
        <?php endif ?>
        <x-ui:echo-safe-config-value key="str_registration_welcome_text" />
        
        <!-- end content -->
    </x-ui:column>
</x-ui:row>
