<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */

  if (!defined('SCHLIX_VERSION')) die('No Access');
  global $CurrentUser;
?>
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- FEATURED - all blog items that are marked as Featured, sorted by the date_created field -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<div id="<?= $this->block_name; ?>" class="main-hero">
  <div class="row d-flex flex-row bd-highlight">
    <?php for ($i=0; $i < $items_count;$i++ ): ?>
      <?php

        $substr = ($items_count > 4 && $i !== 0 ? 30 : 100);

        $item=$items[$i];
        $entry = $item['date_created'];
        // you can customize your own stuff here
        $link = $obj->createFriendlyURL("action=viewitem&id={$item['id']}");
        $entrydate = date("j.M.Y",strtotime($item['date_created']));
        $entrytitle = $item['title'];
        $secondary_headline = $item['summary_secondary_headline'] ? $item['summary_secondary_headline'] : mb_substr(strip_tags($item['summary']), 0, $substr) . '...';
        $img_size = ($i > 0) ? 'image_small' : 'image_medium';
        $thumb_filename = $obj->getBlogImage($img_size, $item['summary_intro_image']);
        $caption_text = empty($item['summary_intro_image_caption']) ? $item['title'] : $item['summary_intro_image_caption'];
        if ($item['status'] == 1 && $CurrentUser->hasReadPermission($item['permission_read']) && ($item['date_expiry']  === NULL || $item['date_expiry'] == NULL_DATE || days_difference_from_today($item['date_expiry']) > 0 )):
      ?>
        <?php if ($items_count > 4 && $i === 1): ?>
          <div class="col-md-6 col-sm-12 bd-highlight">
            <div class="row d-flex flex-row bd-highlight">
        <?php endif; ?>
        <div class="col-md-6 col-sm-12 p-1  bd-highlight">
          <div class="main-hero__slide <?= $items_count > 4 && $i !== 0 ? 'main-hero__slide--child' : '' ?>">
            <a class="overlay-links" href="<?= $link; ?>"></a>
            <div class="images-box overlay-images overlay-images--black">
              <img src="<?= $thumb_filename ?>" alt="<?= ___h($caption_text) ?>">
            </div>
            <div class="text-box">
              <h2><?= ___h($entrytitle); ?></h2>
              <p><?= $secondary_headline ?></p>
            </div>
          </div>
        </div>
        <?php if ($items_count > 4 && $i === 5): ?>
            </div>
          </div>
        <?php endif; ?>
      <?php endif; ?>
    <?php endfor; ?>
  </div>
</div>
<!-- ~~~~~~~~~~~~ -->
<!-- end featured -->
<!-- ~~~~~~~~~~~~ -->