<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

global $HTMLHeader;

$HTMLHeader->CSS(get_system_or_user_url_path('/wysiwygeditors/codemirror/codemirror.min.css'));
$HTMLHeader->JAVASCRIPT(get_system_or_user_url_path('/wysiwygeditors/codemirror/config.js'));

$codemirror = new \WysiwygEditor\CodeMirror($id);
$array_config = $codemirror->generateConfigurationArrayFromConfig();
$system_themes = $codemirror->getListOfFileBasedExtensions('system', 'css', 'css');
?>
<schlix-config:textbox config-key="str_config_schlix_selector"   label="<?= ___('Text Area Selector (CSS Class) - set it to wysiwyg for backend editing') ?>" config-default-value="wysiwyg" placeholder="<?= ___('e.g.') ?> wysiwyg ~ <?= ___('This option allows you to specify a CSS selector for the areas that CKEditor should make editable') ?>" />

<!-- begin tabs -->
<x-ui:schlix-tab-container>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_basic" fonticon="fas fa-stream" label="<?= ___('Basic Setup') ?>"> 
        <x-ui:row>            
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->

                <schlix-config:radiogroup  config-key="str_config_mode" label="<?= ___('Language') ?>" config-default-value="schlix" >
                    <schlix-config:option value="php">PHP</schlix-config:option>                        
                    <schlix-config:option value="htmlmixed">HTML</schlix-config:option>
                    <schlix-config:option value="js">Javascript</schlix-config:option>
                    <schlix-config:option value="css">CSS</schlix-config:option>
                    <schlix-config:option value="sql">SQL</schlix-config:option>
                </schlix-config:radiogroup>             

                <schlix-config:dropdownlist    config-key="str_config_theme" label="<?= ___('Theme') ?>" config-default-value="schlix" >
                    <schlix-config:option value="default"><?= ___('Default') ?></schlix-config:option>
                    <?php if ($system_themes): ?>
                        <?php foreach ($system_themes as $theme): ?>
                            <schlix-config:option value="<?= ___h($theme) ?>"><?= ___h($theme) ?></schlix-config:option>                        
                        <?php endforeach ?>
                    <?php endif ?>
                </schlix-config:dropdownlist>             
                <!-- end col content -->

            </x-ui:column>
            <!-- col -->
            <x-ui:column md="6">
                <!-- col content -->
                <schlix-config:checkbox config-key="bool_config_autoCloseBrackets" label="<?= ___('Auto-close brackets and quotes when typed. By default, it will auto-close ()[]{})') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_autoCloseTags" label="<?= sprintf(___S('Auto-close tags %s'), ___h('&lt;&gt;')) ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_autoFormatOnStart" label="<?= ___('Auto format on start') ?>" config-default-value="0" />
                <schlix-config:checkbox config-key="bool_config_autoFormatOnUncomment" label="<?= ___('Auto format un uncomment') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_continueComments" label="<?= ___('Sets whether the editor will make the next line continue a comment when you press Enter inside a comment block') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_enableCodeFolding" label="<?= ___('Enable code folding') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_enableCodeFormatting" label="<?= ___('Enable code formatting') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_enableSearchTools" label="<?= ___('Enable search tools') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_highlightMatches" label="<?= ___('Highlight matches') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_indentWithTabs" label="<?= ___('Enable search tools') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_lineNumbers" label="<?= ___('Show line numbers') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_lineWrapping" label="<?= ___('Enable line wrap') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_matchTags" label="<?= ___('Match tags') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_matchBrackets" label="<?= ___('Match Brackets') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_showAutoCompleteButton" label="<?= ___('Show autocomplete button') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_showSearchButton" label="<?= ___('Show search button with CTRL+F') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_showTrailingSpace" label="<?= ___('Show trailing space') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_showUncommentButton" label="<?= ___('Show uncomment button') ?>" config-default-value="1" />
                <schlix-config:checkbox config-key="bool_config_styleActiveLine" label="<?= ___('Enable line wrap') ?>" config-default-value="1" />


            </x-ui:column>

        </x-ui:row>
    </x-ui:schlix-tab>
    <!-- tab -->
    <x-ui:schlix-tab id="tab_scripts" fonticon="fas fa-code" label="<?= ___('Custom Scripts') ?>"> 

        <p><?= ___('The following is generated script from the previously saved configuration values') ?></p>
        <pre class="config">var __codemirror_config = {<?= ___h($codemirror->getUncachedConfigurationScript()); ?>,
// <?= ___('You can insert additional configuration options here (optional)') ?>
            <schlix-config:textarea config-key="str_additional_config"   />
}</pre>
        <hr />
        <h4><?= ___('Alternative configuration script') ?></h4>
        <p><?= ___('Replace the entire configuration script above with your own (caution!)') ?></p>
        <strong>var __codemirror_config = { //</strong>
        <schlix-config:textarea config-key="str_replacement_config"     style="min-height:400px" />
        <strong>}</strong>        

    </x-ui:schlix-tab>

</x-ui:schlix-tab-container> 

<schlix-config:checkbox config-key="reset_to_default" label="<?= ___('Reset to default settings') ?>"  />
<x-ui:row id="alert-reset-option" style="display:none">
    <x-ui:column md="6" class="alert alert-warning">
        <schlix-config:dropdownlist  config-key="reset_to_default_profile"   label="<?= ___('Reset the configuration to the following profile') ?>" config-default-value="<?= $possible_css_files[0] ?>" >
            <schlix-config:option value=""><?= ___('Please select') ?></schlix-config:option>
            <schlix-config:option value="php"><?= ___('PHP') ?></schlix-config:option>
            <schlix-config:option value="html"><?= ___('HTML') ?></schlix-config:option>
            <schlix-config:option value="javascript"><?= ___('Javascript') ?></schlix-config:option>
            <schlix-config:option value="css"><?= ___('CSS') ?></schlix-config:option>
        </schlix-config:dropdownlist> 
    </x-ui:column>
</x-ui:row>  