<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//


define('SCHLIX_INSTALLER','1.x');
error_reporting (E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR | E_USER_ERROR | E_RECOVERABLE_ERROR | E_PARSE | E_WARNING);
ini_set('display_errors','1');

define ('INSTALLER_ROOT_PATH',str_replace('\\', '/', realpath(str_replace('\\', '/', dirname(__FILE__)).'/..')));

include(INSTALLER_ROOT_PATH.'/system/libs/schlix/db.inc.php');
include(INSTALLER_ROOT_PATH.'/system/libs/schlix/schlix_util.inc.php');
include(INSTALLER_ROOT_PATH.'/system/libs/schlix/util.inc.php');
include(INSTALLER_ROOT_PATH.'/system/libs/schlix/html.inc.php');
include(INSTALLER_ROOT_PATH.'/system/libs/schlix/app_interface.php');
include(INSTALLER_ROOT_PATH.'/system/libs/schlix/app_basic.class.php');
include ('schlixinstaller.class.php');

//_________________________________________________________//
function RunInstaller()
{
    $installer = new schlixInstaller();
    if ((int) getenv('SCHLIX_AUTO_INSTALL') == 8 )
    {
        $installer->automatedInstall(
            getenv('SCHLIX_INSTALL_USER_AGREE_TERM'), 
            getenv('SCHLIX_INSTALL_DB_HOST'), 
            getenv('SCHLIX_INSTALL_DB_DATABASE'), 
            getenv('SCHLIX_INSTALL_DB_USERNAME'), 
            getenv('SCHLIX_INSTALL_DB_PASSWORD'), 
            
            getenv('SCHLIX_INSTALL_SITE_DOMAIN_NAME'), 
            (int) getenv('SCHLIX_INSTALL_SITE_USE_HTTPS'), 
            getenv('SCHLIX_INSTALL_SITE_HTTPBASE'), // usually blank if it's on the root path
            getenv('SCHLIX_INSTALL_SITE_NAME'), // Site name, e.g. Company XYZ
            getenv('SCHLIX_INSTALL_SITE_ROOT_FILE_PATH'),
            getenv('SCHLIX_INSTALL_SITE_ID'), // e.g. main
            
            getenv('SCHLIX_INSTALL_EMAIL_FROM'), 
            getenv('SCHLIX_INSTALL_EMAIL_ADDRESS'), 
            
            getenv('SCHLIX_INSTALL_ADMIN_USERNAME'), 
            getenv('SCHLIX_INSTALL_ADMIN_PASSWORD'), 
            
            (int) getenv('SCHLIX_INSTALL_USE_SAMPLE_DATA'), 
            
            (int) getenv('SCHLIX_INSTALL_HOST_USE_WILDCARD'), 
            getenv('SCHLIX_INSTALL_TIMEZONE'),
            (int) getenv('SCHLIX_INSTALL_HOST_ADD_WWW'),  // new - 2017 July 3
            // September 2019
            (int) getenv('SCHLIX_INSTALL_DB_PORT'),
            getenv('SCHLIX_INSTALL_DB_SOCKET'),
            (int) getenv('SCHLIX_INSTALL_DB_USE_SSL'),
            getenv('SCHLIX_INSTALL_DB_SSL_CA')
            
        );
        
    } else
    if (fpost_int('auto_install') === 9)
    {
        $installer->automatedInstall(
            fpost_string('agree_term'), 
            fpost_string('db_host'), 
            fpost_string('db_database'), 
            fpost_string('db_username'), 
            fpost_string('db_password'), 
            
            fpost_string('site_domain_name'), 
            fpost_string('site_use_https'), 
            fpost_string('site_httpbase'),
            fpost_string('site_name'), 
            fpost_string('site_root_file_path'), 
            fpost_string('site_id'), 
            
            fpost_string('email_from'), 
            fpost_string('email_address'), 
            
            fpost_string('admin_username'), 
            fpost_string('admin_password'), 
            
            fpost_bool('sampledata'), 
            
            fpost_bool('use_wildcard'), 
            fpost_string('timezone'),
            fpost_bool('use_www'),  // new - 2017 July 3
            // September 2019
            fpost_int('db_port'),
            fpost_string('db_socket'),
            fpost_int('db_use_ssl'),
            fpost_string('db_ssl_ca')
            
        );
        
    } else
    {
        
        global $_html_title;

        ob_start();
        $installer->Run($_GET);
            $__html_output = ob_get_contents();
            ob_end_clean();

        if (!is_ajax_request())
            include('master.template.php');
        else
            echo $__html_output;
    }
}
//_________________________________________________________//
    // If another script includes this PHP file and defines SCHLIX_AUTO_INSTALL_CMD_INCLUDE, 
    // then it won't run the installer and let the installer performs the automation
    // this excludes auto install method where it uses HTTP POST

    if (!defined('SCHLIX_AUTO_INSTALL_CMD_INCLUDE') )
    {
        RunInstaller();
    } 

//_________________________________________________________//
 
