<?php
if (!defined('SCHLIX_INSTALLER')) die('Please visit /install/');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

?>
<h2>Server Requirement</h2>
<ul class="list-unstyled">
    <li><?= $this->indicateYesNoWithPicture($req['php50']); ?>&nbsp; PHP version 5.6 or above (recommended: v7.2+). Current version: <strong><?= PHP_VERSION ?></strong> </li>
    <li><?= $this->indicateYesNoWithPicture($req['mysql']); ?>&nbsp; MySQL/MariaDB (v5.7.7 or greater recommended, compatible with MySQL 8.0)</li>
    <li><?= $this->indicateYesNoWithPicture($req['mod_rewrite']); ?>&nbsp; mod_rewrite</li>
    <li><?= $this->indicateYesNoWithPicture($req['mbstring']); ?>&nbsp; multi-byte string (recommended, not required)</li>
    <li><?= $this->indicateYesNoWithPicture($req['configincphp']); ?>&nbsp; Can write to multisite-config.inc.php</li>
    <li><?= $this->indicateYesNoWithPicture($req['gd']); ?>&nbsp; gd image library</li>
    <li><?= $this->indicateYesNoWithPicture($req['zlib']); ?>&nbsp; ZLib compression library</li>
    <li><?= $this->indicateYesNoWithPicture($req['json']); ?>&nbsp; JSON library</li>
    <li><?= $this->indicateYesNoWithPicture($req['dom']); ?>&nbsp; DOM library</li>
    <li><?= $this->indicateYesNoWithPicture($req['simplexml']); ?>&nbsp; SimpleXML library</li>
    <li><?= $this->indicateYesNoWithPicture($req['bcrypt']); ?>&nbsp; Blowfish encryption</li>            
    <li><?= $this->indicateYesNoWithPicture($req['htaccess']); ?>&nbsp; .htaccess file exists</li>            
</ul>

<div class="clearboth"></div>
<?php if ($_SESSION['met_requirement']): ?>
<br />
<div class="alert alert-success"><i class="fas fa-check-circle"></i>&nbsp; The server seems to have met all the requirements to run this software</div>
<p>It is also recommended to have one of the following: <a href="http://www.suphp.org" target="_blank">suPHP</a>, suExec, or <a href="https://php-fpm.org" target="_blank">PHP-FPM</a> installed to make it easier to work with file permissions. SCHLIX CMS needs to write to <strong>/system</strong> for auto-update and <strong>/web</strong> folder for cache, data, and image uploads. It also needs to be able to re-configure multi-site.config.inc.php as well. Most hosting provider has one of those modules available.</p>

    <p>Please enter the database information and test it!</p>

    <h2>Database</h2>
        <div id="db_test_msg">            
        </div>
    
    <div class="form-horizontal">
        <!-- input -->
        <div class="form-group">
            <label for="db_host" class="control-label col-xs-3">Host</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-server"></i>
                    </span>
                    <input class="form-control" placeholder="Host name (e.g. localhost, mysql.servername.com)" name="db_host"  id="db_host" type="text" autofocus="1" required="required" value="<?= ___h($_SESSION['db_host']) ?>" />
                    
                </div>
            </div>
        </div>
        <!-- input -->
        <div class="form-group">
            <label for="db_database" class="control-label col-xs-3">Database</label>
            <div class="col-xs-7">
                <div class="input-group">

                    <span class="input-group-addon">
                        <i class="fas fa-database"></i>
                    </span>
                    <input class="form-control" placeholder="Database name" name="db_database"  id="db_database" type="text" autofocus="1" required="required" value="<?= ___h(fsession_string('db_database')) ?>" />
                </div>
            </div>
        </div>

        <!-- input -->
        <div class="form-group">
            <label for="db_username" class="control-label col-xs-3">Username</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-user"></i>
                    </span>
                    <input class="form-control" placeholder="Username" name="db_username" id="db_username" type="text" required="required" value="<?= ___h(fsession_string('db_username')) ?>" />
                </div>                
            </div>
        </div>

        <!-- input -->
        <div class="form-group">
            <label for="db_password" class="control-label col-xs-3">Password</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-lock"></i>
                    </span>
                    <input class="form-control" placeholder="Password" name="db_password" id="db_password" type="password" required="required" value="<?= ___h(fsession_string('db_password')) ?>" />
                </div>                
            </div>
        </div>
        
        <fieldset>
            <legend>Advanced Options</legend>
            <p>Please leave the following parameters blank unless it's required. </p>
        <!-- port -->
            <div class="form-group">
                <label for="db_socket" class="control-label col-xs-3">Port Number</label>
                <div class="col-xs-7">
                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fas fa-project-diagram"></i>
                        </span>
                        <input class="form-control" placeholder="3306" name="db_port"  id="db_port" type="number" min="1" max="65535" value="<?= ___h(fsession_int('db_port')) ?>" />

                    </div>
                </div>                
            </div>        
            <!-- socket -->
            <div class="form-group">
                <label for="db_socket" class="control-label col-xs-3">Database socket</label>
                <div class="col-xs-7">
                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fas fa-server"></i>
                        </span>
                        <input class="form-control" placeholder="/var/run/mysqld/mysqld.socket" name="db_socket"  id="db_socket" type="text" value="<?= ___h(fsession_string('db_socket')) ?>" />

                    </div>
                </div>
            </div>

            <!-- ssl -->
            <div class="form-group">
                <label for="db_ssl_ca" class="control-label col-xs-3">Database connection uses SSL</label>
                <div class="col-xs-7">
                    <div class="input-group">
                        <span class="input-group-addon">
                            <input type="checkbox" name="db_use_ssl" id="db_use_ssl" value="1" <?= (fsession_int('db_use_ssl') > 0) ? 'checked="checked"' : '' ?> title="Usually this is required by Azure" />Yes
                        </span>
                        <span class="input-group-addon">
                            <i class="fas fa-file"></i> SSL CA certificate file path
                        </span>
                        <input class="form-control" placeholder="/var/www/mysql/ca.pem" name="db_ssl_ca"  id="db_ssl_ca" type="text" value="<?= ___h(fsession_string('db_ssl_ca')) ?>" />

                    </div>                     
                </div>

            </div>
            
        </fieldset>
        <hr />
        <div class="form-group">
            <div class="col-xs-offset-2 col-xs-7 text-center">
                <button type="submit" name="submit" id="testdatabasebutton" value="Submit" class="btn btn-warning" /><i class="fas fa-question"></i> Test it</button>
                &nbsp;
                <a id="continue_to_next_step" href="index.php?action=variables" class="btn btn-success" <?php if (!fsession_bool('req_database_ok')) echo ' style="display:none" '; ?>><i class="fas fa-arrow-circle-right"></i> Continue Installation</a>
            </div>
        </div>
        

    </div>


<?php else: ?>
    <div class="alert alert-danger">Basic requirement not met. Installation is halted.</div>  
<?php endif; ?>

