<?php
if (!defined('SCHLIX_VERSION')) die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
?>
<div class="content">
<h1><?= ___('Active Sessions in the last 5 minutes') ?></h1>
<?php if ($active_sessions): ?>
<table class="table table-bordered table-striped table-responsive" id="activ-sessions">
    <th><?= ___('ID') ?></th>
    <th><?= ___('Host Name') ?></th>    
    <th><?= ___('IP Address') ?></th>    
    <th><?= ___('Browser') ?></th>
<?php foreach ($active_sessions as $session): ?>
    <tr>
        <td><?= $session['id'] ?></td>
        <td><?= @gethostbyaddr($session['ip_address']) ?></td>        
        <td><?= $session['ip_address'] ?></td>
        <td><?= ___h($session['user_agent']) ?></td>
    </tr>
<?php endforeach ?>
</table>
<?php else: ?>
<?= ___('No active session') ?>
<?php endif ?>
</div>