<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
global $HTMLHeader, $CurrentUser;
if ($id == 'new') {
    $item['permission_read'] = serialize('everyone');
    $header_title = ___('New Item');
} else {
    $id = (int) $id;
    $preview_link = $this->app->createFriendlyURL("action=viewitem&id={$id}");
    $header_title = ___('Edit Item').' #'.___h($id);
}

$category_text = '';
$field_category_id = $this->app->getFieldCategoryID();
if ($item['category_id'] > 0) {
    $category_text = $this->app->createFriendlyURL("action=viewcategory&{$field_category_id}={$item['category_id']}");
}
$parent_category_text = $this->getItemParentURLPathPreviewLink($item); 

$schema_org_types = $this->opt_contacts_schema_org_types;

// as of 2019
//$HTMLHeader->CSS_EXTERNAL('https://map.schlix.website/1/leaflet.css','all');
//$HTMLHeader->CSS_EXTERNAL('https://map.schlix.website/1/Control.Geocoder.css','all');
//$HTMLHeader->JAVASCRIPT_EXTERNAL('https://map.schlix.website/1/leaflet.js');
//$HTMLHeader->JAVASCRIPT_EXTERNAL('https://map.schlix.website/1/Control.Geocoder.js');
// as of 2023
$this->CSS('leaflet/leaflet.css');
$this->CSS('leaflet/Control.Geocoder.css');
$this->JAVASCRIPT('leaflet/leaflet.js');
$this->JAVASCRIPT('leaflet/Control.Geocoder.js');

/** quick fix **/
if ((int) $item['map_zoom'] == 0)
    $item['map_zoom'] = 17;
?>

<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.ContactsAdmin">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>" >
        
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:hidden id="category_id" data-field="category_id" name="category_id" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     <x-ui:schlix-document-title id="title" maxlength="191"  required="required"  data-field="title" table-type="item" />
                    <!-- Virtual Filename -->
                    <x-ui:schlix-document-virtual-filename id="virtual_filename" full-url="1"  data-field="virtual_filename" name="virtual_filename" />
                    
                <label for="schema_org_type"><?= ___('Indicate to search engines that this place is a '); ?></label>
                <x-ui:select data-options-var="schema_org_types" data-field="schema_org_type" id="schema_org_type" name="schema_org_type" />
                
                    
                <br />
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="fas fa-address-card" label="<?= ___('Content') ?>"> 
                    
                    
                    
                    <x-ui:row>
                        <x-ui:column md="6">
                            <!-- content -->
                                <x-ui:textbox label="<?= ___('Branch/Building Name'); ?>" id="branch" name="branch" data-field="branch" />                                
                                <x-ui:textbox label="<?= ___('Contact Person'); ?>" id="contact_person" name="contact_person" data-field="contact_person" />
                                <x-ui:textbox label="<?= ___('PO Box'); ?>"  id="pobox" name="pobox"  data-field="pobox" />
                                <x-ui:textbox label="<?= ___('Street Address'); ?>"  name="street" id="street"  data-field="street" />
                                <x-ui:textbox label="<?= ___('City'); ?>"  id="city" name="city" data-field="city" />
                                <x-ui:textbox label="<?= ___('Province/State'); ?>"  name="province" id="province" data-field="province" />
                                <x-ui:textbox label="<?= ___('Postal/Zip Code'); ?>"  name="postal" id="postal" data-field="postal" />
                                <x-ui:textbox label="<?= ___('Country'); ?>"  id="country" name="country" data-field="country" />
                            
                            <!-- end content -->
                        </x-ui:column>
                        <x-ui:column md="6">
                            <!-- content -->
                                <x-ui:textbox label="<?= ___('Toll Free'); ?>"  id="tollfree" name="tollfree" data-field="tollfree" />
                                <x-ui:textbox label="<?= ___('Phone'); ?>"  id="phone" name="phone" data-field="phone" />
                                <x-ui:textbox label="<?= ___('Fax'); ?>"  id="fax" name="fax" data-field="fax" />
                                <x-ui:textbox label="<?= ___('Mobile'); ?>"  id="mobile" name="mobile"  data-field="mobile"  />
                                <x-ui:textbox label="<?= ___('E-mail').' - '.___('please ensure that this is a valid e-mail address'); ?>"  id="email" name="email" data-field="email" type="email" required="required" />
                                
                                <x-ui:checkbox name="display_email" data-field="display_email" value="1" label="<?= ___('Display E-mail Address') ?>" />
                            <!-- end content -->
                        </x-ui:column>
                    </x-ui:row> 
                    <!-- end tab1 -->                    
                </x-ui:schlix-tab>
                
                <x-ui:schlix-tab id="tab_content" fonticon="far fa-file-alt" label="<?= ___('Content') ?>"> 
                    <x-ui:wysiwyg id="additional_info" name="additional_info" data-field="additional_info" label="<?= ___('Additional Info') ?>" />                    
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_map" fonticon="fas fa-map-marker-alt" label="<?= ___('Map') ?>">
                    <!-- map -->
                    <x-ui:row>
                        <x-ui:column sm="4" md="2">
                            
                            <x-ui:textbox type="number" id="map_zoom"  name="map_zoom" data-field="map_zoom" label="<?= ___('Zoom Level'); ?>" />
                            <x-ui:textbox id="latitude"  name="latitude" data-field="latitude" label="<?= ___('Latitude'); ?>" />
                            <x-ui:textbox id="longitude"  name="longitude" data-field="longitude" label="<?= ___('Longitude'); ?>" />                            
                            <!-- field -->
                            <?php /*<p><?= ___('Display map in the contact form'); ?>
                                <x-ui:radio name="display_map" data-field="display_map" id="display_map_yes" value="1" required="required" label="<?= ___('Yes') ?>" />
                                <x-ui:radio name="display_map" data-field="display_map" id="display_map_no" value="0" required="required" label="<?= ___('No') ?>"  />                                    
                            </p>*/ ?>
                            <x-ui:checkbox name="display_map" data-field="display_map" value="1" label="<?= ___('Display map in the contact form') ?>" />
                            <hr />
                            <a id="btn_update_map" class="btn btn-info" href="javascript:void(0)"><i class="fas fa-sync"></i> <?= ___('Update') ?></a> 
                            <hr />
                            
                        </x-ui:column>
                        <!-- column -->
                        <x-ui:column sm="8" md="10">
                            
                            <div id="map_canvas" style="width:100%;height:400px" >

                            </div>                    
                             <p><?= ___('Click the Update Location button above to get the latitude and longitude of the place by *street address*. You can move and drag or double click the marker around to reflect a more accurate location.'); ?></p>
                    <p><?= ___('Note: Width and Height of the map display on the frontend must be set from your own template CSS!') ?></p>

                        </x-ui:column>
                    </x-ui:row>

                    <!-- end map -->
                </x-ui:schlix-tab>
                <!-- tab -->
                
                <x-ui:schlix-tab id="tab_incoming_messages" fonticon="fa fa-envelope" label="<?= ___('Incoming Messages') ?>">
                    <?php include('edit.item.messages.template.php') ?>
                </x-ui:schlix-tab>         
                <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor> 