<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php $app = $this->app_name; ?>
<div class="schlix-explorer">
    <x-ui:schlix-data-explorer-hierarchical-treelist id="schlix-<?= $this->app->getApplicationNameOnly() ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.ContactsAdmin" data-main-app-description="<?= $this->app->getApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>" data-default-item-icon="far fa-address-card fa-2x">
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-item" data-schlix-app-action="newitem"   fonticon="far fa-address-card text-blue" label="<?= ___('New Contact') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-category" data-schlix-app-action="newcategory" fonticon="fas fa-folder-plus text-orange" label="<?= ___('New Category') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="edit-current-category" data-schlix-app-action="editcategory" require-category="1" fonticon="fas fa-pencil-alt text-orange" label="<?= ___('Edit Current Category') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="cut" require-selected-items="1" fonticon="fa fa-cut" label="<?= ___('Cut') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="copy" require-selected-items="1" fonticon="fa fa-copy" label="<?= ___('Copy') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-gears" label="<?= ___('Configuration') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Default Settings') ?>" />
                    <x-ui:schlix-explorer-menu-command data-schlix-command="custom-table-config" data-custom-table="gk_contact_items" fonticon="fas fa-terminal" label="<?= ___('Custom table fields: Contact') ?>" />
                    <x-ui:schlix-explorer-menu-command data-schlix-command="custom-table-config" data-custom-table="gk_contact_messages"  fonticon="fas fa-terminal" label="<?= ___('Custom table fields: Messages') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>
        </x-ui:schlix-explorer-toolbar>
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Left Column -->
            <x-ui:schlix-explorer-left-column>
                <!-- treeview -->
                <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
                <!-- end column -->
            </x-ui:schlix-explorer-left-column>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="title" data-default-sort-direction="asc">
                <x-ui:schlix-data-table-columns>
                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <x-ui:schlix-data-table-column key="title" sortable="true" label="<?= ___('Title') ?>" formatter="this.formatDataTableCell_DefaultTitleColumn" />

                        <x-ui:schlix-data-table-column key="this.field_category_id" hidden="true" sortable="false" formatter="number" />
                        <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                        <x-ui:schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />

                        <x-ui:schlix-data-table-column key="sort_order" label="<?= ___('Sort Order') ?>" sortable="true" formatter="number" editor="new SCHLIX.UI.TextboxCellEditor({validator:SCHLIX.UI.DataTable.validateNumber,disableBtns:false})" />

                        <x-ui:schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor( {disableBtns:false})" />
                        <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date"  />
                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->
    </x-ui:schlix-data-explorer-hierarchical-treelist>


</div>

