<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
	if (!defined('SCHLIX_VERSION')) die('No Access');        
?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-main; ?>" >   
    <!-- ########################################################################### -->
    <!-- ####################### main info of this category  ####################### -->
    <!-- ########################################################################### -->
    <article class="main category">
        <?= $this->getConfig('str_mainpage_text') ?>
    </article>
    <!-- ########################################################################### -->
    <!-- ######################## end info of this category  ####################### -->
    <!-- ########################################################################### -->
    <?php if (isset($categories)): ?>
    <!-- ########################################################################### -->
    <!-- ################## child categories / subfolder ########################### -->
    <!-- ########################################################################### -->
        <div class="main categories">
            <?php foreach ($categories as $category): ?>
                <?php if ($category['status'] > 0): ?>            
                <section class="child-category"> 
                    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>                    
                    <?php 
                    
                        $category_id = $category[$this->getFieldCategoryID()];
                        $this->processDataOutputWithMacro($category, 'viewChildCategory', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$category_id}");
                        $category_title = ___h($category['title']);
                        $category_title_text = ($category_meta_options['display_child_category_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($category_title,$link) : $category_title;
                        
                    ?>
                    <h2 class="category title"><i class="fas fa-folder"></i> <?= $category_title_text; ?></h2>

                    <?php if ($category_meta_options['display_child_category_read_more_link']): ?>
                        <a class="child category" href="<?= $link; ?>"><?= ___('Read More'); ?></a>
                    <?php endif; ?>
                    <!-- Macro - Pre -->
                    <?php if ($category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($category['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->                
                    <?= $category['macro_processed_text_outside_article_bottom'] ?> 
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ########################################################################### -->
    <!-- ################## end child categories / subfolder ####################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    <?php if ($items):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="main items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item">    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?> 
                    <?php 
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item['id']}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        
                    ?>
                    <h2 class="item title"><i class="fa fa-map"></i> <?= $child_item_title_text; ?></h2>

                    <?php if ($category_meta_options['display_child_item_read_more_link']): ?>
                        <a class="child category" href="<?= $link; ?>"><?= ___('Read More'); ?></a>
                    <?php endif; ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $child_item['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post --> 
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?> 
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif ?>
    <!-- pagination -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$category['cid']}"); ?>
    <?php if ($pagination_str && ($category_meta_options['display_child_categories'] || $category_meta_options['display_items'])): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif ?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>